/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.core.JanusGraphElement;

public class ResultSetIterator<R extends JanusGraphElement>
implements CloseableIterator<R> {
    private final Iterator<R> iterator;
    private final int limit;
    private R current;
    private R next;
    private int count;

    public ResultSetIterator(Iterator<R> inner, int limit) {
        this.iterator = inner;
        this.limit = limit;
        this.count = 0;
        this.current = null;
        this.next = this.nextInternal();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private R nextInternal() {
        JanusGraphElement r = null;
        if ((this.limit == Integer.MAX_VALUE || this.count < this.limit) && this.iterator.hasNext()) {
            r = (JanusGraphElement)this.iterator.next();
        } else {
            this.close();
        }
        return (R)r;
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        ++this.count;
        this.next = this.nextInternal();
        return this.current;
    }

    public void remove() {
        if (this.current == null) {
            throw new UnsupportedOperationException();
        }
        this.current.remove();
    }

    public void close() {
        CloseableIterator.closeIterator(this.iterator);
    }

    public static <R extends JanusGraphElement> Iterable<R> wrap(Iterable<R> inner, int limit) {
        return () -> new ResultSetIterator(inner.iterator(), limit);
    }
}

