/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.PropertiesStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.optimize.step.util.PropertiesFetchingUtil;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.CopyStepUtil;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class JanusGraphPropertiesStep<E>
extends PropertiesStep<E>
implements HasStepFolder<Element, E>,
Profiling,
MultiQueriable<Element, E> {
    private boolean useMultiQuery = false;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private PropertiesStepBatchFetcher propertiesStepBatchFetcher;
    private int batchSize = Integer.MAX_VALUE;
    private final boolean prefetchAllPropertiesRequired;
    private final Set<String> propertyKeysSet;
    private final boolean prefetchingAllowed;
    private final ArrayList<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphPropertiesStep(PropertiesStep<E> originalStep, boolean prefetchAllPropertiesRequired, boolean prefetchingAllowed) {
        super(originalStep.getTraversal(), originalStep.getReturnType(), originalStep.getPropertyKeys());
        CopyStepUtil.copyAbstractStepModifiableFields(originalStep, this);
        this.prefetchAllPropertiesRequired = prefetchAllPropertiesRequired;
        this.prefetchingAllowed = prefetchingAllowed;
        this.propertyKeysSet = new HashSet<String>(Arrays.asList(this.getPropertyKeys()));
        if (originalStep instanceof JanusGraphPropertiesStep) {
            JanusGraphPropertiesStep originalJanusGraphPropertiesStep = (JanusGraphPropertiesStep)originalStep;
            this.setBatchSize(originalJanusGraphPropertiesStep.batchSize);
            this.setUseMultiQuery(originalJanusGraphPropertiesStep.useMultiQuery);
            this.hasContainers = originalJanusGraphPropertiesStep.hasContainers;
            this.limit = originalJanusGraphPropertiesStep.limit;
        } else {
            this.hasContainers = new ArrayList();
            this.limit = Integer.MAX_VALUE;
        }
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        boolean bl = this.useMultiQuery = this.prefetchingAllowed && useMultiQuery;
        if (this.useMultiQuery && this.propertiesStepBatchFetcher == null) {
            this.propertiesStepBatchFetcher = new PropertiesStepBatchFetcher(this::makeQuery, this.batchSize);
        }
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    private <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        return this.makeQuery(query, this.prefetchAllPropertiesRequired);
    }

    private <Q extends BaseVertexQuery> Q makeQuery(Q query, boolean prefetchAllPropertiesRequired) {
        query = PropertiesFetchingUtil.makeBasePropertiesQuery(query, prefetchAllPropertiesRequired, this.propertyKeysSet, this.getPropertyKeys(), this.queryProfiler);
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        return query;
    }

    private Iterator<E> convertIterator(Iterable<? extends Property> iterable) {
        return this.convertIterator(iterable, this.prefetchAllPropertiesRequired);
    }

    private Iterator<E> convertIterator(Iterable<? extends Property> iterable, boolean prefetchAllPropertiesRequired) {
        Iterator<? extends Property> propertiesIt = PropertiesFetchingUtil.filterPropertiesIfNeeded(iterable.iterator(), prefetchAllPropertiesRequired, this.propertyKeysSet);
        if (this.getReturnType().forProperties()) {
            return propertiesIt;
        }
        assert (this.getReturnType().forValues());
        return Iterators.transform(propertiesIt, Property::value);
    }

    protected Iterator<E> flatMap(Traverser.Admin<Element> traverser) {
        Iterator iterator;
        Element elementToFetchDataFor = (Element)traverser.get();
        if (this.useMultiQuery && elementToFetchDataFor instanceof Vertex) {
            return this.convertIterator((Iterable)this.propertiesStepBatchFetcher.fetchData(this.getTraversal(), (Vertex)elementToFetchDataFor, JanusGraphTraverserUtil.getLoops(traverser)));
        }
        if (elementToFetchDataFor instanceof JanusGraphVertex || elementToFetchDataFor instanceof WrappedVertex) {
            JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(JanusGraphTraversalUtil.getJanusGraphVertex(traverser).query(), false);
            return this.convertIterator(query.properties(), false);
        }
        if (this.getReturnType().forValues()) {
            assert (this.orders.isEmpty() && this.hasContainers.isEmpty());
            iterator = elementToFetchDataFor.values(this.getPropertyKeys());
        } else {
            assert (this.orders.isEmpty());
            Iterator propertiesIt = elementToFetchDataFor.properties(this.getPropertyKeys());
            if (this.hasContainers.isEmpty()) {
                iterator = propertiesIt;
            } else {
                LinkedList properties = new LinkedList();
                propertiesIt.forEachRemaining(e -> {
                    if (HasContainer.testAll((Property)e, this.hasContainers)) {
                        properties.add(e);
                    }
                });
                iterator = properties.iterator();
            }
        }
        if (this.limit != Integer.MAX_VALUE) {
            iterator = Iterators.limit((Iterator)iterator, (int)this.limit);
        }
        return iterator;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.propertiesStepBatchFetcher != null) {
            this.propertiesStepBatchFetcher.setBatchSize(batchSize);
        }
    }

    @Override
    public void ensureAdditionalHasContainersCapacity(int additionalSize) {
        this.hasContainers.ensureCapacity(this.hasContainers.size() + additionalSize);
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }

    @Override
    public List<HasContainer> addLocalHasContainersConvertingAndPContainers(TraversalParent parent, List<HasContainer> localHasContainers) {
        throw new UnsupportedOperationException("addLocalAll is not supported for properties step.");
    }

    @Override
    public List<HasContainer> addLocalHasContainersSplittingAndPContainers(TraversalParent parent, Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for properties step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(TraversalParent parent, List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("LocalOrderBy is not supported for properties step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(TraversalParent parent, List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("LocalLimit is not supported for properties step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for properties step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

