/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraphFactory;

public class JanusGraphConstants {
    public static final String JANUSGRAPH_PROPERTIES_FILE = "janusgraph.internal.properties";
    public static final String VERSION;
    public static final List<String> TITAN_COMPATIBLE_VERSIONS;
    public static final String JANUSGRAPH_ID_STORE_NAME = "janusgraph_ids";
    public static final String TITAN_ID_STORE_NAME = "titan_ids";
    public static final String STORAGE_VERSION;
    public static final Set<String> UPGRADEABLE_FIXED;

    static List<String> getCompatibleVersions(Properties props, String key) {
        List b = Stream.of(props.getProperty(key, "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return Collections.unmodifiableList(b);
    }

    static Set<String> getPropertySet(Properties props, String key) {
        Set buildSet = Stream.of(props.getProperty(key, "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        return Collections.unmodifiableSet(buildSet);
    }

    static {
        Package p = JanusGraphConstants.class.getPackage();
        Preconditions.checkNotNull((Object)p, (Object)("Unable to load package containing class " + JanusGraphConstants.class));
        String packageName = p.getName();
        Preconditions.checkNotNull((Object)packageName, (Object)("Unable to get name of package containing " + JanusGraphConstants.class));
        String resourceName = packageName.replace('.', '/') + "/" + JANUSGRAPH_PROPERTIES_FILE;
        Properties props = new Properties();
        try (InputStream is = JanusGraphFactory.class.getClassLoader().getResourceAsStream(resourceName);){
            Preconditions.checkNotNull((Object)is, (Object)("Unable to locate classpath resource " + resourceName + " containing JanusGraph version"));
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load properties from " + resourceName, e);
        }
        VERSION = props.getProperty("janusgraph.version");
        STORAGE_VERSION = props.getProperty("janusgraph.storage-version");
        TITAN_COMPATIBLE_VERSIONS = JanusGraphConstants.getCompatibleVersions(props, "titan.compatible-versions");
        UPGRADEABLE_FIXED = JanusGraphConstants.getPropertySet(props, "janusgraph.upgradeable-fixed");
    }
}

