/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class OrderLimitStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final OrderLimitStrategy INSTANCE = new OrderLimitStrategy();
    private static Set<Class<? extends Step>> LEGAL_STEPS = new HashSet<Class>(Arrays.asList(LabelStep.class, IdStep.class, PathStep.class, SelectStep.class, SelectOneStep.class, SackStep.class, TreeStep.class));

    private OrderLimitStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        List<OrderGlobalStep> orders = TraversalHelper.getStepsOfClass(OrderGlobalStep.class, traversal);
        for (OrderGlobalStep order : orders) {
            RangeGlobalStep range = null;
            Step<Object, ?> currentStep = order.getNextStep();
            while (true) {
                if (currentStep instanceof RangeGlobalStep) {
                    range = (RangeGlobalStep)currentStep;
                    break;
                }
                if (!LEGAL_STEPS.contains(currentStep.getClass())) break;
                currentStep = currentStep.getNextStep();
            }
            if (null == range) continue;
            order.setLimit(range.getHighRange());
        }
    }

    public static OrderLimitStrategy instance() {
        return INSTANCE;
    }
}

