/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import java.io.IOException;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class GeometryCollectionSerializer
extends GeoshapeTypeSerializer {
    public GeometryCollectionSerializer() {
        super(8);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int nrShapes = buffer.readInt();
        ShapeFactory.MultiShapeBuilder<Shape> geometryCollectionBuilder = Geoshape.getGeometryCollectionBuilder();
        for (int i = 0; i < nrShapes; ++i) {
            Geoshape shape = (Geoshape)context.readValue(buffer, Geoshape.class, true);
            geometryCollectionBuilder.add(shape.getShape());
        }
        return Geoshape.geoshape(geometryCollectionBuilder.build());
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) throws IOException {
        ShapeCollection shapeCollection = (ShapeCollection)geoshape.getShape();
        List shapes = shapeCollection.getShapes();
        buffer.writeInt(shapes.size());
        for (Shape shape : shapes) {
            Geoshape geoshapeMember = Geoshape.geoshape(shape);
            context.writeValue((Object)geoshapeMember, buffer, true);
        }
    }
}

