/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.hbase.HBaseKeyColumnValueStore;
import org.janusgraph.diskstorage.hbase.HBaseTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.hadoop.HBaseHadoopStoreManager;
import org.janusgraph.util.system.IOUtils;
import org.janusgraph.util.system.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class HBaseStoreManager
extends DistributedStoreManager
implements KeyColumnValueStoreManager {
    private static final Logger logger = LoggerFactory.getLogger(HBaseStoreManager.class);
    public static final ConfigNamespace HBASE_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "hbase", "HBase storage options");
    public static final ConfigOption<Boolean> SHORT_CF_NAMES = new ConfigOption(HBASE_NS, "short-cf-names", "Whether to shorten the names of JanusGraph's column families to one-character mnemonics to conserve storage space", ConfigOption.Type.FIXED, (Object)true);
    public static final String COMPRESSION_DEFAULT = "-DEFAULT-";
    public static final ConfigOption<String> COMPRESSION = new ConfigOption(HBASE_NS, "compression-algorithm", "An HBase Compression.Algorithm enum string which will be applied to newly created column families. The compression algorithm must be installed and available on the HBase cluster.  JanusGraph cannot install and configure new compression algorithms on the HBase cluster by itself.", ConfigOption.Type.MASKABLE, (Object)"GZ");
    public static final ConfigOption<Boolean> SKIP_SCHEMA_CHECK = new ConfigOption(HBASE_NS, "skip-schema-check", "Assume that JanusGraph's HBase table and column families already exist. When this is true, JanusGraph will not check for the existence of its table/CFs, nor will it attempt to create them under any circumstances.  This is useful when running JanusGraph without HBase admin privileges.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<String> HBASE_TABLE = new ConfigOption(HBASE_NS, "table", "The name of the table JanusGraph will use.  When " + ConfigElement.getPath(SKIP_SCHEMA_CHECK, (String[])new String[0]) + " is false, JanusGraph will automatically create this table if it does not already exist. If this configuration option is not provided but graph.graphname is, the table will be set to that value.", ConfigOption.Type.LOCAL, (Object)"janusgraph");
    public static final ConfigOption<String> HBASE_SNAPSHOT = new ConfigOption(HBASE_NS, "snapshot-name", "The name of an existing HBase snapshot to be used by HBaseSnapshotInputFormat", ConfigOption.Type.LOCAL, (Object)"janusgraph-snapshot");
    public static final ConfigOption<String> HBASE_SNAPSHOT_RESTORE_DIR = new ConfigOption(HBASE_NS, "snapshot-restore-dir", "The temporary directory to be used by HBaseSnapshotInputFormat to restore a snapshot. This directory should be on the same File System as the HBase root dir.", ConfigOption.Type.LOCAL, (Object)System.getProperty("java.io.tmpdir"));
    public static final int MIN_REGION_COUNT = 3;
    public static final ConfigOption<Integer> REGION_COUNT = new ConfigOption(HBASE_NS, "region-count", "The number of initial regions set when creating JanusGraph's HBase table", ConfigOption.Type.MASKABLE, Integer.class, input -> null != input && 3 <= input);
    public static final ConfigOption<Integer> REGIONS_PER_SERVER = new ConfigOption(HBASE_NS, "regions-per-server", "The number of regions per regionserver to set when creating JanusGraph's HBase table", ConfigOption.Type.MASKABLE, Integer.class);
    public static final int PORT_DEFAULT = 2181;
    public static final TimestampProviders PREFERRED_TIMESTAMPS = TimestampProviders.MILLI;
    public static final ConfigNamespace HBASE_CONFIGURATION_NAMESPACE = new ConfigNamespace(HBASE_NS, "ext", "Overrides for hbase-{site,default}.xml options", true);
    private static final StaticBuffer FOUR_ZERO_BYTES = BufferUtil.zeroBuffer((int)4);
    private final BiMap<String, String> shortCfNameMap;
    private final TableName tableName;
    private final String compression;
    private final int regionCount;
    private final int regionsPerServer;
    private final Connection cnx;
    private final boolean shortCfNames;
    private final boolean skipSchemaCheck;
    private DistributedStoreManager.Deployment deployment = null;
    private final Configuration hconf;
    private static final ConcurrentHashMap<HBaseStoreManager, Throwable> openManagers = new ConcurrentHashMap();
    private final ConcurrentMap<String, HBaseKeyColumnValueStore> openStores;

    public HBaseStoreManager(org.janusgraph.diskstorage.configuration.Configuration config) throws BackendException {
        super(config, 2181);
        this.shortCfNameMap = HBaseStoreManager.createShortCfMap(config);
        Preconditions.checkArgument((null != this.shortCfNameMap ? 1 : 0) != 0);
        Set shorts = this.shortCfNameMap.values();
        Preconditions.checkArgument((Sets.newHashSet((Iterable)shorts).size() == shorts.size() ? 1 : 0) != 0);
        this.tableName = this.determineTableName(config);
        this.compression = (String)config.get(COMPRESSION, new String[0]);
        this.regionCount = config.has(REGION_COUNT, new String[0]) ? (Integer)config.get(REGION_COUNT, new String[0]) : -1;
        this.regionsPerServer = config.has(REGIONS_PER_SERVER, new String[0]) ? (Integer)config.get(REGIONS_PER_SERVER, new String[0]) : -1;
        this.skipSchemaCheck = (Boolean)config.get(SKIP_SCHEMA_CHECK, new String[0]);
        if (config.has(REGIONS_PER_SERVER, new String[0]) && config.has(REGION_COUNT, new String[0])) {
            logger.warn("Both {} and {} are set in JanusGraph's configuration, but the former takes precedence and the latter will be ignored.", REGION_COUNT, REGIONS_PER_SERVER);
        }
        this.hconf = HBaseConfiguration.create();
        int keysLoaded = 0;
        Map configSub = config.getSubset(HBASE_CONFIGURATION_NAMESPACE, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            logger.info("HBase configuration: setting {}={}", entry.getKey(), entry.getValue());
            if (entry.getValue() == null) continue;
            this.hconf.set((String)entry.getKey(), entry.getValue().toString());
            ++keysLoaded;
        }
        logger.debug("HBase configuration: set a total of {} configuration values", (Object)keysLoaded);
        if (config.has(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])) {
            String zkQuorumKey = "hbase.zookeeper.quorum";
            String string = Joiner.on((String)",").join((Object[])config.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]));
            this.hconf.set(zkQuorumKey, string);
            logger.info("Copied host list from {} to {}: {}", new Object[]{GraphDatabaseConfiguration.STORAGE_HOSTS, zkQuorumKey, string});
        }
        if (config.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            String zkPortKey = "hbase.zookeeper.property.clientPort";
            Integer n = (Integer)config.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]);
            this.hconf.set(zkPortKey, n.toString());
            logger.info("Copied Zookeeper Port from {} to {}: {}", new Object[]{GraphDatabaseConfiguration.STORAGE_PORT, zkPortKey, n});
        }
        this.shortCfNames = (Boolean)config.get(SHORT_CF_NAMES, new String[0]);
        try {
            this.cnx = ConnectionFactory.createConnection((Configuration)this.hconf);
        }
        catch (IOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            openManagers.put(this, new Throwable("Manager Opened"));
            this.dumpOpenManagers();
        }
        logger.debug("Dumping HBase config key=value pairs");
        for (Map.Entry entry : this.hconf) {
            logger.debug("[HBaseConfig] " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        logger.debug("End of HBase config key=value pairs");
        this.openStores = new ConcurrentHashMap<String, HBaseKeyColumnValueStore>();
    }

    public static BiMap<String, String> createShortCfMap(org.janusgraph.diskstorage.configuration.Configuration config) {
        return ImmutableBiMap.builder().put((Object)"graphindex", (Object)"g").put((Object)"graphindex_lock_", (Object)"h").put(config.get(GraphDatabaseConfiguration.IDS_STORE_NAME, new String[0]), (Object)"i").put((Object)"edgestore", (Object)"e").put((Object)"edgestore_lock_", (Object)"f").put((Object)"system_properties", (Object)"s").put((Object)"system_properties_lock_", (Object)"t").put((Object)"systemlog", (Object)"m").put((Object)"txlog", (Object)"l").build();
    }

    public DistributedStoreManager.Deployment getDeployment() {
        if (null != this.deployment) {
            return this.deployment;
        }
        try {
            List<KeyRange> local = this.getLocalKeyPartition();
            this.deployment = null != local && !local.isEmpty() ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE;
        }
        catch (BackendException e) {
            throw new RuntimeException(e);
        }
        return this.deployment;
    }

    public String toString() {
        return "hbase[" + this.tableName + "@" + super.toString() + "]";
    }

    public void dumpOpenManagers() {
        int estimatedSize = openManagers.size();
        logger.trace("---- Begin open HBase store manager list ({} managers) ----", (Object)estimatedSize);
        for (HBaseStoreManager m : openManagers.keySet()) {
            logger.trace("Manager {} opened at:", (Object)m, (Object)openManagers.get((Object)m));
        }
        logger.trace("----   End open HBase store manager list ({} managers)  ----", (Object)estimatedSize);
    }

    public void close() {
        this.openStores.clear();
        if (logger.isTraceEnabled()) {
            openManagers.remove((Object)this);
        }
        IOUtils.closeQuietly((Closeable)this.cnx);
    }

    public StoreFeatures getFeatures() {
        ModifiableConfiguration c = GraphDatabaseConfiguration.buildGraphConfiguration();
        StandardStoreFeatures.Builder fb = new StandardStoreFeatures.Builder().orderedScan(true).unorderedScan(true).batchMutation(true).multiQuery(true).distributed(true).keyOrdered(true).storeTTL(true).cellTTL(true).timestamps(true).preferredTimestamps(PREFERRED_TIMESTAMPS).optimisticLocking(true).keyConsistent((org.janusgraph.diskstorage.configuration.Configuration)c);
        try {
            fb.localKeyPartition(this.getDeployment() == DistributedStoreManager.Deployment.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception during getDeployment()", (Throwable)e);
        }
        return fb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        Long putTimestamp = null;
        Long delTimestamp = null;
        DistributedStoreManager.MaskedTimestamp commitTime = null;
        if (this.assignTimestamp) {
            commitTime = new DistributedStoreManager.MaskedTimestamp(txh);
            putTimestamp = commitTime.getAdditionTime(this.times);
            delTimestamp = commitTime.getDeletionTime(this.times);
        }
        Map<StaticBuffer, Pair<List<Put>, Delete>> commandsPerKey = this.convertToCommands(mutations, putTimestamp, delTimestamp);
        ArrayList<Object> batch = new ArrayList<Object>(commandsPerKey.size());
        for (Pair<List<Put>, Delete> commands : commandsPerKey.values()) {
            if (commands.getFirst() != null && !((List)commands.getFirst()).isEmpty()) {
                batch.addAll((Collection)commands.getFirst());
            }
            if (commands.getSecond() == null) continue;
            batch.add(commands.getSecond());
        }
        try {
            Table table = null;
            try {
                table = this.cnx.getTable(this.tableName);
                table.batch(batch, new Object[batch.size()]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)table);
        }
        catch (IOException | InterruptedException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        if (commitTime != null) {
            this.sleepAfterWrite(commitTime);
        }
    }

    public KeyColumnValueStore openDatabase(String longName, StoreMetaData.Container metaData) throws BackendException {
        String cfName;
        HBaseKeyColumnValueStore newStore;
        Preconditions.checkArgument((!this.storageConfig.has(GraphDatabaseConfiguration.STORE_META_TTL, new String[]{longName}) || (Boolean)this.storageConfig.get(GraphDatabaseConfiguration.STORE_META_TTL, new String[]{longName}) == false ? 1 : 0) != 0);
        HBaseKeyColumnValueStore store = (HBaseKeyColumnValueStore)this.openStores.get(longName);
        if (store == null && (store = this.openStores.putIfAbsent(longName, newStore = new HBaseKeyColumnValueStore(this, this.cnx, this.tableName, cfName = this.getCfNameForStoreName(longName), longName))) == null) {
            if (!this.skipSchemaCheck) {
                int cfTTLInSeconds = -1;
                if (metaData.contains(StoreMetaData.TTL)) {
                    cfTTLInSeconds = (Integer)metaData.get(StoreMetaData.TTL);
                }
                this.ensureColumnFamilyExists(this.tableName, cfName, cfTTLInSeconds);
            }
            store = newStore;
        }
        return store;
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) {
        return new HBaseTransaction(config);
    }

    public String getName() {
        return this.tableName.getNameAsString();
    }

    public void clearStorage() throws BackendException {
        try (Admin adm = this.getAdminInterface();){
            if (((Boolean)this.storageConfig.get(GraphDatabaseConfiguration.DROP_ON_CLEAR, new String[0])).booleanValue()) {
                this.dropTable(adm);
            } else {
                this.clearTable(adm, this.times.getTime(this.times.getTime()));
            }
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    private void clearTable(Admin adm, long timestamp) throws IOException {
        if (!adm.tableExists(this.tableName)) {
            logger.debug("Attempted to clear table {} before it exists (noop)", (Object)this.tableName.getNameAsString());
            return;
        }
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setCaching(2000);
        scan.setTimeRange(0L, Long.MAX_VALUE);
        scan.readVersions(1);
        try (Table table = adm.getConnection().getTable(this.tableName);
             ResultScanner scanner = table.getScanner(scan);){
            Iterator iterator = scanner.iterator();
            int batchSize = 1000;
            ArrayList<Delete> deleteList = new ArrayList<Delete>();
            while (iterator.hasNext()) {
                deleteList.add(new Delete(((Result)iterator.next()).getRow(), timestamp));
                if (iterator.hasNext() && deleteList.size() != 1000) continue;
                table.delete(deleteList);
                deleteList.clear();
            }
        }
    }

    private void dropTable(Admin adm) throws IOException {
        if (!adm.tableExists(this.tableName)) {
            logger.debug("Attempted to drop table {} before it exists (noop)", (Object)this.tableName.getNameAsString());
            return;
        }
        if (adm.isTableEnabled(this.tableName)) {
            adm.disableTable(this.tableName);
        }
        adm.deleteTable(this.tableName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists() throws BackendException {
        try (Admin adm = this.getAdminInterface();){
            boolean bl = adm.tableExists(this.tableName);
            return bl;
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        LinkedList<KeyRange> result = new LinkedList<KeyRange>();
        try {
            if (this.skipSchemaCheck) {
                logger.debug("Skipping schema check");
                if (!this.exists()) {
                    throw new PermanentBackendException("Table " + this.tableName + " doesn't exist in HBase!");
                }
            } else {
                logger.debug("Performing schema check");
                this.ensureTableExists(this.tableName, this.getCfNameForStoreName("system_properties"), 0);
            }
            Map<KeyRange, ServerName> normed = this.normalizeKeyBounds(this.getRegionLocations(this.tableName));
            for (Map.Entry<KeyRange, ServerName> e : normed.entrySet()) {
                if (NetworkUtil.isLocalConnection((String)e.getValue().getHostname())) {
                    result.add(e.getKey());
                    logger.debug("Found local key/row partition {} on host {}", (Object)e.getKey(), (Object)e.getValue());
                    continue;
                }
                logger.debug("Discarding remote {}", (Object)e.getValue());
            }
        }
        catch (MasterNotRunningException e) {
            logger.warn("Unexpected MasterNotRunningException", (Throwable)e);
        }
        catch (ZooKeeperConnectionException e) {
            logger.warn("Unexpected ZooKeeperConnectionException", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Unexpected IOException", (Throwable)e);
        }
        return result;
    }

    private List<HRegionLocation> getRegionLocations(TableName tableName) throws IOException {
        return this.cnx.getRegionLocator(tableName).getAllRegionLocations();
    }

    private Map<KeyRange, ServerName> normalizeKeyBounds(List<HRegionLocation> locations) {
        HRegionLocation nullStart = null;
        HRegionLocation nullEnd = null;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (HRegionLocation location : locations) {
            RegionInfo regionInfo = location.getRegion();
            ServerName serverName = location.getServerName();
            byte[] startKey = regionInfo.getStartKey();
            byte[] endKey = regionInfo.getEndKey();
            if (0 == startKey.length) {
                startKey = null;
                logger.trace("Converted zero-length HBase startKey byte array to null");
            }
            if (0 == endKey.length) {
                endKey = null;
                logger.trace("Converted zero-length HBase endKey byte array to null");
            }
            if (null == startKey && null == endKey) {
                Preconditions.checkState((1 == locations.size() ? 1 : 0) != 0);
                logger.debug("HBase table {} has a single region {}", (Object)this.tableName, (Object)regionInfo);
                return b.put((Object)new KeyRange(FOUR_ZERO_BYTES, FOUR_ZERO_BYTES), (Object)serverName).build();
            }
            if (null == startKey) {
                logger.debug("Found HRegionInfo with null startKey on server {}: {}", (Object)serverName, (Object)regionInfo);
                Preconditions.checkState((null == nullStart ? 1 : 0) != 0);
                nullStart = location;
                StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
                b.put((Object)new KeyRange(FOUR_ZERO_BYTES, (StaticBuffer)endBuf), (Object)serverName);
                continue;
            }
            if (null == endKey) {
                logger.debug("Found HRegionInfo with null endKey on server {}: {}", (Object)serverName, (Object)regionInfo);
                Preconditions.checkState((null == nullEnd ? 1 : 0) != 0);
                nullEnd = location;
                b.put((Object)new KeyRange((StaticBuffer)StaticArrayBuffer.of((byte[])this.zeroExtend(startKey)), FOUR_ZERO_BYTES), (Object)serverName);
                continue;
            }
            StaticArrayBuffer startBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(startKey));
            StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
            KeyRange kr = new KeyRange((StaticBuffer)startBuf, (StaticBuffer)endBuf);
            b.put((Object)kr, (Object)serverName);
            logger.debug("Found HRegionInfo with non-null end and start keys on server {}: {}", (Object)serverName, (Object)regionInfo);
        }
        Preconditions.checkState((null == nullStart == (null == nullEnd) ? 1 : 0) != 0);
        ImmutableMap result = b.build();
        for (KeyRange kr : result.keySet()) {
            Preconditions.checkState((4 <= kr.getStart().length() ? 1 : 0) != 0);
            Preconditions.checkState((4 <= kr.getEnd().length() ? 1 : 0) != 0);
        }
        return result;
    }

    private byte[] zeroExtend(byte[] dataToPad) {
        assert (null != dataToPad);
        int targetLength = 4;
        if (4 <= dataToPad.length) {
            return dataToPad;
        }
        byte[] padded = new byte[4];
        System.arraycopy(dataToPad, 0, padded, 0, dataToPad.length);
        for (int i = dataToPad.length; i < padded.length; ++i) {
            padded[i] = 0;
        }
        return padded;
    }

    public static String shortenCfName(BiMap<String, String> shortCfNameMap, String longName) throws PermanentBackendException {
        String s;
        if (shortCfNameMap.containsKey((Object)longName)) {
            s = (String)shortCfNameMap.get((Object)longName);
            Preconditions.checkNotNull((Object)s);
            logger.debug("Substituted default CF name \"{}\" with short form \"{}\" to reduce HBase KeyValue size", (Object)longName, (Object)s);
        } else {
            if (shortCfNameMap.containsValue((Object)longName)) {
                String fmt = "Must use CF long-form name \"%s\" instead of the short-form name \"%s\" when configured with %s=true";
                String msg = String.format(fmt, shortCfNameMap.inverse().get((Object)longName), longName, SHORT_CF_NAMES.getName());
                throw new PermanentBackendException(msg);
            }
            s = longName;
            logger.debug("Kept default CF name \"{}\" because it has no associated short form", (Object)s);
        }
        return s;
    }

    private TableDescriptor ensureTableExists(TableName tableName, String initialCFName, int ttlInSeconds) throws BackendException {
        TableDescriptor desc;
        Admin adm = null;
        try {
            adm = this.getAdminInterface();
            if (adm.tableExists(tableName)) {
                String shortCFName;
                desc = adm.getDescriptor(tableName);
                if (this.shortCfNames && initialCFName.equals(this.shortCfNameMap.get((Object)"system_properties"))) {
                    String longCFName = (String)this.shortCfNameMap.inverse().get((Object)initialCFName);
                    if (desc.getColumnFamily(Bytes.toBytes((String)longCFName)) != null) {
                        logger.warn("Configuration {}=true, but the table \"{}\" already has column family with long name \"{}\".", new Object[]{SHORT_CF_NAMES.getName(), tableName, longCFName});
                        logger.warn("Check {} configuration.", (Object)SHORT_CF_NAMES.getName());
                    }
                } else if (!this.shortCfNames && initialCFName.equals("system_properties") && desc.getColumnFamily(Bytes.toBytes((String)(shortCFName = (String)this.shortCfNameMap.get((Object)initialCFName)))) != null) {
                    logger.warn("Configuration {}=false, but the table \"{}\" already has column family with short name \"{}\".", new Object[]{SHORT_CF_NAMES.getName(), tableName, shortCFName});
                    logger.warn("Check {} configuration.", (Object)SHORT_CF_NAMES.getName());
                }
            } else {
                desc = this.createTable(tableName, initialCFName, ttlInSeconds, adm);
            }
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)adm);
        }
        return desc;
    }

    private TableDescriptor createTable(TableName tableName, String cfName, int ttlInSeconds, Admin adm) throws IOException {
        String src;
        TableDescriptorBuilder desc = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptorBuilder columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)cfName));
        this.setCFOptions(columnDescriptor, ttlInSeconds);
        desc.setColumnFamily(columnDescriptor.build());
        TableDescriptor td = desc.build();
        int count = this.regionCount;
        if (3 <= count) {
            src = "region count configuration";
        } else if (0 < this.regionsPerServer && 3 <= (count = this.regionsPerServer * this.getEstimatedRegionServerCount(adm))) {
            src = "ClusterStatus server count";
        } else {
            count = -1;
            src = "default";
        }
        if (3 < count) {
            adm.createTable(td, this.getStartKey(count), this.getEndKey(count), count);
            logger.debug("Created table {} with region count {} from {}", new Object[]{tableName, count, src});
        } else {
            adm.createTable(td);
            logger.debug("Created table {} with default start key, end key, and region count", (Object)tableName);
        }
        return td;
    }

    private int getEstimatedRegionServerCount(Admin adm) {
        int serverCount = -1;
        try {
            serverCount = adm.getRegionServers().size();
            logger.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            logger.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    private byte[] getStartKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount)).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    private byte[] getEndKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount * (long)(regionCount - 1))).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureColumnFamilyExists(TableName tableName, String columnFamily, int ttlInSeconds) throws BackendException {
        block13: {
            Admin adm = null;
            try {
                adm = this.getAdminInterface();
                TableDescriptor desc = this.ensureTableExists(tableName, columnFamily, ttlInSeconds);
                Preconditions.checkNotNull((Object)desc);
                ColumnFamilyDescriptor cf = desc.getColumnFamily(Bytes.toBytes((String)columnFamily));
                if (cf != null) break block13;
                try {
                    if (!adm.isTableDisabled(tableName)) {
                        adm.disableTable(tableName);
                    }
                }
                catch (TableNotEnabledException e) {
                    logger.debug("Table {} already disabled", (Object)tableName);
                }
                catch (IOException e) {
                    throw new TemporaryBackendException((Throwable)e);
                }
                try {
                    ColumnFamilyDescriptorBuilder columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)columnFamily));
                    this.setCFOptions(columnDescriptor, ttlInSeconds);
                    adm.addColumnFamily(tableName, columnDescriptor.build());
                    try {
                        logger.debug("Added HBase ColumnFamily {}, waiting for 1 sec. to propagate.", (Object)columnFamily);
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        throw new TemporaryBackendException((Throwable)ie);
                    }
                    adm.enableTable(tableName);
                }
                catch (TableNotFoundException ee) {
                    logger.error("TableNotFoundException", (Throwable)ee);
                    throw new PermanentBackendException((Throwable)ee);
                }
                catch (TableExistsException ee) {
                    logger.debug("Swallowing exception", (Throwable)ee);
                }
                catch (IOException ee) {
                    throw new TemporaryBackendException((Throwable)ee);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)adm);
            }
        }
    }

    private void setCFOptions(ColumnFamilyDescriptorBuilder columnDescriptor, int ttlInSeconds) {
        if (null != this.compression && !this.compression.equals(COMPRESSION_DEFAULT)) {
            columnDescriptor.setCompressionType(Compression.Algorithm.valueOf((String)this.compression));
        }
        if (ttlInSeconds > 0) {
            columnDescriptor.setTimeToLive(ttlInSeconds);
        }
    }

    @VisibleForTesting
    Map<StaticBuffer, Pair<List<Put>, Delete>> convertToCommands(Map<String, Map<StaticBuffer, KCVMutation>> mutations, Long putTimestamp, Long delTimestamp) throws PermanentBackendException {
        HashMap<StaticBuffer, Pair<List<Put>, Delete>> commandsPerKey = new HashMap<StaticBuffer, Pair<List<Put>, Delete>>();
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> entry : mutations.entrySet()) {
            String cfString = this.getCfNameForStoreName(entry.getKey());
            byte[] cfName = Bytes.toBytes((String)cfString);
            for (Map.Entry<StaticBuffer, KCVMutation> m : entry.getValue().entrySet()) {
                byte[] key = (byte[])m.getKey().as(StaticBuffer.ARRAY_FACTORY);
                KCVMutation mutation = m.getValue();
                Pair commands = (Pair)commandsPerKey.get(m.getKey());
                if (commands == null) {
                    commands = new Pair();
                    ArrayList putList = new ArrayList();
                    commands.setFirst(putList);
                    commandsPerKey.put(m.getKey(), (Pair<List<Put>, Delete>)commands);
                }
                if (mutation.hasDeletions()) {
                    if (commands.getSecond() == null) {
                        Delete d = new Delete(key);
                        if (delTimestamp != null) {
                            d.setTimestamp(delTimestamp.longValue());
                        }
                        commands.setSecond((Object)d);
                    }
                    for (StaticBuffer b : mutation.getDeletions()) {
                        this.addColumnToDelete((Delete)commands.getSecond(), cfName, (byte[])b.as(StaticBuffer.ARRAY_FACTORY), delTimestamp);
                    }
                }
                if (!mutation.hasAdditions()) continue;
                Put putColumnsWithoutTtl = putTimestamp != null ? new Put(key, putTimestamp.longValue()) : new Put(key);
                for (Entry e : mutation.getAdditions()) {
                    Integer ttl = (Integer)e.getMetaData().get(EntryMetaData.TTL);
                    if (null != ttl && ttl > 0) {
                        Put putColumnWithTtl = putTimestamp != null ? new Put(key, putTimestamp.longValue()) : new Put(key);
                        this.addColumnToPut(putColumnWithTtl, cfName, putTimestamp, e);
                        putColumnWithTtl.setTTL(TimeUnit.SECONDS.toMillis(ttl.intValue()));
                        ((List)commands.getFirst()).add(putColumnWithTtl);
                        continue;
                    }
                    this.addColumnToPut(putColumnsWithoutTtl, cfName, putTimestamp, e);
                }
                if (putColumnsWithoutTtl.isEmpty()) continue;
                ((List)commands.getFirst()).add(putColumnsWithoutTtl);
            }
        }
        return commandsPerKey;
    }

    private void addColumnToDelete(Delete d, byte[] cfName, byte[] qualifier, Long delTimestamp) {
        if (delTimestamp != null) {
            d.addColumns(cfName, qualifier, delTimestamp.longValue());
        } else {
            d.addColumns(cfName, qualifier);
        }
    }

    private void addColumnToPut(Put p, byte[] cfName, Long putTimestamp, Entry e) {
        byte[] qualifier = (byte[])e.getColumnAs(StaticBuffer.ARRAY_FACTORY);
        byte[] value = (byte[])e.getValueAs(StaticBuffer.ARRAY_FACTORY);
        if (putTimestamp != null) {
            p.addColumn(cfName, qualifier, putTimestamp.longValue(), value);
        } else {
            p.addColumn(cfName, qualifier, value);
        }
    }

    private String getCfNameForStoreName(String storeName) throws PermanentBackendException {
        return this.shortCfNames ? HBaseStoreManager.shortenCfName(this.shortCfNameMap, storeName) : storeName;
    }

    private Admin getAdminInterface() {
        try {
            return this.cnx.getAdmin();
        }
        catch (IOException e) {
            throw new JanusGraphException((Throwable)e);
        }
    }

    private TableName determineTableName(org.janusgraph.diskstorage.configuration.Configuration config) {
        if (!config.has(HBASE_TABLE, new String[0]) && config.has(GraphDatabaseConfiguration.GRAPH_NAME, new String[0])) {
            return TableName.valueOf((String)((String)config.get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0])));
        }
        return TableName.valueOf((String)((String)config.get(HBASE_TABLE, new String[0])));
    }

    @VisibleForTesting
    protected Configuration getHBaseConf() {
        return this.hconf;
    }

    public Object getHadoopManager() {
        return new HBaseHadoopStoreManager();
    }
}

