/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.util;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cql.QueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.KeysQueriesGroup;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;

public class CQLSliceQueryUtil {
    private CQLSliceQueryUtil() {
    }

    public static QueryGroups getQueriesGroupedByDirectEqualityQueries(KeysQueriesGroup<StaticBuffer, SliceQuery> queryGroup, int totalQueryGroupsSize, int sliceGroupingLimit) {
        HashMap<Integer, List<SliceQuery>> directEqualityGroupedQueriesByLimit = new HashMap<Integer, List<SliceQuery>>(queryGroup.getQueries().size());
        ArrayList<SliceQuery> separateRangeQueries = new ArrayList<SliceQuery>(queryGroup.getQueries().size());
        for (SliceQuery query : queryGroup.getQueries()) {
            if (query.isDirectColumnByStartOnlyAllowed()) {
                ArrayList<SliceQuery> directEqualityQueries = (ArrayList<SliceQuery>)directEqualityGroupedQueriesByLimit.get(query.getLimit());
                if (directEqualityQueries == null) {
                    directEqualityQueries = new ArrayList<SliceQuery>(totalQueryGroupsSize);
                    directEqualityQueries.add(query);
                    directEqualityGroupedQueriesByLimit.put(query.getLimit(), directEqualityQueries);
                    continue;
                }
                if (!(directEqualityQueries.size() >= sliceGroupingLimit || query.hasLimit() && directEqualityQueries.size() >= query.getLimit())) {
                    directEqualityQueries.add(query);
                    continue;
                }
                separateRangeQueries.add(query);
                continue;
            }
            separateRangeQueries.add(query);
        }
        return new QueryGroups(directEqualityGroupedQueriesByLimit, separateRangeQueries);
    }

    public static TokenRange findTokenRange(Token token, Collection<TokenRange> tokenRanges) {
        for (TokenRange tokenRange : tokenRanges) {
            if (!tokenRange.contains(token)) continue;
            return tokenRange;
        }
        return null;
    }
}

