/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PowerSet<T>
extends AbstractSet<Set<T>> {
    private final Set<T> originalSet;

    public PowerSet(Set<T> originalSet) {
        this.originalSet = originalSet;
    }

    @Override
    public Iterator<Set<T>> iterator() {
        return new PowerSetIterator<T>(this.originalSet);
    }

    @Override
    public int size() {
        return 1 << this.originalSet.size();
    }

    private static class PowerSetIterator<T>
    implements Iterator<Set<T>> {
        private final List<T> originalElements;
        private int position;
        private final int resultSize;

        public PowerSetIterator(Set<T> originalSet) {
            if (originalSet == null) {
                throw new NullPointerException("Base set for a power set must not be null");
            }
            if (originalSet.size() > 30) {
                throw new IllegalArgumentException("Input set is too large, power set would exceed integer limit size");
            }
            this.originalElements = new ArrayList<T>(originalSet);
            this.resultSize = 1 << originalSet.size();
            this.position = 0;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.resultSize;
        }

        @Override
        public Set<T> next() {
            HashSet<T> result = new HashSet<T>(this.originalElements.size());
            int elementMap = this.position;
            int elementIdx = 0;
            while (elementMap > 0) {
                if (elementMap % 2 == 1) {
                    result.add(this.originalElements.get(elementIdx));
                }
                elementMap /= 2;
                ++elementIdx;
            }
            ++this.position;
            return result;
        }
    }
}

