/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean isCausedBy(Throwable exception, Class<?> exType) {
        Throwable ex2 = exception.getCause();
        return ex2 != null && ex2 != exception && (exType.isInstance(ex2) || ExceptionUtil.isCausedBy(ex2, exType));
    }

    public static RuntimeException convertIfInterrupted(RuntimeException runtimeException) {
        if (ExceptionUtil.isCausedBy(runtimeException, InterruptedException.class)) {
            TraversalInterruptedException traversalInterruptedException = new TraversalInterruptedException();
            traversalInterruptedException.initCause((Throwable)runtimeException);
            return traversalInterruptedException;
        }
        return runtimeException;
    }
}

