/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphHasStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryHasStepStrategyMode;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;

public class JanusGraphHasStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphHasStepStrategy INSTANCE = new JanusGraphHasStepStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(JanusGraphLocalQueryOptimizerStrategy.class);

    private JanusGraphHasStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean hasPropertyPrefetching;
        int txVertexCacheSize;
        MultiQueryHasStepStrategyMode hasStepStrategyMode;
        if (!traversal.getGraph().isPresent()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        Optional<StandardJanusGraphTx> tx = JanusGraphTraversalUtil.getJanusGraphTx(traversal);
        if (tx.isPresent()) {
            TransactionConfiguration txConfig = tx.get().getConfiguration();
            hasStepStrategyMode = txConfig.getHasStepStrategyMode();
            txVertexCacheSize = txConfig.getVertexCacheSize();
            hasPropertyPrefetching = txConfig.hasPropertyPrefetching();
        } else {
            GraphDatabaseConfiguration graphConfig = janusGraph.getConfiguration();
            hasStepStrategyMode = graphConfig.hasStepStrategyMode();
            txVertexCacheSize = graphConfig.getTxVertexCacheSize();
            hasPropertyPrefetching = graphConfig.hasPropertyPrefetching();
        }
        if (MultiQueryHasStepStrategyMode.NONE.equals(hasStepStrategyMode)) {
            return;
        }
        this.applyJanusGraphHasSteps(traversal, txVertexCacheSize, hasPropertyPrefetching ? MultiQueryHasStepStrategyMode.ALL_PROPERTIES : hasStepStrategyMode);
    }

    private void applyJanusGraphHasSteps(Traversal.Admin<?, ?> traversal, int txVertexCacheSize, MultiQueryHasStepStrategyMode hasStepStrategyMode) {
        TraversalHelper.getStepsOfAssignableClass(HasStep.class, traversal).forEach(originalStep -> {
            if (originalStep instanceof JanusGraphHasStep) {
                return;
            }
            JanusGraphHasStep janusGraphHasStep = this.createJanusGraphHasStep((HasStep)originalStep, txVertexCacheSize, hasStepStrategyMode);
            TraversalHelper.replaceStep((Step)originalStep, (Step)janusGraphHasStep, (Traversal.Admin)originalStep.getTraversal());
        });
    }

    private JanusGraphHasStep createJanusGraphHasStep(HasStep originalStep, int txVertexCacheSize, MultiQueryHasStepStrategyMode hasStepStrategyMode) {
        JanusGraphHasStep janusGraphHasStep = new JanusGraphHasStep(originalStep);
        janusGraphHasStep.setTxVertexCacheSize(txVertexCacheSize);
        if (MultiQueryHasStepStrategyMode.ALL_PROPERTIES.equals(hasStepStrategyMode)) {
            janusGraphHasStep.setPrefetchAllPropertiesRequired(true);
        } else if (MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.equals(hasStepStrategyMode) || MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES_OR_ALL.equals(hasStepStrategyMode)) {
            Optional<Set<String>> optionalNextStepNeededProperties = this.findNextStepNeededProperties(originalStep);
            if (optionalNextStepNeededProperties.isPresent()) {
                Set<String> nextStepNeededProperties = optionalNextStepNeededProperties.get();
                if (nextStepNeededProperties.isEmpty()) {
                    janusGraphHasStep.setPrefetchAllPropertiesRequired(true);
                } else {
                    for (String nextStepNeededProperty : nextStepNeededProperties) {
                        janusGraphHasStep.withPropertyPrefetch(nextStepNeededProperty);
                    }
                }
            } else if (MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES_OR_ALL.equals(hasStepStrategyMode)) {
                janusGraphHasStep.setPrefetchAllPropertiesRequired(true);
            }
        }
        return janusGraphHasStep;
    }

    private Optional<Set<String>> findNextStepNeededProperties(HasStep originalStep) {
        Step nextStep = originalStep.getNextStep();
        while (nextStep instanceof NoOpBarrierStep || nextStep instanceof IdentityStep || nextStep instanceof ProfileStep || nextStep instanceof SideEffectStep || nextStep instanceof JanusGraphMultiQueryStep) {
            nextStep = nextStep.getNextStep();
        }
        if (nextStep instanceof PropertiesStep) {
            return Optional.of(new HashSet<String>(Arrays.asList(((PropertiesStep)nextStep).getPropertyKeys())));
        }
        if (nextStep instanceof PropertyMapStep) {
            return Optional.of(new HashSet<String>(Arrays.asList(((PropertyMapStep)nextStep).getPropertyKeys())));
        }
        if (nextStep instanceof ElementMapStep) {
            return Optional.of(new HashSet<String>(Arrays.asList(((ElementMapStep)nextStep).getPropertyKeys())));
        }
        return Optional.empty();
    }

    public static JanusGraphHasStepStrategy instance() {
        return INSTANCE;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

