/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.profile;

import java.util.ArrayList;
import org.janusgraph.diskstorage.keycolumnvalue.KeysQueriesGroup;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.graphdb.query.Query;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class QueryProfilerUtil {
    private QueryProfilerUtil() {
    }

    public static <Q extends Query> void setMultiSliceQueryAnnotations(QueryProfiler profiler, MultiKeysQueryGroups<Object, Q> multiSliceQueries) {
        if (profiler == QueryProfiler.NO_OP) {
            return;
        }
        profiler.setAnnotation("multiSlices", true);
        ArrayList<Query> allQueries = new ArrayList<Query>();
        ArrayList<Integer> allLimits = null;
        boolean hasLimit = false;
        int queriesCount = 0;
        for (KeysQueriesGroup<Object, Q> groupedQueries : multiSliceQueries.getQueryGroups()) {
            for (Query query : groupedQueries.getQueries()) {
                allQueries.add(query);
                if (hasLimit) {
                    allLimits.add(query.hasLimit() ? query.getLimit() : -1);
                } else if (query.hasLimit()) {
                    hasLimit = true;
                    allLimits = new ArrayList<Integer>();
                    allLimits.ensureCapacity(queriesCount + 1);
                    for (int i = 0; i < queriesCount; ++i) {
                        allLimits.add(-1);
                    }
                    allLimits.add(query.getLimit());
                }
                ++queriesCount;
            }
        }
        profiler.setAnnotation("queries", allQueries);
        profiler.setAnnotation("queriesAmount", queriesCount);
        if (hasLimit) {
            profiler.setAnnotation("limitsPerQuery", allLimits);
        }
    }
}

