/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.DT;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateAddStep<S>
extends ScalarMapStep<S, Date> {
    static final Map<DT, Integer> DTtoCalendar = new HashMap<DT, Integer>();
    private DT dateToken;
    private int value;

    public DateAddStep(Traversal.Admin traversal, DT dateToken, int value) {
        super(traversal);
        this.dateToken = dateToken;
        this.value = value;
    }

    @Override
    protected Date map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("dateAdd accept only Date.");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)object);
        cal.add(DTtoCalendar.get((Object)this.dateToken), this.value);
        return cal.getTime();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.dateToken.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    @Override
    public DateAddStep<S> clone() {
        DateAddStep clone = (DateAddStep)super.clone();
        clone.value = this.value;
        clone.dateToken = this.dateToken;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    static {
        DTtoCalendar.put(DT.second, 13);
        DTtoCalendar.put(DT.minute, 12);
        DTtoCalendar.put(DT.hour, 11);
        DTtoCalendar.put(DT.day, 5);
    }
}

