/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Comparator;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopPoolsConfigurable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectWritableComparator
implements RawComparator<ObjectWritable>,
HadoopPoolsConfigurable {
    public static final Logger LOGGER = LoggerFactory.getLogger(ObjectWritableComparator.class);
    protected Comparator comparator;
    private final ObjectWritable objectWritable1 = new ObjectWritable();
    private final ObjectWritable objectWritable2 = new ObjectWritable();

    public int compare(ObjectWritable objectWritable1, ObjectWritable objectWritable2) {
        return this.comparator.compare(objectWritable1.get(), objectWritable2.get());
    }

    public int compare(byte[] bytes, int i, int i1, byte[] bytes1, int i2, int i3) {
        try {
            this.objectWritable1.readFields(new DataInputStream(new ByteArrayInputStream(bytes, i, i1)));
            this.objectWritable2.readFields(new DataInputStream(new ByteArrayInputStream(bytes1, i2, i3)));
            return this.comparator.compare(this.objectWritable1.get(), this.objectWritable2.get());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static class ObjectWritableReduceComparator
    extends ObjectWritableComparator {
        @Override
        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
            super.setConf(configuration);
            Configuration apacheConfiguration = ConfUtil.makeApacheConfiguration(configuration);
            this.comparator = (Comparator)MapReduce.createMapReduce((Graph)HadoopGraph.open(apacheConfiguration), (Configuration)apacheConfiguration).getReduceKeySort().get();
        }
    }

    public static class ObjectWritableMapComparator
    extends ObjectWritableComparator {
        @Override
        public void setConf(org.apache.hadoop.conf.Configuration configuration) {
            super.setConf(configuration);
            Configuration apacheConfiguration = ConfUtil.makeApacheConfiguration(configuration);
            this.comparator = (Comparator)MapReduce.createMapReduce((Graph)HadoopGraph.open(apacheConfiguration), (Configuration)apacheConfiguration).getMapKeySort().get();
        }
    }
}

