/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.RequestRecord;

public class SimpleRequestRecord
implements RequestRecord {
    private final Record record;
    private volatile byte[] bytes;

    public SimpleRequestRecord(Record record) {
        this.record = record;
    }

    @Override
    public <T extends Record> T readRecord(Supplier<T> constructor) {
        return (T)this.record;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] readBytes() {
        byte[] byArray;
        if (this.bytes != null) {
            return this.bytes;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
            this.record.serialize((OutputArchive)boa, "request");
            byArray = this.bytes = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        baos.close();
        return byArray;
    }

    @Override
    public int limit() {
        byte[] bytes = this.readBytes();
        return ByteBuffer.wrap(bytes).limit();
    }
}

