/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.util.EmptyMemory;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.spark.process.computer.traversal.strategy.optimization.interceptor.SparkStarBarrierInterceptor;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class SparkInterceptorStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final SparkInterceptorStrategy INSTANCE = new SparkInterceptorStrategy();

    private SparkInterceptorStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        Graph graph = traversal.getGraph().orElse(EmptyGraph.instance());
        for (TraversalVertexProgramStep step : TraversalHelper.getStepsOfClass(TraversalVertexProgramStep.class, traversal)) {
            Traversal.Admin computerTraversal = step.generateProgram(graph, (Memory)EmptyMemory.instance()).getTraversal().get().clone();
            if (!computerTraversal.isLocked()) {
                computerTraversal.applyStrategies();
            }
            if (!SparkStarBarrierInterceptor.isLegal(computerTraversal)) continue;
            step.setComputer(step.getComputer().configure("gremlin.spark.skipPartitioner", (Object)true).configure("gremlin.spark.skipGraphCache", (Object)true).configure("gremlin.hadoop.vertexProgramInterceptor", (Object)SparkStarBarrierInterceptor.class.getCanonicalName()));
        }
    }

    public static SparkInterceptorStrategy instance() {
        return INSTANCE;
    }
}

