/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.strategy;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.ResultFiller;
import org.janusgraph.diskstorage.cql.util.CQLSliceQueryUtil;
import org.janusgraph.diskstorage.cql.util.KeysGroup;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class TokenRangeAwareGroupedExecutionStrategy
implements GroupedExecutionStrategy {
    private final CqlSession session;

    public TokenRangeAwareGroupedExecutionStrategy(Configuration configuration, CQLStoreManager storeManager) {
        this.session = storeManager.getSession();
    }

    @Override
    public <R, Q> void execute(R futureResult, Q queries, List<StaticBuffer> keys, ResultFiller<R, Q, KeysGroup> withKeysGroupingFiller, ResultFiller<R, Q, List<StaticBuffer>> withoutKeysGroupingFiller, StoreTransaction txh, int keysGroupingLimit) {
        Optional optionalTokenMap = this.session.getMetadata().getTokenMap();
        if (!optionalTokenMap.isPresent()) {
            withoutKeysGroupingFiller.execute(futureResult, queries, keys, txh);
            return;
        }
        TokenMap tokenMap = (TokenMap)optionalTokenMap.get();
        Set tokenRanges = tokenMap.getTokenRanges();
        if (CollectionUtils.isEmpty((Collection)tokenRanges)) {
            withoutKeysGroupingFiller.execute(futureResult, queries, keys, txh);
            return;
        }
        HashMap<TokenRange, KeysGroup> keyGroupBuildersByTokenRanges = new HashMap<TokenRange, KeysGroup>(tokenRanges.size());
        int groupLimit = Math.min(keys.size(), keysGroupingLimit);
        for (StaticBuffer key : keys) {
            ByteBuffer keyByteBuffer = key.asByteBuffer();
            Token token = tokenMap.newToken(new ByteBuffer[]{keyByteBuffer});
            TokenRange tokenRange = CQLSliceQueryUtil.findTokenRange(token, tokenRanges);
            if (tokenRange == null) {
                withKeysGroupingFiller.execute(futureResult, queries, new KeysGroup(Collections.singletonList(key), Collections.singletonList(keyByteBuffer), token), txh);
                continue;
            }
            KeysGroup keyGroup = (KeysGroup)keyGroupBuildersByTokenRanges.get(tokenRange);
            if (keyGroup == null) {
                keyGroup = new KeysGroup(groupLimit, token);
                keyGroupBuildersByTokenRanges.put(tokenRange, keyGroup);
            }
            keyGroup.addKey(key, keyByteBuffer);
            if (keyGroup.size() < groupLimit) continue;
            keyGroupBuildersByTokenRanges.put(tokenRange, new KeysGroup(groupLimit, token));
            withKeysGroupingFiller.execute(futureResult, queries, keyGroup, txh);
        }
        for (KeysGroup keyGroup : keyGroupBuildersByTokenRanges.values()) {
            if (keyGroup.isEmpty()) continue;
            withKeysGroupingFiller.execute(futureResult, queries, keyGroup, txh);
        }
    }
}

