/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.querybuilder.schema.AlterKeyspaceStart;
import com.datastax.oss.driver.api.querybuilder.schema.AlterMaterializedViewStart;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTypeStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateAggregateStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateFunctionStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateIndexStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateMaterializedViewStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTypeStart;
import com.datastax.oss.driver.api.querybuilder.schema.Drop;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.LeveledCompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.SizeTieredCompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.TimeWindowCompactionStrategy;
import com.datastax.oss.driver.internal.core.metadata.schema.ShallowUserDefinedType;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultAlterKeyspace;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultAlterMaterializedView;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultAlterTable;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultAlterType;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateAggregate;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateFunction;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateIndex;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateKeyspace;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateMaterializedView;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateTable;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultCreateType;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultDrop;
import com.datastax.oss.driver.internal.querybuilder.schema.DefaultDropKeyspace;
import com.datastax.oss.driver.internal.querybuilder.schema.compaction.DefaultLeveledCompactionStrategy;
import com.datastax.oss.driver.internal.querybuilder.schema.compaction.DefaultSizeTieredCompactionStrategy;
import com.datastax.oss.driver.internal.querybuilder.schema.compaction.DefaultTimeWindowCompactionStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class SchemaBuilder {
    @NonNull
    public static CreateKeyspaceStart createKeyspace(@NonNull CqlIdentifier keyspaceName) {
        return new DefaultCreateKeyspace(keyspaceName);
    }

    @NonNull
    public static CreateKeyspaceStart createKeyspace(@NonNull String keyspaceName) {
        return SchemaBuilder.createKeyspace(CqlIdentifier.fromCql((String)keyspaceName));
    }

    @NonNull
    public static AlterKeyspaceStart alterKeyspace(@NonNull CqlIdentifier keyspaceName) {
        return new DefaultAlterKeyspace(keyspaceName);
    }

    @NonNull
    public static AlterKeyspaceStart alterKeyspace(@NonNull String keyspaceName) {
        return SchemaBuilder.alterKeyspace(CqlIdentifier.fromCql((String)keyspaceName));
    }

    @NonNull
    public static Drop dropKeyspace(@NonNull CqlIdentifier keyspaceName) {
        return new DefaultDropKeyspace(keyspaceName);
    }

    @NonNull
    public static Drop dropKeyspace(@NonNull String keyspaceName) {
        return SchemaBuilder.dropKeyspace(CqlIdentifier.fromCql((String)keyspaceName));
    }

    @NonNull
    public static CreateTableStart createTable(@NonNull CqlIdentifier tableName) {
        return new DefaultCreateTable(tableName);
    }

    @NonNull
    public static CreateTableStart createTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        return new DefaultCreateTable(keyspace, tableName);
    }

    @NonNull
    public static CreateTableStart createTable(@NonNull String tableName) {
        return SchemaBuilder.createTable(CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static CreateTableStart createTable(@Nullable String keyspace, @NonNull String tableName) {
        return SchemaBuilder.createTable(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static AlterTableStart alterTable(@NonNull CqlIdentifier tableName) {
        return new DefaultAlterTable(tableName);
    }

    @NonNull
    public static AlterTableStart alterTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        return new DefaultAlterTable(keyspace, tableName);
    }

    @NonNull
    public static AlterTableStart alterTable(@NonNull String tableName) {
        return SchemaBuilder.alterTable(CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static AlterTableStart alterTable(@Nullable String keyspace, @NonNull String tableName) {
        return SchemaBuilder.alterTable(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static Drop dropTable(@NonNull CqlIdentifier tableName) {
        return new DefaultDrop(tableName, "TABLE");
    }

    @NonNull
    public static Drop dropTable(@NonNull String tableName) {
        return SchemaBuilder.dropTable(CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static Drop dropTable(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier tableName) {
        return new DefaultDrop(keyspace, tableName, "TABLE");
    }

    @NonNull
    public static Drop dropTable(@Nullable String keyspace, @NonNull String tableName) {
        return SchemaBuilder.dropTable(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)tableName));
    }

    @NonNull
    public static CreateMaterializedViewStart createMaterializedView(@NonNull CqlIdentifier viewName) {
        return new DefaultCreateMaterializedView(viewName);
    }

    @NonNull
    public static CreateMaterializedViewStart createMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName) {
        return new DefaultCreateMaterializedView(keyspace, viewName);
    }

    @NonNull
    public static CreateMaterializedViewStart createMaterializedView(@NonNull String viewName) {
        return SchemaBuilder.createMaterializedView(CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static CreateMaterializedViewStart createMaterializedView(@Nullable String keyspace, @NonNull String viewName) {
        return SchemaBuilder.createMaterializedView(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static AlterMaterializedViewStart alterMaterializedView(@NonNull CqlIdentifier viewName) {
        return new DefaultAlterMaterializedView(viewName);
    }

    @NonNull
    public static AlterMaterializedViewStart alterMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName) {
        return new DefaultAlterMaterializedView(keyspace, viewName);
    }

    @NonNull
    public static AlterMaterializedViewStart alterMaterializedView(@NonNull String viewName) {
        return SchemaBuilder.alterMaterializedView(CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static AlterMaterializedViewStart alterMaterializedView(@Nullable String keyspace, @NonNull String viewName) {
        return SchemaBuilder.alterMaterializedView(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static Drop dropMaterializedView(@NonNull CqlIdentifier viewName) {
        return new DefaultDrop(viewName, "MATERIALIZED VIEW");
    }

    @NonNull
    public static Drop dropMaterializedView(@NonNull String viewName) {
        return SchemaBuilder.dropMaterializedView(CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static Drop dropMaterializedView(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier viewName) {
        return new DefaultDrop(keyspace, viewName, "MATERIALIZED VIEW");
    }

    @NonNull
    public static Drop dropMaterializedView(@Nullable String keyspace, @NonNull String viewName) {
        return SchemaBuilder.dropMaterializedView(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)viewName));
    }

    @NonNull
    public static CreateTypeStart createType(@NonNull CqlIdentifier typeName) {
        return new DefaultCreateType(typeName);
    }

    @NonNull
    public static CreateTypeStart createType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName) {
        return new DefaultCreateType(keyspace, typeName);
    }

    @NonNull
    public static CreateTypeStart createType(@NonNull String typeName) {
        return SchemaBuilder.createType(CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static CreateTypeStart createType(@Nullable String keyspace, @NonNull String typeName) {
        return SchemaBuilder.createType(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static AlterTypeStart alterType(@NonNull CqlIdentifier typeName) {
        return new DefaultAlterType(typeName);
    }

    @NonNull
    public static AlterTypeStart alterType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName) {
        return new DefaultAlterType(keyspace, typeName);
    }

    @NonNull
    public static AlterTypeStart alterType(@NonNull String typeName) {
        return SchemaBuilder.alterType(CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static AlterTypeStart alterType(@Nullable String keyspace, @NonNull String typeName) {
        return SchemaBuilder.alterType(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static Drop dropType(@NonNull CqlIdentifier typeName) {
        return new DefaultDrop(typeName, "TYPE");
    }

    @NonNull
    public static Drop dropType(@NonNull String typeName) {
        return SchemaBuilder.dropType(CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static Drop dropType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName) {
        return new DefaultDrop(keyspace, typeName, "TYPE");
    }

    @NonNull
    public static Drop dropType(@Nullable String keyspace, @NonNull String typeName) {
        return SchemaBuilder.dropType(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)typeName));
    }

    @NonNull
    public static CreateIndexStart createIndex() {
        return new DefaultCreateIndex();
    }

    @NonNull
    public static CreateIndexStart createIndex(@Nullable CqlIdentifier indexName) {
        return new DefaultCreateIndex(indexName);
    }

    @NonNull
    public static CreateIndexStart createIndex(@Nullable String indexName) {
        return SchemaBuilder.createIndex(indexName == null ? null : CqlIdentifier.fromCql((String)indexName));
    }

    @NonNull
    public static Drop dropIndex(@NonNull CqlIdentifier indexName) {
        return new DefaultDrop(indexName, "INDEX");
    }

    @NonNull
    public static Drop dropIndex(@NonNull String indexName) {
        return SchemaBuilder.dropIndex(CqlIdentifier.fromCql((String)indexName));
    }

    @NonNull
    public static Drop dropIndex(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier indexName) {
        return new DefaultDrop(keyspace, indexName, "INDEX");
    }

    @NonNull
    public static Drop dropIndex(@Nullable String keyspace, @NonNull String indexName) {
        return SchemaBuilder.dropIndex(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)indexName));
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull CqlIdentifier functionName) {
        return new DefaultCreateFunction(functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        return new DefaultCreateFunction(keyspace, functionName);
    }

    @NonNull
    public static CreateFunctionStart createFunction(@NonNull String functionName) {
        return new DefaultCreateFunction(CqlIdentifier.fromCql((String)functionName));
    }

    @NonNull
    public static CreateFunctionStart createFunction(@Nullable String keyspace, @NonNull String functionName) {
        return new DefaultCreateFunction(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)functionName));
    }

    @NonNull
    public static Drop dropFunction(@NonNull CqlIdentifier functionName) {
        return new DefaultDrop(functionName, "FUNCTION");
    }

    @NonNull
    public static Drop dropFunction(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        return new DefaultDrop(keyspace, functionName, "FUNCTION");
    }

    @NonNull
    public static Drop dropFunction(@NonNull String functionName) {
        return new DefaultDrop(CqlIdentifier.fromCql((String)functionName), "FUNCTION");
    }

    @NonNull
    public static Drop dropFunction(@Nullable String keyspace, @NonNull String functionName) {
        return new DefaultDrop(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)functionName), "FUNCTION");
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull CqlIdentifier aggregateName) {
        return new DefaultCreateAggregate(aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier aggregateName) {
        return new DefaultCreateAggregate(keyspace, aggregateName);
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@NonNull String aggregateName) {
        return new DefaultCreateAggregate(CqlIdentifier.fromCql((String)aggregateName));
    }

    @NonNull
    public static CreateAggregateStart createAggregate(@Nullable String keyspace, @NonNull String aggregateName) {
        return new DefaultCreateAggregate(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)aggregateName));
    }

    @NonNull
    public static Drop dropAggregate(@NonNull CqlIdentifier aggregateName) {
        return new DefaultDrop(aggregateName, "AGGREGATE");
    }

    @NonNull
    public static Drop dropAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier aggregateName) {
        return new DefaultDrop(keyspace, aggregateName, "AGGREGATE");
    }

    @NonNull
    public static Drop dropAggregate(@NonNull String aggregateName) {
        return new DefaultDrop(CqlIdentifier.fromCql((String)aggregateName), "AGGREGATE");
    }

    @NonNull
    public static Drop dropAggregate(@Nullable String keyspace, @NonNull String aggregateName) {
        return new DefaultDrop(keyspace == null ? null : CqlIdentifier.fromCql((String)keyspace), CqlIdentifier.fromCql((String)aggregateName), "AGGREGATE");
    }

    @NonNull
    public static SizeTieredCompactionStrategy sizeTieredCompactionStrategy() {
        return new DefaultSizeTieredCompactionStrategy();
    }

    @NonNull
    public static LeveledCompactionStrategy leveledCompactionStrategy() {
        return new DefaultLeveledCompactionStrategy();
    }

    @NonNull
    public static TimeWindowCompactionStrategy timeWindowCompactionStrategy() {
        return new DefaultTimeWindowCompactionStrategy();
    }

    @NonNull
    public static UserDefinedType udt(@NonNull CqlIdentifier name, boolean frozen) {
        return new ShallowUserDefinedType(null, name, frozen);
    }

    @NonNull
    public static UserDefinedType udt(@NonNull String name, boolean frozen) {
        return SchemaBuilder.udt(CqlIdentifier.fromCql((String)name), frozen);
    }

    public static class RowsPerPartition {
        private final String value;
        @NonNull
        public static RowsPerPartition ALL = new RowsPerPartition("ALL");
        @NonNull
        public static RowsPerPartition NONE = new RowsPerPartition("NONE");

        private RowsPerPartition(String value) {
            this.value = value;
        }

        @NonNull
        public static RowsPerPartition rows(int rowNumber) {
            return new RowsPerPartition(Integer.toString(rowNumber));
        }

        @NonNull
        public String getValue() {
            return this.value;
        }
    }
}

