/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveDoubleCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DoubleCodec
implements PrimitiveDoubleCodec {
    @Override
    @NonNull
    public GenericType<Double> getJavaType() {
        return GenericType.DOUBLE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.DOUBLE;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof Double;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Double.class || javaClass == Double.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(double value, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes = ByteBuffer.allocate(8);
        bytes.putDouble(0, value);
        return bytes;
    }

    @Override
    public double decodePrimitive(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0.0;
        }
        if (bytes.remaining() != 8) {
            throw new IllegalArgumentException("Invalid 64-bits double value, expecting 8 bytes but got " + bytes.remaining());
        }
        return bytes.getDouble(bytes.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Double value) {
        return value == null ? "NULL" : Double.toString(value);
    }

    @Override
    @Nullable
    public Double parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : Double.valueOf(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 64-bits double value from \"%s\"", value));
        }
    }
}

