/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.util.concurrent.atomic.AtomicLong;

public class LongMax
extends MapStatComponent<Long, LongMax> {
    private static final long serialVersionUID = 1L;
    private final AtomicLong max;

    public LongMax() {
        this(Long.MIN_VALUE);
    }

    private LongMax(long max) {
        this.max = new AtomicLong(max);
    }

    public void add(long value) {
        this.max.updateAndGet(v -> Math.max(v, value));
    }

    public void add(LongMax other) {
        this.max.updateAndGet(v -> Math.max(v, other.max.get()));
    }

    @Override
    protected String getFormattedValue(boolean useCommas) {
        long val = this.max.get();
        if (val == Long.MIN_VALUE) {
            return "unknown";
        }
        return useCommas ? FormatUtil.decimalScale0().format(val) : Long.toString(val);
    }

    @Override
    public LongMax copy() {
        return new LongMax(this.max.get());
    }

    @Override
    public Long get() {
        return this.max.get();
    }

    @Override
    public void clear() {
        this.max.set(Long.MIN_VALUE);
    }

    @Override
    public boolean isNotSet() {
        return this.max.get() == Long.MIN_VALUE;
    }

    public String toString() {
        return "LongMax[" + this.max + "]";
    }
}

