/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.DoubleExpMovingAvg;
import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;

public class LongAvgRate
extends MapStatComponent<Long, LongAvgRate> {
    private static final long serialVersionUID = 1L;
    public static final long MIN_PERIOD = 200L;
    private final TimeUnit reportTimeUnit;
    private final DoubleExpMovingAvg avg;
    private long prevValue;
    private long prevTime;

    public LongAvgRate(String name, long periodMillis, TimeUnit reportTimeUnit) {
        this.avg = new DoubleExpMovingAvg(name, periodMillis);
        assert (reportTimeUnit != null);
        this.reportTimeUnit = reportTimeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongAvgRate(LongAvgRate other) {
        this.avg = new DoubleExpMovingAvg(other.avg.copy());
        this.reportTimeUnit = other.reportTimeUnit;
        LongAvgRate longAvgRate = this;
        synchronized (longAvgRate) {
            LongAvgRate longAvgRate2 = other;
            synchronized (longAvgRate2) {
                this.prevValue = other.prevValue;
                this.prevTime = other.prevTime;
            }
        }
    }

    public String getName() {
        return this.avg.getName();
    }

    public synchronized void add(long value, long time) {
        assert (time > 0L);
        if (this.prevTime != 0L) {
            long deltaTime = time - this.prevTime;
            if (deltaTime < 200L) {
                return;
            }
            this.avg.add((double)(value - this.prevValue) / (double)deltaTime, time);
        }
        this.prevValue = value;
        this.prevTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LongAvgRate other) {
        LongAvgRate copyOther = other.copy();
        LongAvgRate longAvgRate = this;
        synchronized (longAvgRate) {
            LongAvgRate longAvgRate2 = copyOther;
            synchronized (longAvgRate2) {
                this.addInternal(copyOther);
            }
        }
    }

    private void addInternal(LongAvgRate other) {
        assert (Thread.holdsLock(this));
        assert (Thread.holdsLock(other));
        if (other.prevTime - this.prevTime > 200L) {
            this.avg.add(other.avg);
            this.prevValue = other.prevValue;
            this.prevTime = other.prevTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongAvgRate copyLatest(LongAvgRate other) {
        LongAvgRate otherCopy = other.copy();
        LongAvgRate longAvgRate = this;
        synchronized (longAvgRate) {
            LongAvgRate longAvgRate2 = otherCopy;
            synchronized (longAvgRate2) {
                LongAvgRate result;
                if (this.prevTime > otherCopy.prevTime) {
                    otherCopy.addInternal(this);
                    return otherCopy;
                }
                LongAvgRate longAvgRate3 = result = this.copy();
                synchronized (longAvgRate3) {
                    result.addInternal(otherCopy);
                    return result;
                }
            }
        }
    }

    synchronized long getPrevTime() {
        return this.prevTime;
    }

    @Override
    public Long get() {
        return this.getPrimitive();
    }

    private long getPrimitive() {
        double inMillis = this.avg.getPrimitive();
        if (this.reportTimeUnit == TimeUnit.MILLISECONDS) {
            return Math.round(inMillis);
        }
        if (this.reportTimeUnit.compareTo(TimeUnit.MILLISECONDS) < 0) {
            return Math.round(inMillis / (double)this.reportTimeUnit.convert(1L, TimeUnit.MILLISECONDS));
        }
        return Math.round(inMillis * (double)this.reportTimeUnit.toMillis(1L));
    }

    @Override
    public synchronized void clear() {
        this.avg.clear();
        this.prevValue = 0L;
        this.prevTime = 0L;
    }

    @Override
    public LongAvgRate copy() {
        return new LongAvgRate(this);
    }

    @Override
    protected String getFormattedValue(boolean useCommas) {
        if (this.isNotSet()) {
            return "unknown";
        }
        long val = this.getPrimitive();
        if (useCommas) {
            return FormatUtil.decimalScale0().format(val);
        }
        return Long.toString(val);
    }

    @Override
    public boolean isNotSet() {
        return this.avg.isNotSet();
    }

    public synchronized String toString() {
        return "LongAvgRate[" + this.avg + ", prevValue=" + this.prevValue + ", prevTime=" + this.prevTime + "]";
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

