/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Timestamp;
import com.sleepycat.je.utilint.VLSN;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MatchpointSearchResults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long matchpointLSN;
    private boolean passedCheckpointEnd;
    private boolean passedSkippedGap;
    private final List<PassedTxnInfo> passedTxns;
    private final int passedTxnLimit;
    private PassedTxnInfo earliestPassedTxn;
    private PassedTxnInfo penultimatePassedTxn;
    private int numPassedCommits;
    private int numPassedDurableCommits;
    private VLSN dtvlsn = VLSN.NULL_VLSN;

    public MatchpointSearchResults(EnvironmentImpl envImpl) {
        this.matchpointLSN = DbLsn.makeLsn(0L, 0);
        this.passedTxnLimit = envImpl.getConfigManager().getInt(RepParams.TXN_ROLLBACK_LIMIT);
        this.passedTxns = new ArrayList<PassedTxnInfo>();
        this.numPassedCommits = 0;
        this.numPassedDurableCommits = 0;
    }

    void notePassedCheckpointEnd() {
        this.passedCheckpointEnd = true;
    }

    void noteSkippedGap() {
        this.passedSkippedGap = true;
    }

    void setMatchpoint(long match) {
        this.matchpointLSN = match;
        if (this.earliestPassedTxn != null && this.earliestPassedTxn.lsn == this.matchpointLSN) {
            --this.numPassedCommits;
            if (this.passedTxns.size() > 0) {
                int lastSavedTxn = this.passedTxns.size() - 1;
                if (this.passedTxns.get((int)lastSavedTxn).lsn == match) {
                    this.passedTxns.remove(lastSavedTxn);
                }
                this.earliestPassedTxn = this.penultimatePassedTxn;
            }
        }
    }

    void notePassedCommits(TxnCommit commit, VLSN commitVLSN, long commitLSN) {
        boolean durableCommit = false;
        Timestamp commitTime = commit.getTime();
        long txnId = commit.getId();
        long commitDTVLSN = commit.getDTVLSN();
        if (commitVLSN != null && !commitVLSN.isNull()) {
            this.processDTVLSN(commitVLSN, commitDTVLSN);
            if (commit.hasLoggedEntries() && (this.dtvlsn.getSequence() == 0L || commitVLSN.compareTo(this.dtvlsn) <= 0)) {
                ++this.numPassedDurableCommits;
                durableCommit = true;
            }
        }
        ++this.numPassedCommits;
        if (this.earliestPassedTxn != null) {
            this.penultimatePassedTxn = this.earliestPassedTxn;
        }
        this.earliestPassedTxn = new PassedTxnInfo(commitTime, txnId, commitVLSN, commitLSN, durableCommit);
        if (this.numPassedCommits <= this.passedTxnLimit) {
            this.passedTxns.add(this.earliestPassedTxn);
        }
    }

    private void processDTVLSN(VLSN txnEndVLSN, long txnEndDTVLSN) {
        if (this.dtvlsn.isNull()) {
            this.dtvlsn = new VLSN(txnEndDTVLSN);
        } else if (txnEndDTVLSN > this.dtvlsn.getSequence() && this.dtvlsn.getSequence() != 0L) {
            throw new IllegalStateException("DTVLSNs should only decrease with decreasing VLSNs. prev:" + this.dtvlsn + " next:" + txnEndDTVLSN + " commit VLSN:" + txnEndVLSN);
        }
    }

    void notePassedAborts(TxnAbort abort, VLSN abortVLSN) {
        if (abortVLSN.isNull()) {
            return;
        }
        long abortDTVLSN = abort.getDTVLSN();
        this.processDTVLSN(abortVLSN, abortDTVLSN);
    }

    boolean getPassedCheckpointEnd() {
        return this.passedCheckpointEnd;
    }

    boolean getSkippedGap() {
        return this.passedSkippedGap;
    }

    public long getMatchpointLSN() {
        return this.matchpointLSN;
    }

    public int getNumPassedCommits() {
        return this.numPassedCommits;
    }

    public int getNumPassedDurableCommits() {
        return this.numPassedDurableCommits;
    }

    public PassedTxnInfo getEarliestPassedTxn() {
        return this.earliestPassedTxn;
    }

    public VLSN getDTVLSN() {
        return this.dtvlsn;
    }

    public String dumpPassedTxns() {
        StringBuilder sb = new StringBuilder();
        for (PassedTxnInfo info : this.passedTxns) {
            sb.append(info);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return "matchpointLSN=" + DbLsn.getNoFormatString(this.matchpointLSN) + " passedCkpt=" + this.passedCheckpointEnd + " passedTxnLimit=" + this.passedTxnLimit + " passedTxns=" + this.passedTxns + " earliestTxn=" + this.earliestPassedTxn + " penultimateTxn=" + this.penultimatePassedTxn + " numPassedCommits=" + this.numPassedCommits + " numPassedDurableCommits=" + this.numPassedDurableCommits + " passedSkippedGap=" + this.passedSkippedGap;
    }

    public String getRollbackMsg() {
        if (this.numPassedCommits == 0) {
            return " uncommitted operations";
        }
        if (this.numPassedDurableCommits == 0) {
            return " " + this.numPassedCommits + " total commits to the earliest point indicated by transaction " + this.earliestPassedTxn;
        }
        return " " + this.numPassedCommits + " total commits(" + this.numPassedDurableCommits + " of which were durable) to the earliest point indicated by transaction " + this.earliestPassedTxn;
    }

    public static class PassedTxnInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Timestamp time;
        public final long id;
        public final VLSN vlsn;
        public final long lsn;
        public final boolean durableCommit;

        PassedTxnInfo(Timestamp time, long id, VLSN vlsn, long lsn, boolean durableCommit) {
            this.time = time;
            this.id = id;
            this.vlsn = vlsn;
            this.lsn = lsn;
            this.durableCommit = durableCommit;
        }

        public String toString() {
            return "id=" + this.id + " time=" + this.time + " vlsn=" + this.vlsn + " lsn=" + DbLsn.getNoFormatString(this.lsn) + " durable=" + this.durableCommit;
        }
    }
}

