/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node.cbvlsn;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.impl.MinJEVersionUnsupportedException;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.cbvlsn.CleanerBarrierState;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalCBVLSN {
    private static final JEVersion DEFUNCT_JE_VERSION = new JEVersion("7.5.0");
    private final RepImpl repImpl;
    private final Logger logger;
    private final long streamTimeoutMs;
    private final int minRetainedVLSNs;
    private volatile boolean defunct = false;
    private volatile VLSN groupCBVLSN = VLSN.NULL_VLSN;

    public GlobalCBVLSN(RepNode repNode) {
        this.repImpl = repNode.getRepImpl();
        this.streamTimeoutMs = this.repImpl.getConfigManager().getDuration(RepParams.REP_STREAM_TIMEOUT);
        this.minRetainedVLSNs = this.repImpl.getConfigManager().getInt(RepParams.MIN_RETAINED_VLSNS);
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public void init(RepNode repNode, JEVersion minJEVersion) {
        if (repNode.getRepImpl().getConfigManager().getBoolean(RepParams.TEST_CBVLSN)) {
            assert (!this.defunct);
            return;
        }
        if (minJEVersion != null && DEFUNCT_JE_VERSION.compareTo(minJEVersion) <= 0) {
            this.defunct = true;
        } else assert (!this.defunct);
    }

    public void setDefunctJEVersion(RepNode repNode) {
        if (repNode.getRepImpl().getConfigManager().getBoolean(RepParams.TEST_CBVLSN)) {
            return;
        }
        try {
            repNode.setMinJEVersion(DEFUNCT_JE_VERSION);
            this.defunct = true;
        }
        catch (OperationFailureException | MinJEVersionUnsupportedException exception) {
            // empty catch block
        }
    }

    public boolean isDefunct() {
        return this.defunct;
    }

    public VLSN getCBVLSN() {
        return this.defunct ? VLSN.NULL_VLSN : this.groupCBVLSN;
    }

    public void updateGroupInfo(NameIdPair updateNameIdPair, CleanerBarrierState barrierState) {
        if (this.defunct) {
            return;
        }
        RepGroupImpl group = this.repImpl.getRepNode().getGroup();
        RepNodeImpl node = group.getMember(updateNameIdPair.getName());
        if (node == null) {
            return;
        }
        LoggerUtils.fine(this.logger, this.repImpl, "LocalCBVLSN for " + updateNameIdPair + " updated to " + barrierState + " from " + node.getBarrierState().getLastCBVLSN());
        node.setBarrierState(barrierState);
        this.recalculate(group);
    }

    public void recalculate(RepGroupImpl groupInfo) {
        VLSN rangeFirst;
        if (this.defunct) {
            return;
        }
        Object maxCBVLSN = VLSN.NULL_VLSN;
        long latestBarrierTime = 0L;
        String nodeName = null;
        for (RepNodeImpl node : groupInfo.getDataMembers()) {
            CleanerBarrierState nodeBarrier = node.getBarrierState();
            VLSN cbvlsn = nodeBarrier.getLastCBVLSN();
            if (cbvlsn == null || cbvlsn.isNull()) continue;
            long nodeBarrierTime = nodeBarrier.getBarrierTime();
            if (((VLSN)maxCBVLSN).compareTo(cbvlsn) > 0) continue;
            latestBarrierTime = cbvlsn.equals((VLSN)maxCBVLSN) ? Math.min(nodeBarrierTime, latestBarrierTime) : nodeBarrierTime;
            maxCBVLSN = cbvlsn;
            nodeName = node.getName();
        }
        if (latestBarrierTime == 0L) {
            return;
        }
        if (((VLSN)maxCBVLSN).isNull()) {
            return;
        }
        VLSN newGroupCBVLSN = maxCBVLSN;
        long nodeBarrierTime = 0L;
        for (RepNodeImpl node : groupInfo.getDataMembers()) {
            CleanerBarrierState nodeBarrier = node.getBarrierState();
            VLSN nodeCBVLSN = nodeBarrier.getLastCBVLSN();
            if (nodeCBVLSN == null || nodeCBVLSN.isNull() || latestBarrierTime - nodeBarrier.getBarrierTime() > this.streamTimeoutMs || newGroupCBVLSN.compareTo(nodeCBVLSN) <= 0) continue;
            newGroupCBVLSN = nodeCBVLSN;
            nodeName = node.getName();
            nodeBarrierTime = nodeBarrier.getBarrierTime();
        }
        newGroupCBVLSN = new VLSN(newGroupCBVLSN.getSequence() - (long)this.minRetainedVLSNs);
        VLSNIndex vlsnIndex = this.repImpl.getVLSNIndex();
        VLSN vLSN = rangeFirst = vlsnIndex != null ? vlsnIndex.getRange().getFirst() : VLSN.FIRST_VLSN;
        if (rangeFirst.compareTo(newGroupCBVLSN) > 0) {
            newGroupCBVLSN = rangeFirst;
        }
        this.updateGroupCBVLSN(groupInfo, newGroupCBVLSN, nodeName, nodeBarrierTime, latestBarrierTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroupCBVLSN(RepGroupImpl groupInfo, VLSN newGroupCBVLSN, String nodeName, long nodeBarrierTime, long latestBarrierTime) {
        assert (!this.defunct);
        boolean changed = false;
        String cbvlsnLoweredMessage = null;
        VLSN oldCBVLSN = VLSN.NULL_VLSN;
        GlobalCBVLSN globalCBVLSN = this;
        synchronized (globalCBVLSN) {
            if (newGroupCBVLSN.compareTo(this.groupCBVLSN) > 0) {
                VLSNRange currentRange = this.repImpl.getVLSNIndex().getRange();
                if (!currentRange.contains(newGroupCBVLSN) && this.logger.isLoggable(Level.FINE)) {
                    cbvlsnLoweredMessage = "GroupCBVLSN: " + newGroupCBVLSN + " is outside VLSN range: " + currentRange + " Current group:" + groupInfo;
                } else {
                    oldCBVLSN = this.groupCBVLSN;
                    this.groupCBVLSN = newGroupCBVLSN;
                    changed = true;
                }
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            if (cbvlsnLoweredMessage != null) {
                LoggerUtils.fine(this.logger, this.repImpl, cbvlsnLoweredMessage);
            }
            if (changed) {
                LoggerUtils.fine(this.logger, this.repImpl, "Global CBVLSN changed from " + oldCBVLSN + " to " + newGroupCBVLSN);
            }
        }
    }

    public VLSN getRestoreResponseVLSN(VLSNRange range) {
        if (this.defunct) {
            return VLSN.NULL_VLSN;
        }
        long vlsn = range.getLast().getSequence() - (long)this.repImpl.getConfigManager().getInt(RepParams.NETWORKBACKUP_MAX_LAG);
        return new VLSN(Math.max(0L, vlsn));
    }
}

