/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class InsufficientLogException
extends RestartRequiredException {
    private static final long serialVersionUID = 1L;
    private static final String P_NUMPROVIDERS = "P_NUMPROVIDERS";
    private static final String P_NODENAME = "P_NODENAME";
    private static final String P_NODETYPE = "P_NODETYPE";
    private static final String P_HOSTNAME = "P_HOSTNAME";
    private static final String P_PORT = "P_PORT";
    private static final String GROUP_NAME = "GROUP_NAME";
    private static final String NODE_NAME = "NODE_NAME";
    private static final String HOSTNAME = "HOSTNAME";
    private static final String PORT = "PORT";
    private static final String ENV_DIR = "ENV_DIR";
    private static final String REFRESH_VLSN = "REFRESH_VLSN";
    private transient RepImpl repImpl;
    private boolean openedByILE;
    private final transient Properties props;
    private final transient ReplicationNetworkConfig repNetConfig;
    private final VLSN refreshVLSN;
    private final Set<ReplicationNode> logProviders;

    public InsufficientLogException(String message) {
        super(null, EnvironmentFailureReason.UNEXPECTED_STATE, message);
        this.repImpl = null;
        this.refreshVLSN = null;
        this.logProviders = null;
        this.props = null;
        this.repNetConfig = ReplicationNetworkConfig.createDefault();
    }

    public InsufficientLogException(RepNode repNode, Set<ReplicationNode> logProviders) {
        super(repNode.getRepImpl(), EnvironmentFailureReason.INSUFFICIENT_LOG);
        this.repImpl = repNode.getRepImpl();
        this.refreshVLSN = VLSN.NULL_VLSN;
        this.logProviders = logProviders;
        this.props = this.initProperties(repNode.getGroup().getName());
        this.repNetConfig = this.repImpl.getRepNetConfig();
    }

    private Properties initProperties(String groupName) {
        Properties p = new Properties();
        p.setProperty(GROUP_NAME, groupName);
        p.setProperty(NODE_NAME, this.repImpl.getNameIdPair().getName());
        p.setProperty(HOSTNAME, this.repImpl.getHostName());
        p.setProperty(PORT, Integer.toString(this.repImpl.getPort()));
        p.setProperty(ENV_DIR, this.repImpl.getEnvironmentHome().getPath());
        p.setProperty(REFRESH_VLSN, Long.toString(this.refreshVLSN.getSequence()));
        p.setProperty(P_NUMPROVIDERS, Integer.toString(this.logProviders.size()));
        int i = 0;
        for (ReplicationNode rn : this.logProviders) {
            p.setProperty(P_NODENAME + i, rn.getName());
            p.setProperty(P_HOSTNAME + i, rn.getHostName());
            p.setProperty(P_PORT + i, Integer.toString(rn.getPort()));
            p.setProperty(P_NODETYPE + i, rn.getType().name());
            ++i;
        }
        return p;
    }

    public InsufficientLogException(RepImpl repImpl, VLSN refreshVLSN) {
        super(repImpl, EnvironmentFailureReason.INSUFFICIENT_LOG);
        this.repImpl = repImpl;
        this.refreshVLSN = refreshVLSN;
        this.logProviders = new HashSet<ReplicationNode>();
        this.props = this.initProperties("NO_GROUP");
        this.repNetConfig = repImpl.getRepNetConfig();
    }

    public InsufficientLogException(Properties restoreProperties, String helperHosts, ReplicationNetworkConfig repNetConfig) {
        super(null, EnvironmentFailureReason.INSUFFICIENT_LOG);
        String vlsnVal = restoreProperties.getProperty(REFRESH_VLSN);
        this.refreshVLSN = new VLSN(Long.parseLong(vlsnVal));
        this.logProviders = new HashSet<ReplicationNode>();
        if (helperHosts != null) {
            for (String hostPortPair : helperHosts.split(",")) {
                String hpp = hostPortPair.trim();
                if (hpp.length() <= 0) continue;
                LogFileSource source = new LogFileSource("NoName", NodeType.ELECTABLE.name(), HostPortPair.getHostname(hpp), HostPortPair.getPort(hpp));
                this.logProviders.add(source);
            }
        }
        this.props = restoreProperties;
        this.repNetConfig = repNetConfig;
    }

    private void initRepImpl() {
        int numLogProviders = Integer.parseInt(this.props.getProperty(P_NUMPROVIDERS));
        for (int i = 0; i < numLogProviders; ++i) {
            String name = this.props.getProperty(P_NODENAME + i);
            String nodeType = this.props.getProperty(P_NODETYPE + i);
            String hostname = this.props.getProperty(P_HOSTNAME + i);
            int port = Integer.parseInt(this.props.getProperty(P_PORT + i));
            this.logProviders.add(new LogFileSource(name, nodeType, hostname, port));
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        envConfig.setTransactional(true);
        String hostname = this.props.getProperty(HOSTNAME);
        int portVal = Integer.parseInt(this.props.getProperty(PORT));
        ReplicationConfig repConfig = new ReplicationConfig(this.props.getProperty(GROUP_NAME), this.props.getProperty(NODE_NAME), HostPortPair.getString(hostname, portVal));
        repConfig.setConfigParam(RepParams.NETWORKBACKUP_USE.getName(), "true");
        repConfig.setRepNetConfig(this.repNetConfig);
        File envDir = new File(this.props.getProperty(ENV_DIR));
        ReplicatedEnvironment restoreEnv = RepInternal.createInternalEnvHandle(envDir, repConfig, envConfig);
        this.repImpl = RepInternal.getRepImpl(restoreEnv);
        String nrChannelType = this.repImpl.getRepNetConfig().getChannelType();
        String preNRChannelType = this.repNetConfig.getChannelType();
        if (!nrChannelType.equals(preNRChannelType)) {
            throw new IllegalStateException("Network Restore channel state: " + nrChannelType + ", pre network restore state:" + preNRChannelType);
        }
        this.openedByILE = true;
    }

    private InsufficientLogException(String message, InsufficientLogException cause) {
        super(message, cause);
        this.repImpl = cause.repImpl;
        this.openedByILE = cause.openedByILE;
        this.refreshVLSN = cause.refreshVLSN;
        this.logProviders = cause.logProviders;
        this.props = cause.props;
        this.repNetConfig = cause.repNetConfig;
    }

    @Override
    public EnvironmentFailureException wrapSelf(String msg) {
        return new InsufficientLogException(msg, this);
    }

    public Set<ReplicationNode> getLogProviders() {
        return this.logProviders;
    }

    public RepImpl getRepImpl() {
        if (this.repImpl == null) {
            this.initRepImpl();
        }
        return this.repImpl;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("refreshVLSN=").append(this.refreshVLSN);
        sb.append(" logProviders=").append(this.logProviders);
        sb.append(" repImpl=").append(this.repImpl);
        sb.append(" props=").append(this.props);
        return sb.toString();
    }

    public Properties getProperties() {
        return this.props;
    }

    void releaseRepImpl() {
        if (this.repImpl == null) {
            return;
        }
        try {
            if (this.openedByILE) {
                this.repImpl.close();
            }
        }
        finally {
            this.repImpl = null;
        }
    }

    private class LogFileSource
    implements ReplicationNode {
        private final String name;
        private final NodeType type;
        private final String hostname;
        private final int port;

        LogFileSource(String name, String nodeTypeName, String hostname, int port) {
            this.name = name;
            this.type = NodeType.valueOf(nodeTypeName);
            this.hostname = hostname;
            this.port = port;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public NodeType getType() {
            return this.type;
        }

        @Override
        public InetSocketAddress getSocketAddress() {
            return new InetSocketAddress(this.hostname, this.port);
        }

        @Override
        public String getHostName() {
            return this.hostname;
        }

        @Override
        public int getPort() {
            return this.port;
        }
    }
}

