/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;

public class UtilizationTracker
extends BaseUtilizationTracker {
    UtilizationTracker(EnvironmentImpl env, Cleaner cleaner) {
        super(env, cleaner);
    }

    @Override
    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public long evictMemory() throws DatabaseException {
        if (!this.cleaner.trackDetail) {
            return 0L;
        }
        if (!this.env.isValid()) {
            return 0L;
        }
        if (this.env.isReadOnly()) {
            return 0L;
        }
        MemoryBudget mb = this.env.getMemoryBudget();
        long totalEvicted = 0L;
        long totalBytes = 0L;
        int largestBytes = 0;
        TrackedFileSummary bestFile = null;
        int ONE_MB = 0x100000;
        for (TrackedFileSummary tfs : this.getTrackedFiles()) {
            int mem = tfs.getMemorySize();
            if (mem >= 0x100000) {
                this.env.getUtilizationProfile().flushFileSummary(tfs);
                totalEvicted += (long)mem;
                continue;
            }
            totalBytes += (long)mem;
            if (mem <= largestBytes || !tfs.getAllowFlush()) continue;
            largestBytes = mem;
            bestFile = tfs;
        }
        if (bestFile != null && totalBytes > mb.getTrackerBudget()) {
            this.env.getUtilizationProfile().flushFileSummary(bestFile);
            totalEvicted += (long)largestBytes;
        }
        return totalEvicted;
    }

    public void countNewLogEntry(long lsn, LogEntryType type, int size) {
        this.countNew(lsn, type, size);
    }

    public void countObsoleteNode(long lsn, LogEntryType type, int size) {
        this.countObsolete(lsn, type, size, true, true);
    }

    public void countObsoleteNodeInexact(long lsn, LogEntryType type, int size) {
        this.countObsolete(lsn, type, size, false, false);
    }

    public void countObsoleteNodeDupsAllowed(long lsn, LogEntryType type, int size) {
        this.countObsolete(lsn, type, size, true, false);
    }

    public TrackedFileSummary getUnflushableTrackedSummary(long fileNum) {
        TrackedFileSummary file = this.getFileSummary(fileNum);
        file.setAllowFlush(false);
        return file;
    }
}

