/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.EraserAbortException;
import com.sleepycat.je.cleaner.EraserStatDefinition;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.PollCondition;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TracerFormatter;
import com.sleepycat.je.utilint.VLSN;
import com.sleepycat.utilint.FormatUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataEraser
extends StoppableThread
implements EnvConfigObserver {
    private static final int MAX_FILE_INFO_MS = 1000;
    private static final int MIN_WORK_DELAY_MS = 5;
    private static final int MAX_SLEEP_MS = 100;
    private static final int FOREVER_TIMEOUT_MS = 300000;
    private static final int NO_UNPROTECTED_FILES_DELAY_MS = 1000;
    private static final String TEST_ERASE_PERIOD = "test.erasePeriod";
    private static TestHook<TestEvent> testEventHook;
    private static final DateFormat DATE_FORMAT;
    private static final int WRITE_WORK_PCT = 50;
    private static final int FSYNC1_WORK_PCT = 18;
    private static final int FSYNC2_WORK_PCT = 16;
    private static final int FSYNC3_WORK_PCT = 16;
    private final Cleaner cleaner;
    private final FileProtector fileProtector;
    private final FileManager fileManager;
    private final Logger logger;
    private volatile boolean shutdownRequested = false;
    private volatile boolean enabled = false;
    private int terminateMillis;
    private volatile long cycleMs = 0L;
    private boolean eraseDeletedDbs = false;
    private boolean eraseExtinctRecords = false;
    private int pollCheckMs;
    private long[] eraseOffsets = new long[5120];
    private int[] eraseSizes = new int[this.eraseOffsets.length];
    private byte[] zeros = new byte[10240];
    private final Object pollMutex = new Object();
    private final NavigableMap<Long, FileInfo> fileInfoCache = new TreeMap<Long, FileInfo>();
    private WorkThrottle cycleThrottle;
    private long totalCycleWork;
    private String lastProtectedFilesMsg;
    private Level lastProtectedFilesMsgLevel;
    private volatile long startTime;
    private volatile long endTime;
    private volatile long completionTime;
    private NavigableSet<Long> filesRemaining = Collections.emptyNavigableSet();
    private NavigableSet<Long> filesCompleted = Collections.emptyNavigableSet();
    private final AtomicInteger filesErased = new AtomicInteger();
    private final AtomicInteger filesDeleted = new AtomicInteger();
    private final AtomicInteger filesAlreadyDeleted = new AtomicInteger();
    private final AtomicInteger fSyncs = new AtomicInteger();
    private final AtomicLong reads = new AtomicLong();
    private final AtomicLong readBytes = new AtomicLong();
    private final AtomicLong writes = new AtomicLong();
    private final AtomicLong writeBytes = new AtomicLong();
    private final Object currentFileMutex = new Object();
    private volatile Long currentFile;
    private boolean abortCurrentFile;
    private int abortTimeoutMs;

    public DataEraser(EnvironmentImpl envImpl) {
        super(envImpl, "JEErasure");
        this.cleaner = envImpl.getCleaner();
        this.fileProtector = envImpl.getFileProtector();
        this.fileManager = envImpl.getFileManager();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.envConfigUpdate(envImpl.getConfigManager(), null);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) {
        boolean runErase;
        String testErasePeriod = System.getProperty(TEST_ERASE_PERIOD);
        if (testErasePeriod != null && !configManager.isSpecified(EnvironmentParams.ENV_RUN_ERASER)) {
            runErase = true;
            this.cycleMs = PropUtil.parseDuration(testErasePeriod);
            this.eraseDeletedDbs = true;
            this.eraseExtinctRecords = true;
        } else {
            runErase = configManager.getBoolean(EnvironmentParams.ENV_RUN_ERASER);
            this.cycleMs = configManager.getDuration(EnvironmentParams.ERASE_PERIOD);
            this.eraseDeletedDbs = configManager.getBoolean(EnvironmentParams.ERASE_DELETED_DATABASES);
            this.eraseExtinctRecords = configManager.getBoolean(EnvironmentParams.ERASE_EXTINCT_RECORDS);
        }
        this.enabled = runErase && this.cycleMs > 0L && (this.eraseDeletedDbs || this.eraseExtinctRecords);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.pollCheckMs = Math.min(100, this.terminateMillis / 4);
        this.abortTimeoutMs = configManager.getDuration(EnvironmentParams.ERASE_ABORT_TIMEOUT);
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup statGroup = new StatGroup("Eraser", "Obsolete data is erased during each erasure cycle.");
        DateFormat dateFormat = TracerFormatter.makeDateFormat();
        new StringStat(statGroup, EraserStatDefinition.ERASER_CYCLE_START, this.startTime == 0L ? "" : dateFormat.format(new Date(this.startTime)));
        new StringStat(statGroup, EraserStatDefinition.ERASER_CYCLE_END, this.endTime == 0L ? "" : dateFormat.format(new Date(this.endTime)));
        new IntStat(statGroup, EraserStatDefinition.ERASER_FILES_REMAINING, this.filesRemaining.size());
        boolean clear = config.getClear();
        new IntStat(statGroup, EraserStatDefinition.ERASER_FILES_ERASED, this.getStat(this.filesErased, clear));
        new IntStat(statGroup, EraserStatDefinition.ERASER_FILES_DELETED, this.getStat(this.filesDeleted, clear));
        new IntStat(statGroup, EraserStatDefinition.ERASER_FILES_ALREADY_DELETED, this.getStat(this.filesAlreadyDeleted, clear));
        new IntStat(statGroup, EraserStatDefinition.ERASER_FSYNCS, this.getStat(this.fSyncs, clear));
        new LongStat(statGroup, EraserStatDefinition.ERASER_READS, this.getStat(this.reads, clear));
        new LongStat(statGroup, EraserStatDefinition.ERASER_READ_BYTES, this.getStat(this.readBytes, clear));
        new LongStat(statGroup, EraserStatDefinition.ERASER_WRITES, this.getStat(this.writes, clear));
        new LongStat(statGroup, EraserStatDefinition.ERASER_WRITE_BYTES, this.getStat(this.writeBytes, clear));
        return statGroup;
    }

    private long getStat(AtomicLong val, boolean clear) {
        return clear ? val.getAndSet(0L) : val.get();
    }

    private int getStat(AtomicInteger val, boolean clear) {
        return clear ? val.getAndSet(0) : val.get();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initiateSoftShutdown() {
        this.shutdownRequested = true;
        Object object = this.pollMutex;
        synchronized (object) {
            this.pollMutex.notify();
        }
        return this.terminateMillis;
    }

    public void startThread() {
        if (this.enabled && !this.envImpl.isMemOnly() && !this.envImpl.isReadOnly() && !this.isAlive()) {
            this.envImpl.getMetadataStore().openDb();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean isInitialized = false;
        boolean isStarted = false;
        try {
            while (true) {
                this.checkShutdown();
                try {
                    if (!isInitialized) {
                        isInitialized = true;
                        if (this.resumeCycle()) {
                            isStarted = true;
                        }
                    }
                    if (!isStarted) {
                        this.startCycle();
                        isStarted = true;
                    }
                    if (this.checkForCycleEnd()) {
                        this.waitForEnabled();
                        isStarted = false;
                        continue;
                    }
                    Long file = this.getNextFile();
                    if (file != null) {
                        try {
                            this.eraseFile(file);
                            this.filesCompleted.add(file);
                            this.filesRemaining.remove(file);
                            this.storeState();
                            continue;
                        }
                        finally {
                            this.clearCurrentFile();
                            continue;
                        }
                    }
                    this.waitForCycleEnd();
                    this.waitForEnabled();
                    isStarted = false;
                }
                catch (NoUnprotectedFilesException e) {
                    this.waitForUnprotectedFiles(e);
                }
                catch (ErasureDisabledException e) {
                    this.waitForEnabled();
                }
                catch (PeriodChangedException e) {
                    this.logPeriodChanged();
                    isStarted = false;
                }
                catch (AbortCurrentFileException e) {}
            }
        }
        catch (ShutdownRequestedException e) {
            if (!this.filesRemaining.isEmpty()) {
                this.logCycleSuspend();
            }
            return;
        }
    }

    private boolean resumeCycle() {
        if (!this.loadState()) {
            return false;
        }
        if (System.currentTimeMillis() >= this.endTime) {
            if (!this.filesRemaining.isEmpty()) {
                this.logCycleCannotResume();
            }
            return false;
        }
        this.logCycleResume();
        WorkThrottle throttle = this.createFileInfoThrottle(this.filesRemaining.size(), this.cycleMs);
        for (Long file : this.filesRemaining) {
            this.fileInfoCache.put(file, new FileInfo(this.getFileCreationTime(file), this.getFileLength(file)));
            throttle.throttle(1L);
        }
        this.cycleThrottle = new WorkThrottle(this.totalCycleWork, this.endTime - this.startTime);
        return true;
    }

    private void startCycle() {
        long localCycleMs = this.cycleMs;
        this.startTime = System.currentTimeMillis();
        this.endTime = this.startTime + localCycleMs;
        long fileAgeCutoff = this.startTime - localCycleMs;
        this.filesCompleted = Collections.synchronizedNavigableSet(new TreeSet());
        this.filesRemaining = Collections.synchronizedNavigableSet(new TreeSet());
        this.completionTime = 0L;
        NavigableSet<Long> allFiles = this.fileProtector.getAllCompletedFiles();
        WorkThrottle throttle = this.createFileInfoThrottle(allFiles.size(), localCycleMs);
        this.logCycleInit(allFiles.size());
        for (Long file2 : allFiles) {
            FileInfo prevInfo = (FileInfo)this.fileInfoCache.get(file2);
            if (prevInfo != null) {
                if (prevInfo.creationTime > fileAgeCutoff) continue;
                this.filesRemaining.add(file2);
                continue;
            }
            long creationTime = this.getFileCreationTime(file2);
            throttle.throttle(1L);
            if (creationTime > fileAgeCutoff) continue;
            this.filesRemaining.add(file2);
            this.fileInfoCache.put(file2, new FileInfo(creationTime, this.getFileLength(file2)));
        }
        this.fileInfoCache.navigableKeySet().retainAll(this.filesRemaining);
        this.totalCycleWork = this.filesRemaining.stream().mapToLong(file -> ((FileInfo)this.fileInfoCache.get((Object)file)).length).sum() * 3L;
        this.cycleThrottle = new WorkThrottle(this.totalCycleWork, this.endTime - this.startTime);
        this.logCycleStart();
    }

    private WorkThrottle createFileInfoThrottle(int files, long localCycleMs) {
        long workTime = Math.min(localCycleMs / 1000L, (long)(files * 1000));
        return new WorkThrottle(files, workTime);
    }

    private long getFileCreationTime(long file) {
        try {
            return this.fileManager.getFileHeaderTimestamp(file).getTime();
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, "Exception erasing file 0x" + Long.toHexString(file), e);
        }
        catch (FileNotFoundException e) {
            return Long.MAX_VALUE;
        }
    }

    private long getFileLength(long file) {
        return new File(this.fileManager.getFullFileName(file)).length();
    }

    private Long getNextFile() {
        this.lastProtectedFilesMsg = null;
        this.lastProtectedFilesMsgLevel = null;
        if (this.filesRemaining.isEmpty()) {
            return null;
        }
        Long file = this.getNextUnprotectedFile();
        if (file != null) {
            return file;
        }
        if (!this.cleaner.isFileDeletionEnabled()) {
            throw new NoUnprotectedFilesException("Test mode prohibits VLSNIndex truncation.", Level.INFO);
        }
        long lastRecoveryFile = this.getFirstFileInRecoveryInterval();
        if ((Long)this.filesRemaining.first() >= lastRecoveryFile) {
            throw new NoUnprotectedFilesException("All remaining files are in the recovery interval, lastRecoveryFile=0x" + Long.toHexString(lastRecoveryFile) + ".", Level.INFO);
        }
        if (!this.envImpl.isReplicated()) {
            throw new NoUnprotectedFilesException("Protected files are not in the recovery interval.", Level.WARNING);
        }
        long vlsnIndexStartFile = this.fileProtector.getVLSNIndexStartFile();
        if (vlsnIndexStartFile > (Long)this.filesRemaining.last()) {
            throw new NoUnprotectedFilesException("Protected files are not in the recovery interval and not protected by the VLSNIndex vlsnIndexStartFile=0x" + Long.toHexString(vlsnIndexStartFile) + ".", Level.WARNING);
        }
        Pair<VLSN, Long> truncateInfo = this.getVLSNIndexTruncationInfo();
        if (truncateInfo == null) {
            throw new NoUnprotectedFilesException("Cannot truncate VLSNIndex because no remaining files contain VLSNs.", Level.INFO);
        }
        if (!this.envImpl.tryTruncateVlsnHead(truncateInfo.first(), truncateInfo.second())) {
            throw new NoUnprotectedFilesException("VLSNIndex already truncated or cannot be truncated further.", Level.INFO);
        }
        file = this.getNextUnprotectedFile();
        if (file != null) {
            return file;
        }
        throw new NoUnprotectedFilesException("Protected files are not in the recovery interval and VLSNIndex was successfully truncated.", Level.WARNING);
    }

    private String getFileProtectionMessage() {
        long firstRecoveryFile = this.getFirstFileInRecoveryInterval();
        return "Files protected by the current recovery interval: [" + FormatUtil.asHexString(this.filesRemaining.tailSet(firstRecoveryFile)) + "]. Other protected files: " + this.fileProtector.getProtectedFileMap(this.filesRemaining) + ". FirstRecoveryFile: 0x" + Long.toHexString(firstRecoveryFile) + ". FirstVLSNIndexFile: 0x" + Long.toHexString(this.fileProtector.getVLSNIndexStartFile()) + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNextUnprotectedFile() {
        Object object = this.currentFileMutex;
        synchronized (object) {
            Long file = this.fileProtector.getFirstUnprotectedFile(this.filesRemaining);
            if (file == null) {
                return null;
            }
            if (file >= this.getFirstFileInRecoveryInterval()) {
                return null;
            }
            this.currentFile = file;
            this.abortCurrentFile = false;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCurrentFile() {
        Object object = this.currentFileMutex;
        synchronized (object) {
            this.currentFile = null;
            this.abortCurrentFile = false;
        }
    }

    Long getCurrentFile() {
        return this.currentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortErase(FileProtector.ProtectedFileSet fileSet) {
        Long abortFile;
        Object object = this.currentFileMutex;
        synchronized (object) {
            if (this.currentFile == null || !fileSet.isProtected(this.currentFile, null) || this.fileProtector.isReservedFile(this.currentFile)) {
                return;
            }
            this.abortCurrentFile = true;
            abortFile = this.currentFile;
        }
        if (PollCondition.await(1L, this.abortTimeoutMs, () -> {
            Object object = this.pollMutex;
            synchronized (object) {
                this.pollMutex.notify();
            }
            object = this.currentFileMutex;
            synchronized (object) {
                return !abortFile.equals(this.currentFile);
            }
        })) {
            return;
        }
        String msg = "Unable to abort erasure of file 0x" + Long.toHexString(abortFile) + " within " + this.abortTimeoutMs + "ms.";
        LoggerUtils.warning(this.logger, this.envImpl, msg);
        throw new EraserAbortException(msg);
    }

    private long getFirstFileInRecoveryInterval() {
        return DbLsn.getFileNumber(this.envImpl.getCheckpointer().getLastCheckpointFirstActiveLsn());
    }

    private Pair<VLSN, Long> getVLSNIndexTruncationInfo() {
        for (Long file : this.filesRemaining.descendingSet()) {
            this.checkContinue();
            VLSN lastVlsn = this.fileProtector.getReservedFileLastVLSN(file);
            if (lastVlsn != null) {
                if (lastVlsn.isNull()) continue;
                return new Pair<VLSN, Long>(lastVlsn, file);
            }
            lastVlsn = this.searchFileForLastVLSN(file);
            if (lastVlsn == null || lastVlsn.isNull()) continue;
            return new Pair<VLSN, Long>(lastVlsn, file);
        }
        return null;
    }

    private VLSN searchFileForLastVLSN(Long file) {
        long endOfFileLsn;
        long finishLsn;
        long startLsn;
        boolean forward;
        FileInfo fileInfo = (FileInfo)this.fileInfoCache.get(file);
        if (fileInfo != null && fileInfo.lastVlsn != null) {
            return fileInfo.lastVlsn;
        }
        long fileLength = fileInfo != null ? fileInfo.length : this.getFileLength(file);
        try {
            long prevOffset = this.fileManager.getFileHeaderPrevOffset(file + 1L);
            forward = false;
            startLsn = DbLsn.makeLsn((long)file, prevOffset);
            finishLsn = DbLsn.makeLsn((long)file, 0);
            endOfFileLsn = DbLsn.makeLsn((long)file, fileLength);
        }
        catch (FileNotFoundException e) {
            forward = true;
            startLsn = DbLsn.makeLsn((long)file, 0);
            finishLsn = -1L;
            endOfFileLsn = -1L;
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
        FileReader reader = new FileReader(this.envImpl, this.cleaner.readBufferSize, forward, startLsn, file, endOfFileLsn, finishLsn){

            @Override
            protected boolean processEntry(ByteBuffer entryBuffer) {
                int readOps = this.getAndResetNReads();
                DataEraser.this.reads.addAndGet(readOps);
                DataEraser.this.readBytes.addAndGet(readOps * ((DataEraser)DataEraser.this).cleaner.readBufferSize);
                DataEraser.this.cycleThrottle.throttle(this.currentEntryHeader.getEntrySize());
                DataEraser.this.checkContinue();
                this.skipEntry(entryBuffer);
                return this.currentEntryHeader.getReplicated();
            }
        };
        VLSN lastVlsn = VLSN.NULL_VLSN;
        try {
            while (reader.readNextEntryAllowExceptions()) {
                lastVlsn = reader.getLastVlsn();
                if (lastVlsn == null || lastVlsn.isNull()) {
                    throw EnvironmentFailureException.unexpectedState("Replicated entries must have a VLSN.");
                }
                if (forward) continue;
                break;
            }
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (fileInfo != null) {
            fileInfo.lastVlsn = lastVlsn;
        }
        return lastVlsn;
    }

    /*
     * Exception decompiling
     */
    private void eraseFile(Long file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBINDead(DatabaseImpl db, BIN binFromLog, long logLsn) {
        binFromLog.latchNoUpdateLRU(db);
        SearchResult result = db.getTree().getParentINForChildIN(binFromLog, true, true, CacheMode.UNCHANGED);
        if (result.parent == null) {
            return true;
        }
        try {
            assert (result.exactParentFound);
            long treeLsn = result.parent.getLsn(result.index);
            if (binFromLog.isBINDelta(false)) {
                boolean bl = logLsn != treeLsn;
                return bl;
            }
            if (logLsn == treeLsn) {
                boolean bl = false;
                return bl;
            }
            BIN treeBin = (BIN)result.parent.fetchIN(result.index, CacheMode.UNCHANGED);
            boolean bl = logLsn != treeBin.getLastFullLsn();
            return bl;
        }
        finally {
            result.parent.releaseLatch();
        }
    }

    private int addEraseEntry(int n, long offset, int size) {
        if (n == this.eraseOffsets.length) {
            long[] newOffsets = new long[n * 2];
            System.arraycopy(this.eraseOffsets, 0, newOffsets, 0, n);
            this.eraseOffsets = newOffsets;
            int[] newSizes = new int[newOffsets.length];
            System.arraycopy(this.eraseSizes, 0, newSizes, 0, n);
            this.eraseSizes = newSizes;
        }
        this.eraseOffsets[n] = offset;
        this.eraseSizes[n] = size;
        return n + 1;
    }

    private void touchAndFsync(RandomAccessFile file, long fileLength) throws IOException {
        this.checkContinue();
        file.seek(0L);
        byte b = file.readByte();
        file.seek(0L);
        file.writeByte(b);
        this.writes.incrementAndGet();
        this.writeBytes.incrementAndGet();
        file.getChannel().force(false);
        this.fSyncs.incrementAndGet();
        this.cycleThrottle.throttle(fileLength * 18L / 100L);
    }

    private void writeErasedType(RandomAccessFile file, long headerOffset) throws IOException {
        file.seek(headerOffset + 4L);
        this.checkContinue();
        file.writeByte(LogEntryType.LOG_ERASED.getTypeNum());
        this.writes.incrementAndGet();
        this.writeBytes.incrementAndGet();
    }

    private void eraseEntries(RandomAccessFile raf, long fileLength, int entries) throws IOException {
        if (entries == 0) {
            return;
        }
        long fsync1Work = fileLength * 18L / 100L;
        long fsync2Work = fileLength * 16L / 100L;
        long fsync3Work = fileLength * 16L / 100L;
        long writeWork = fileLength * 50L / 100L / (long)entries;
        long extraWork = fileLength - (writeWork * (long)entries + fsync1Work + fsync2Work + fsync3Work);
        this.checkContinue();
        raf.getChannel().force(false);
        this.fSyncs.incrementAndGet();
        this.cycleThrottle.throttle(fsync2Work);
        for (int i = 0; i < entries; ++i) {
            long offset = this.eraseOffsets[i];
            int size = this.eraseSizes[i];
            if (this.zeros.length < size) {
                this.zeros = new byte[size * 2];
            }
            raf.seek(offset);
            this.checkContinue();
            raf.write(this.zeros, 0, size);
            this.writes.incrementAndGet();
            this.writeBytes.addAndGet(size);
            this.cycleThrottle.throttle(writeWork);
        }
        this.checkContinue();
        raf.getChannel().force(false);
        this.fSyncs.incrementAndGet();
        this.cycleThrottle.throttle(fsync3Work + extraWork);
    }

    public boolean isEntryErased(long lsn) {
        long file = DbLsn.getFileNumber(lsn);
        long offset = DbLsn.getFileOffset(lsn);
        RandomAccessFile fileHandle = null;
        try {
            fileHandle = new RandomAccessFile(this.fileManager.getFullFileName(file), FileManager.FileMode.READ_MODE.getModeValue());
            fileHandle.seek(offset + 4L);
            boolean bl = fileHandle.readByte() == LogEntryType.LOG_ERASED.getTypeNum();
            return bl;
        }
        catch (EOFException | FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_WRITE, "Exception checking erasure file 0x" + Long.toHexString(file), e);
        }
        finally {
            if (fileHandle != null) {
                try {
                    fileHandle.close();
                }
                catch (IOException e) {
                    LoggerUtils.warning(this.logger, this.envImpl, "DataEraser.isEntryErased exception when closing file 0x" + Long.toHexString(file) + ": " + e);
                }
            }
        }
    }

    private void checkShutdown() {
        if (this.shutdownRequested || !this.envImpl.isValid()) {
            throw new ShutdownRequestedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkContinue() {
        this.checkShutdown();
        if (!this.enabled) {
            throw new ErasureDisabledException();
        }
        if (this.endTime - this.startTime != this.cycleMs) {
            throw new PeriodChangedException();
        }
        Object object = this.currentFileMutex;
        synchronized (object) {
            if (this.abortCurrentFile) {
                long file = this.currentFile;
                this.currentFile = null;
                this.abortCurrentFile = false;
                throw new AbortCurrentFileException(file);
            }
        }
    }

    private boolean checkForCycleEnd() {
        if (System.currentTimeMillis() >= this.endTime) {
            if (this.filesRemaining.isEmpty()) {
                this.logCycleComplete();
            } else {
                this.logCycleIncomplete();
            }
            return true;
        }
        return false;
    }

    private void waitForEnabled() {
        while (!PollCondition.await(this.pollCheckMs, 300000L, this.pollMutex, () -> {
            this.checkShutdown();
            return this.enabled;
        })) {
        }
    }

    private void waitForCycleEnd() {
        this.completionTime = System.currentTimeMillis();
        this.logCycleComplete();
        PollCondition.await(this.pollCheckMs, this.endTime - this.completionTime, this.pollMutex, () -> {
            this.checkContinue();
            return false;
        });
    }

    private void waitForUnprotectedFiles(NoUnprotectedFilesException e) {
        this.lastProtectedFilesMsg = e.getMessage();
        this.lastProtectedFilesMsgLevel = e.logLevel;
        PollCondition.await(this.pollCheckMs, 1000L, this.pollMutex, () -> {
            this.checkShutdown();
            return false;
        });
    }

    private void storeState() {
        TupleOutput out = new TupleOutput();
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writePackedLong(this.totalCycleWork);
        this.storeFileSet(out, this.filesCompleted);
        this.storeFileSet(out, this.filesRemaining);
        DatabaseEntry data = new DatabaseEntry();
        TupleBase.outputToEntry(out, data);
        this.envImpl.getMetadataStore().put("eraser", data);
    }

    private boolean loadState() {
        DatabaseEntry data = new DatabaseEntry();
        if (this.envImpl.getMetadataStore().get("eraser", data) == null) {
            return false;
        }
        TupleInput in = TupleBase.entryToInput(data);
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.totalCycleWork = in.readPackedLong();
        this.filesCompleted = this.loadFileSet(in);
        this.filesRemaining = this.loadFileSet(in);
        return true;
    }

    private void storeFileSet(TupleOutput out, NavigableSet<Long> set) {
        out.writePackedInt(set.size());
        long priorFile = 0L;
        for (long file : set) {
            out.writePackedLong(file - priorFile);
            priorFile = file;
        }
    }

    private NavigableSet<Long> loadFileSet(TupleInput in) {
        int size = in.readPackedInt();
        NavigableSet<Long> set = Collections.synchronizedNavigableSet(new TreeSet());
        long file = 0L;
        for (int i = 0; i < size; ++i) {
            set.add(file += in.readPackedLong());
        }
        return set;
    }

    private void logCycleInit(int filesToExamine) {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER initializing new cycle. Total files: " + filesToExamine);
        this.callTestEventHook(TestEvent.Type.INIT);
    }

    private void logCycleStart() {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER new cycle started. " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.START);
    }

    private void logCycleComplete() {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER cycle completed. " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.COMPLETE);
    }

    private void logCycleIncomplete() {
        String msg = "ERASER unable to erase files within the erasure period. " + (this.lastProtectedFilesMsg != null ? this.lastProtectedFilesMsg : "File protection did not prevent erasure, so probably just ran out of time.") + " " + this.getFileProtectionMessage() + " " + this.getCycleStatus();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.lastProtectedFilesMsgLevel != null ? this.lastProtectedFilesMsgLevel : Level.INFO, msg);
        this.callTestEventHook(TestEvent.Type.INCOMPLETE);
    }

    private void logCycleResume() {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER previously incomplete cycle resumed at startup. " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.RESUME);
    }

    private void logCycleCannotResume() {
        LoggerUtils.warning(this.logger, this.envImpl, "ERASER previously incomplete cycle not resumed at startup because end time has passed. " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.CANNOT_RESUME);
    }

    private void logCycleSuspend() {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER incomplete cycle suspended at shutdown. " + this.getFileProtectionMessage() + " " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.SUSPEND);
    }

    private void logPeriodChanged() {
        LoggerUtils.info(this.logger, this.envImpl, "ERASER period param was changed, current cycle aborted. " + this.getCycleStatus());
        this.callTestEventHook(TestEvent.Type.PERIOD_CHANGED);
    }

    private String getCycleStatus() {
        return "Cycle start: " + DataEraser.formatTime(this.startTime) + ", end: " + DataEraser.formatTime(this.endTime) + ", filesCompleted: [" + FormatUtil.asHexString(this.filesCompleted) + "], filesRemaining: [" + FormatUtil.asHexString(this.filesRemaining) + "].";
    }

    private static String formatTime(long time) {
        return DATE_FORMAT.format(new Date(time));
    }

    private void callTestEventHook(TestEvent.Type type) {
        if (testEventHook == null) {
            return;
        }
        testEventHook.doHook(new TestEvent(type, this));
    }

    static void setTestEventHook(TestHook<TestEvent> hook) {
        testEventHook = hook;
    }

    static {
        DATE_FORMAT = TracerFormatter.makeDateFormat();
    }

    static class TestEvent {
        final Type type;
        final long startTime;
        final long endTime;
        final long completionTime;
        final NavigableSet<Long> filesCompleted;
        final NavigableSet<Long> filesRemaining;

        TestEvent(Type type, DataEraser eraser) {
            this.type = type;
            this.startTime = eraser.startTime;
            this.endTime = eraser.endTime;
            this.completionTime = eraser.completionTime;
            this.filesCompleted = new TreeSet<Long>(eraser.filesCompleted);
            this.filesRemaining = new TreeSet<Long>(eraser.filesRemaining);
        }

        public String toString() {
            return this.type.toString() + " startTime=" + DataEraser.formatTime(this.startTime) + " endTime=" + DataEraser.formatTime(this.endTime) + " completionTime=" + DataEraser.formatTime(this.completionTime) + " filesCompleted=[" + FormatUtil.asHexString(this.filesCompleted) + "] filesRemaining=[" + FormatUtil.asHexString(this.filesRemaining) + "]";
        }

        static enum Type {
            INIT,
            START,
            COMPLETE,
            INCOMPLETE,
            RESUME,
            CANNOT_RESUME,
            SUSPEND,
            PERIOD_CHANGED;

        }
    }

    private static class FileInfo {
        final long creationTime;
        final long length;
        VLSN lastVlsn;

        FileInfo(long creationTime, long length) {
            this.creationTime = creationTime;
            this.length = length;
        }
    }

    private static class AbortCurrentFileException
    extends RuntimeException {
        final long file;

        AbortCurrentFileException(long file) {
            this.file = file;
        }
    }

    private static class ShutdownRequestedException
    extends RuntimeException {
        private ShutdownRequestedException() {
        }
    }

    private static class PeriodChangedException
    extends RuntimeException {
        private PeriodChangedException() {
        }
    }

    private static class ErasureDisabledException
    extends RuntimeException {
        private ErasureDisabledException() {
        }
    }

    private static class NoUnprotectedFilesException
    extends RuntimeException {
        final Level logLevel;

        NoUnprotectedFilesException(String msg, Level logLevel) {
            super(msg);
            this.logLevel = logLevel;
        }
    }

    private class WorkThrottle {
        private final float msPerUnitOfWork;
        private final long startTime;
        private long workDone;

        WorkThrottle(long totalWork, long durationMs) {
            this.msPerUnitOfWork = (float)durationMs / (float)totalWork;
            this.startTime = System.currentTimeMillis();
            this.workDone = 0L;
        }

        void throttle(long addWork) {
            this.workDone += addWork;
            long workDoneMs = (long)((float)this.workDone * this.msPerUnitOfWork);
            long delayMs = workDoneMs - (System.currentTimeMillis() - this.startTime);
            if (delayMs >= 5L) {
                long checkMs = Math.min(delayMs, (long)DataEraser.this.pollCheckMs);
                PollCondition.await(checkMs, delayMs, DataEraser.this.pollMutex, () -> {
                    DataEraser.this.checkContinue();
                    return false;
                });
            }
        }
    }

    private class EraserReader
    extends FileReader {
        LogEntryHeader header;
        LogEntryType entryType;
        LogEntry logEntry;
        boolean isLN;
        boolean isBIN;
        boolean isErased;

        EraserReader(Long file) {
            super(DataEraser.this.envImpl, ((DataEraser)DataEraser.this).cleaner.readBufferSize, true, DbLsn.makeLsn((long)file, 0), file, -1L, -1L);
        }

        @Override
        protected boolean processEntry(ByteBuffer entryBuffer) {
            int readOps = this.getAndResetNReads();
            DataEraser.this.reads.addAndGet(readOps);
            DataEraser.this.readBytes.addAndGet(readOps * ((DataEraser)DataEraser.this).cleaner.readBufferSize);
            DataEraser.this.cycleThrottle.throttle(this.currentEntryHeader.getEntrySize());
            DataEraser.this.checkContinue();
            this.header = this.currentEntryHeader;
            this.isLN = false;
            this.isBIN = false;
            this.isErased = false;
            this.logEntry = null;
            this.entryType = LogEntryType.findType(this.header.getType());
            assert (this.entryType != null);
            if (this.entryType.isUserLNType()) {
                this.isLN = true;
            } else if (this.entryType.equals(LogEntryType.LOG_BIN) || this.entryType.equals(LogEntryType.LOG_BIN_DELTA)) {
                this.isBIN = true;
            } else if (this.entryType.equals(LogEntryType.LOG_ERASED)) {
                this.isErased = true;
            } else {
                this.skipEntry(entryBuffer);
                return false;
            }
            this.logEntry = this.entryType.getNewLogEntry();
            this.logEntry.readEntry(this.envImpl, this.header, entryBuffer);
            return true;
        }
    }
}

