/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.utilint.PropUtil;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class VerifyConfig
implements Cloneable {
    public static final VerifyConfig DEFAULT = new VerifyConfig();
    private boolean propagateExceptions = false;
    private boolean aggressive = false;
    private boolean printInfo = false;
    private PrintStream showProgressStream = null;
    private int showProgressInterval = 0;
    private boolean verifySecondaries = true;
    private boolean verifyDataRecords = false;
    private boolean verifyObsoleteRecords = false;
    private boolean repairReservedFiles = false;
    private int batchSize = 1000;
    private int batchDelayMs = 10;

    public VerifyConfig setRepairReservedFiles(boolean repair) {
        this.setRepairReservedFilesVoid(repair);
        return this;
    }

    public void setRepairReservedFilesVoid(boolean repair) {
        this.repairReservedFiles = repair;
    }

    public boolean getRepairReservedFiles() {
        return this.repairReservedFiles;
    }

    public VerifyConfig setPropagateExceptions(boolean propagate) {
        this.setPropagateExceptionsVoid(propagate);
        return this;
    }

    public void setPropagateExceptionsVoid(boolean propagate) {
        this.propagateExceptions = propagate;
    }

    public boolean getPropagateExceptions() {
        return this.propagateExceptions;
    }

    public VerifyConfig setAggressive(boolean aggressive) {
        this.setAggressiveVoid(aggressive);
        return this;
    }

    public void setAggressiveVoid(boolean aggressive) {
        this.aggressive = aggressive;
    }

    public boolean getAggressive() {
        return this.aggressive;
    }

    public VerifyConfig setPrintInfo(boolean printInfo) {
        this.setPrintInfoVoid(printInfo);
        return this;
    }

    public void setPrintInfoVoid(boolean printInfo) {
        this.printInfo = printInfo;
    }

    public boolean getPrintInfo() {
        return this.printInfo;
    }

    public VerifyConfig setShowProgressStream(PrintStream showProgressStream) {
        this.setShowProgressStreamVoid(showProgressStream);
        return this;
    }

    public void setShowProgressStreamVoid(PrintStream showProgressStream) {
        this.showProgressStream = showProgressStream;
    }

    public PrintStream getShowProgressStream() {
        return this.showProgressStream;
    }

    public VerifyConfig setShowProgressInterval(int showProgressInterval) {
        this.setShowProgressIntervalVoid(showProgressInterval);
        return this;
    }

    public void setShowProgressIntervalVoid(int showProgressInterval) {
        this.showProgressInterval = showProgressInterval;
    }

    public int getShowProgressInterval() {
        return this.showProgressInterval;
    }

    public VerifyConfig setVerifySecondaries(boolean verifySecondaries) {
        this.setVerifySecondariesVoid(verifySecondaries);
        return this;
    }

    public void setVerifySecondariesVoid(boolean verifySecondaries) {
        this.verifySecondaries = verifySecondaries;
    }

    public boolean getVerifySecondaries() {
        return this.verifySecondaries;
    }

    public VerifyConfig setVerifyDataRecords(boolean verifyDataRecords) {
        this.setVerifyDataRecordsVoid(verifyDataRecords);
        return this;
    }

    public void setVerifyDataRecordsVoid(boolean verifyDataRecords) {
        this.verifyDataRecords = verifyDataRecords;
    }

    public boolean getVerifyDataRecords() {
        return this.verifyDataRecords;
    }

    public VerifyConfig setVerifyObsoleteRecords(boolean verifyObsoleteRecords) {
        this.setVerifyObsoleteRecordsVoid(verifyObsoleteRecords);
        return this;
    }

    public void setVerifyObsoleteRecordsVoid(boolean verifyObsoleteRecords) {
        this.verifyObsoleteRecords = verifyObsoleteRecords;
    }

    public boolean getVerifyObsoleteRecords() {
        return this.verifyObsoleteRecords;
    }

    public VerifyConfig setBatchSize(int batchSize) {
        this.setBatchSizeVoid(batchSize);
        return this;
    }

    public void setBatchSizeVoid(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public VerifyConfig setBatchDelay(long delay, TimeUnit unit) {
        this.setBatchDelayVoid(delay, unit);
        return this;
    }

    public void setBatchDelayVoid(long delayDuration, TimeUnit unit) {
        this.batchDelayMs = PropUtil.durationToMillis(delayDuration, unit);
    }

    public long getBatchDelay(TimeUnit unit) {
        return PropUtil.millisToDuration(this.batchDelayMs, unit);
    }

    public VerifyConfig clone() {
        try {
            return (VerifyConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("propagateExceptions=").append(this.propagateExceptions);
        return sb.toString();
    }
}

