/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskOrderedCursor;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.ScanFilter;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.cleaner.ExtinctionScanner;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.txn.HandleLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Environment
implements Closeable {
    private volatile EnvironmentImpl environmentImpl;
    private AtomicReference<EnvironmentFailureException> invalidatingEFE;
    private TransactionConfig defaultTxnConfig;
    private EnvironmentMutableConfig handleConfig;
    private final EnvironmentConfig appliedFinalConfig;
    private final Map<Database, Database> referringDbs = new ConcurrentHashMap<Database, Database>();
    private final Map<Transaction, Transaction> referringDbTxns = new ConcurrentHashMap<Transaction, Transaction>();
    public static final String CLEANER_NAME = "Cleaner";
    public static final String INCOMP_NAME = "INCompressor";
    public static final String CHECKPOINTER_NAME = "Checkpointer";
    public static final String STATCAPTURE_NAME = "StatCapture";
    public static final String LOG_FLUSHER_NAME = "LogFlusher";
    public static final String FILE_DELETION_DETECTOR_NAME = "FileDeletionDetector";
    public static final String DATA_CORRUPTION_VERIFIER_NAME = "DataCorruptionVerifier";

    public Environment(File envHome, EnvironmentConfig configuration) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
        this(envHome, configuration, null, null);
    }

    protected Environment(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfigProxy, EnvironmentImpl envImpl) {
        DatabaseUtil.checkForNullParam(envHome, "envHome");
        this.appliedFinalConfig = this.setupHandleConfig(envHome, envConfig, repConfigProxy);
        if (envImpl != null) {
            this.environmentImpl = envImpl;
        } else {
            this.environmentImpl = this.makeEnvironmentImpl(envHome, envConfig, repConfigProxy);
            if (!this.environmentImpl.isReplicated()) {
                this.environmentImpl.fullyInitialized();
            }
        }
    }

    protected EnvironmentImpl makeEnvironmentImpl(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        this.environmentImpl = DbEnvPool.getInstance().getEnvironment(envHome, this.appliedFinalConfig, envConfig != null, this.setupRepConfig(envHome, repConfigProxy, envConfig));
        this.environmentImpl.registerMBean(this);
        this.invalidatingEFE = this.environmentImpl.getInvalidatingExceptionReference();
        return this.environmentImpl;
    }

    private EnvironmentConfig setupHandleConfig(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfig) throws IllegalArgumentException {
        EnvironmentConfig baseConfig = envConfig == null ? EnvironmentConfig.DEFAULT : envConfig;
        EnvironmentConfig useConfig = baseConfig.clone();
        if (useConfig.getLoadPropertyFile()) {
            DbConfigManager.applyFileConfig(envHome, DbInternal.getProps(useConfig), false);
        }
        this.copyToHandleConfig(useConfig, useConfig, repConfig);
        return useConfig;
    }

    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws DatabaseException {
        if (this.environmentImpl == null) {
            return;
        }
        if (!this.environmentImpl.isValid()) {
            try {
                this.environmentImpl.closeAfterInvalid();
            }
            finally {
                this.clearEnvImpl();
                for (Database db : this.referringDbs.keySet()) {
                    db.minimalClose(Database.DbState.CLOSED, null);
                }
            }
            return;
        }
        StringBuilder errors = new StringBuilder();
        try {
            this.checkForCloseErrors(errors);
            try {
                this.environmentImpl.close();
            }
            catch (DatabaseException e) {
                e.addErrorMessage(errors.toString());
                throw e;
            }
            catch (RuntimeException e) {
                if (errors.length() > 0) {
                    throw new IllegalStateException(errors.toString(), e);
                }
                throw e;
            }
            if (errors.length() > 0) {
                throw new IllegalStateException(errors.toString());
            }
        }
        finally {
            this.clearEnvImpl();
        }
    }

    void clearEnvImpl() {
        this.environmentImpl = null;
    }

    synchronized void closeInternalHandle() {
        StringBuilder errors = new StringBuilder();
        this.checkForCloseErrors(errors);
        if (errors.length() > 0) {
            throw new IllegalStateException(errors.toString());
        }
    }

    private void checkForCloseErrors(StringBuilder errors) {
        this.checkOpenDbs(errors);
        this.checkOpenTxns(errors);
        if (!this.isInternalHandle()) {
            this.checkOpenXATransactions(errors);
        }
    }

    private void checkOpenXATransactions(StringBuilder errors) {
        Xid[] openXids = this.getNonNullEnvImpl().getTxnManager().XARecover();
        if (openXids != null && openXids.length > 0) {
            errors.append("There ");
            int nXATxns = openXids.length;
            if (nXATxns == 1) {
                errors.append("is 1 existing XA transaction opened");
                errors.append(" in the Environment.\n");
                errors.append("It");
            } else {
                errors.append("are ");
                errors.append(nXATxns);
                errors.append(" existing transactions opened in");
                errors.append(" the Environment.\n");
                errors.append("They");
            }
            errors.append(" will be left open ...\n");
        }
    }

    private void checkOpenTxns(StringBuilder errors) {
        int nTxns;
        int n = nTxns = this.referringDbTxns == null ? 0 : this.referringDbTxns.size();
        if (nTxns == 0) {
            return;
        }
        errors.append("There ");
        if (nTxns == 1) {
            errors.append("is 1 existing transaction opened");
            errors.append(" against the Environment.\n");
        } else {
            errors.append("are ");
            errors.append(nTxns);
            errors.append(" existing transactions opened against");
            errors.append(" the Environment.\n");
        }
        errors.append("Aborting open transactions ...\n");
        for (Transaction txn : this.referringDbTxns.keySet()) {
            try {
                errors.append("aborting " + txn);
                txn.abort();
            }
            catch (RuntimeException e) {
                if (!this.environmentImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile aborting transaction ");
                errors.append(txn.getId());
                errors.append(" encountered exception: ");
                errors.append(e).append("\n");
            }
        }
    }

    private void checkOpenDbs(StringBuilder errors) {
        if (this.referringDbs.isEmpty()) {
            return;
        }
        int nOpenUserDbs = 0;
        for (Database db : this.referringDbs.keySet()) {
            String dbName = "";
            try {
                dbName = db.getDatabaseName();
                if (!db.getDbImpl().isInternalDb()) {
                    ++nOpenUserDbs;
                    errors.append("Unclosed Database: ");
                    errors.append(dbName).append("\n");
                }
                db.close();
            }
            catch (RuntimeException e) {
                if (!this.environmentImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Database ");
                errors.append(dbName);
                errors.append(" encountered exception: ");
                errors.append(LoggerUtils.getStackTrace(e)).append("\n");
            }
        }
        if (nOpenUserDbs > 0) {
            errors.append("Databases left open: ");
            errors.append(nOpenUserDbs).append("\n");
        }
    }

    public synchronized Database openDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, IllegalArgumentException, IllegalStateException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (dbConfig == null) {
            dbConfig = DatabaseConfig.DEFAULT;
        }
        try {
            Database db = new Database(this);
            this.setupDatabase(envImpl, txn, db, databaseName, dbConfig, false);
            return db;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public synchronized SecondaryDatabase openSecondaryDatabase(Transaction txn, String databaseName, Database primaryDatabase, SecondaryConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, DatabaseException, IllegalArgumentException, IllegalStateException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.getSecondaryAssociationLock().writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException(envImpl, (Throwable)e);
        }
        try {
            if (dbConfig == null) {
                dbConfig = SecondaryConfig.DEFAULT;
            }
            SecondaryDatabase db = new SecondaryDatabase(this, dbConfig, primaryDatabase);
            this.setupDatabase(envImpl, txn, db, databaseName, dbConfig, false);
            SecondaryDatabase secondaryDatabase = db;
            return secondaryDatabase;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
        finally {
            envImpl.getSecondaryAssociationLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDatabase(EnvironmentImpl envImpl, Transaction txn, Database newDb, String databaseName, DatabaseConfig dbConfig, boolean isInternalDb) throws DatabaseNotFoundException, DatabaseExistsException {
        Locker locker;
        boolean operationOk;
        block10: {
            block11: {
                DatabaseUtil.checkForNullParam(databaseName, "databaseName");
                LoggerUtils.envLogMsg(Level.FINEST, envImpl, "Environment.open:  name=" + databaseName + " dbConfig=" + dbConfig);
                boolean autoTxnIsReplicated = dbConfig.getReplicated() && envImpl.isReplicated();
                dbConfig.validateOnDbOpen(databaseName, autoTxnIsReplicated);
                this.validateDbConfigAgainstEnv(envImpl, dbConfig, databaseName, isInternalDb);
                envImpl.criticalEviction(false);
                DatabaseImpl database = null;
                operationOk = false;
                HandleLocker handleLocker = null;
                locker = LockerFactory.getWritableLocker(this, txn, isInternalDb, dbConfig.getTransactional(), autoTxnIsReplicated, null);
                try {
                    boolean firstWriteHandle;
                    boolean databaseExists;
                    handleLocker = newDb.initHandleLocker(envImpl, locker);
                    database = envImpl.getDbTree().getDb(locker, databaseName, handleLocker, false);
                    boolean dbCreated = false;
                    boolean bl = databaseExists = database != null && !database.isDeleting();
                    if (databaseExists) {
                        if (dbConfig.getAllowCreate() && dbConfig.getExclusiveCreate()) {
                            throw new DatabaseExistsException("Database " + databaseName + " already exists");
                        }
                        newDb.initExisting(this, locker, database, databaseName, dbConfig);
                    } else {
                        envImpl.getDbTree().releaseDb(database);
                        database = null;
                        if (!isInternalDb && DbTree.isReservedDbName(databaseName)) {
                            throw new IllegalArgumentException(databaseName + " is a reserved database name.");
                        }
                        if (!dbConfig.getAllowCreate()) {
                            throw new DatabaseNotFoundException("Database " + databaseName + " not found.");
                        }
                        database = newDb.initNew(this, locker, databaseName, dbConfig);
                        dbCreated = true;
                    }
                    operationOk = true;
                    this.addReferringHandle(newDb);
                    locker.addOpenedDatabase(newDb);
                    boolean bl2 = firstWriteHandle = newDb.isWritable() && newDb.getDbImpl().noteWriteHandleOpen() == 1;
                    if (dbCreated || firstWriteHandle) {
                        TriggerManager.runOpenTriggers(locker, newDb, dbCreated);
                    }
                    if (operationOk) break block10;
                    envImpl.getDbTree().releaseDb(database);
                    if (handleLocker == null) break block11;
                }
                catch (Throwable throwable) {
                    if (!operationOk) {
                        envImpl.getDbTree().releaseDb(database);
                        if (handleLocker != null) {
                            handleLocker.operationEnd(false);
                        }
                        newDb.removeReferringAssociations();
                    }
                    locker.operationEnd(operationOk);
                    throw throwable;
                }
                handleLocker.operationEnd(false);
            }
            newDb.removeReferringAssociations();
        }
        locker.operationEnd(operationOk);
    }

    private void validateDbConfigAgainstEnv(EnvironmentImpl envImpl, DatabaseConfig dbConfig, String databaseName, boolean isInternalDb) throws IllegalArgumentException {
        if (envImpl.isReplicated() && dbConfig.getReplicated() && !dbConfig.getReadOnly() && !dbConfig.getTransactional()) {
            throw new IllegalArgumentException("Read/Write Database instances for replicated database " + databaseName + " must be transactional.");
        }
        if (!isInternalDb && dbConfig.getTransactional() && !envImpl.isTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " transactionally, but parent Environment is not transactional");
        }
        if (envImpl.isReadOnly() && !dbConfig.getReadOnly()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " as writable but parent Environment is read only ");
        }
    }

    public void removeDatabase(Transaction txn, final String databaseName) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        new DbNameOperation<Void>(txn){

            @Override
            Pair<DatabaseImpl, Void> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DatabaseImpl dbImpl = this.dbTree.dbRemove(locker, databaseName, null);
                return new Pair<DatabaseImpl, Object>(dbImpl, null);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runRemoveTriggers(locker, dbImpl);
            }
        }.run();
    }

    public void renameDatabase(Transaction txn, final String databaseName, final String newName) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        DatabaseUtil.checkForNullParam(newName, "newName");
        new DbNameOperation<Void>(txn){

            @Override
            Pair<DatabaseImpl, Void> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DatabaseImpl dbImpl = this.dbTree.dbRename(locker, databaseName, newName);
                return new Pair<DatabaseImpl, Object>(dbImpl, null);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runRenameTriggers(locker, dbImpl, newName);
            }
        }.run();
    }

    public long truncateDatabase(Transaction txn, final String databaseName, final boolean returnCount) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        return (Long)new DbNameOperation<Long>(txn){

            @Override
            Pair<DatabaseImpl, Long> runWork(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
                DbTree.TruncateDbResult result = this.dbTree.truncate(locker, databaseName, returnCount);
                return new Pair<DatabaseImpl, Long>(result.newDb, result.recordCount);
            }

            @Override
            void runTriggers(Locker locker, DatabaseImpl dbImpl) {
                TriggerManager.runTruncateTriggers(locker, dbImpl);
            }
        }.run();
    }

    long getMemoryUsage() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        return envImpl.getMemoryBudget().getCacheMemoryUsage();
    }

    public File getHome() throws DatabaseException {
        EnvironmentImpl envImpl = this.getNonNullEnvImpl();
        return envImpl.getEnvironmentHome();
    }

    TransactionConfig getDefaultTxnConfig() {
        return this.defaultTxnConfig;
    }

    private void copyToHandleConfig(EnvironmentMutableConfig useConfig, EnvironmentConfig initStaticConfig, RepConfigProxy initRepConfig) {
        EnvironmentMutableConfig newHandleConfig = new EnvironmentMutableConfig();
        useConfig.copyHandlePropsTo(newHandleConfig);
        this.handleConfig = newHandleConfig;
        TransactionConfig newTxnConfig = TransactionConfig.DEFAULT.clone();
        newTxnConfig.setNoSync(this.handleConfig.getTxnNoSync());
        newTxnConfig.setWriteNoSync(this.handleConfig.getTxnWriteNoSync());
        newTxnConfig.setDurability(this.handleConfig.getDurability());
        if (initStaticConfig != null) {
            newTxnConfig.setSerializableIsolation(initStaticConfig.getTxnSerializableIsolation());
            newTxnConfig.setReadCommitted(initStaticConfig.getTxnReadCommitted());
        } else {
            newTxnConfig.setSerializableIsolation(this.defaultTxnConfig.getSerializableIsolation());
            newTxnConfig.setReadCommitted(this.defaultTxnConfig.getReadCommitted());
            newTxnConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
        }
        if (initRepConfig != null) {
            newTxnConfig.setConsistencyPolicy(initRepConfig.getConsistencyPolicy());
        }
        this.defaultTxnConfig = newTxnConfig;
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig txnConfig) throws DatabaseException, IllegalArgumentException {
        try {
            return this.beginTransactionInternal(parent, txnConfig, false);
        }
        catch (Error E) {
            this.invalidate(E);
            throw E;
        }
    }

    Transaction beginInternalTransaction(TransactionConfig txnConfig) {
        return this.beginTransactionInternal(null, txnConfig, true);
    }

    private Transaction beginTransactionInternal(Transaction parent, TransactionConfig txnConfig, boolean isInternalTxn) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (parent != null) {
            throw new IllegalArgumentException("Parent txn is non-null. Nested transactions are not supported.");
        }
        if (!isInternalTxn && !envImpl.isTransactional()) {
            throw new UnsupportedOperationException("Transactions can not be used in a non-transactional environment");
        }
        this.checkTxnConfig(txnConfig);
        TransactionConfig useConfig = null;
        if (txnConfig == null) {
            useConfig = this.defaultTxnConfig;
        } else {
            if (!(!this.defaultTxnConfig.getNoSync() && !this.defaultTxnConfig.getWriteNoSync() || txnConfig.getNoSync() || txnConfig.getSync() || txnConfig.getWriteNoSync())) {
                useConfig = txnConfig.clone();
                if (this.defaultTxnConfig.getWriteNoSync()) {
                    useConfig.setWriteNoSync(true);
                } else {
                    useConfig.setNoSync(true);
                }
            }
            if (this.defaultTxnConfig.getDurability() != null && txnConfig.getDurability() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setDurability(this.defaultTxnConfig.getDurability());
            }
            if (this.defaultTxnConfig.getConsistencyPolicy() != null && txnConfig.getConsistencyPolicy() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
            }
            if (!(txnConfig.getSerializableIsolation() || txnConfig.getReadCommitted() || txnConfig.getReadUncommitted())) {
                if (this.defaultTxnConfig.getSerializableIsolation()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setSerializableIsolation(true);
                } else if (this.defaultTxnConfig.getReadCommitted()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setReadCommitted(true);
                }
            }
            if (useConfig == null) {
                useConfig = txnConfig;
            }
        }
        Txn internalTxn = envImpl.txnBegin(parent, useConfig);
        Transaction txn = new Transaction(this, internalTxn);
        this.addReferringHandle(txn);
        return txn;
    }

    private void checkTxnConfig(TransactionConfig txnConfig) throws IllegalArgumentException {
        if (txnConfig == null) {
            return;
        }
        if (txnConfig.getSerializableIsolation() && txnConfig.getReadUncommitted() || txnConfig.getSerializableIsolation() && txnConfig.getReadCommitted() || txnConfig.getReadUncommitted() && txnConfig.getReadCommitted()) {
            throw new IllegalArgumentException("Only one may be specified: SerializableIsolation, ReadCommitted or ReadUncommitted");
        }
        if (txnConfig.getDurability() != null && (this.defaultTxnConfig.getSync() || this.defaultTxnConfig.getNoSync() || this.defaultTxnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of deprecated durability API for the Environment with the new durability API for TransactionConfig.setDurability()");
        }
        if (this.defaultTxnConfig.getDurability() != null && (txnConfig.getSync() || txnConfig.getNoSync() || txnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of new durability API for the Environment with the deprecated durability API for TransactionConfig.");
        }
    }

    public void checkpoint(CheckpointConfig ckptConfig) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (ckptConfig == null) {
            ckptConfig = CheckpointConfig.DEFAULT;
        }
        try {
            envImpl.invokeCheckpoint(ckptConfig, "api");
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public void sync() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            CheckpointConfig config = new CheckpointConfig();
            config.setForce(true);
            config.setMinimizeRecoveryTime(true);
            envImpl.invokeCheckpoint(config, "sync");
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public void flushLog(boolean fsync) {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.flushLog(fsync);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public int cleanLog() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            return envImpl.invokeCleaner(true);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean cleanLogFile() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            return envImpl.invokeCleaner(false) > 0;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public void evictMemory() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.invokeEvictor();
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public void compress() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.invokeCompressor();
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public PreloadStats preload(Database[] databases, PreloadConfig config) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        DatabaseUtil.checkForZeroLengthArrayParam(databases, "databases");
        if (config == null) {
            config = new PreloadConfig();
        }
        try {
            int nDbs = databases.length;
            DatabaseImpl[] dbImpls = new DatabaseImpl[nDbs];
            for (int i = 0; i < nDbs; ++i) {
                dbImpls[i] = DbInternal.getDbImpl(databases[i]);
            }
            return envImpl.preload(dbImpls, config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public DiskOrderedCursor openDiskOrderedCursor(Database[] databases, DiskOrderedCursorConfig config) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        DatabaseUtil.checkForZeroLengthArrayParam(databases, "databases");
        if (config == null) {
            config = DiskOrderedCursorConfig.DEFAULT;
        }
        try {
            int nDbs = databases.length;
            for (int i = 0; i < nDbs; ++i) {
                if (databases[i] == null) {
                    throw new IllegalArgumentException("The handle at position " + i + " of the databases array is null.");
                }
                if (databases[i].getEnvironment() == this) continue;
                throw new IllegalArgumentException("The handle at position " + i + " of the databases array points to a database that does not belong to this environment");
            }
            return new DiskOrderedCursor(databases, config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean isRecordExtinctionAvailable() {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.checkRecordExtinctionAvailable();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public long discardExtinctRecords(@Nullable Transaction txn, @NonNull Set<String> dbNames, @Nullable DatabaseEntry inclusiveBeginKey, @Nullable DatabaseEntry exclusiveEndKey, @Nullable ScanFilter scanFilter, @Nullable String label) {
        EnvironmentImpl envImpl = this.checkOpen();
        this.checkWritable(envImpl);
        envImpl.checkRecordExtinctionAvailable();
        if (!envImpl.hasExtinctionFilter()) {
            throw new IllegalStateException("An ExtinctionFilter is not configured");
        }
        ExtinctionScanner scanner = envImpl.getExtinctionScanner();
        if (!scanner.isEnabled()) {
            throw new IllegalStateException("je.env.runExtinctRecordScanner is false");
        }
        Locker locker = LockerFactory.getWritableLocker(this, txn, true, envImpl.isTransactional(), envImpl.isReplicated());
        boolean success = false;
        try {
            long id = scanner.discardExtinctRecords(locker, dbNames, inclusiveBeginKey, exclusiveEndKey, scanFilter, label != null ? label : "");
            success = true;
            long l = id;
            return l;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
        finally {
            locker.operationEnd(success);
        }
    }

    public boolean isRecordExtinctionActive(long id) {
        return this.checkOpen().getExtinctionScanner().isScanTaskActive(id);
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        EnvironmentImpl envImpl = this.getNonNullEnvImpl();
        try {
            EnvironmentConfig config = envImpl.cloneConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(envImpl);
            return config;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
        try {
            envImpl.setMutableConfig(mutableConfig);
            this.copyToHandleConfig(mutableConfig, null, null);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public EnvironmentMutableConfig getMutableConfig() throws DatabaseException {
        EnvironmentImpl envImpl = this.getNonNullEnvImpl();
        try {
            EnvironmentMutableConfig config = envImpl.cloneMutableConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(envImpl);
            return config;
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public EnvironmentStats getStats(StatsConfig config) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (config == null) {
            config = StatsConfig.DEFAULT;
        }
        try {
            return envImpl.loadStats(config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (config == null) {
            config = StatsConfig.DEFAULT;
        }
        try {
            return envImpl.lockStat(config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (config == null) {
            config = StatsConfig.DEFAULT;
        }
        try {
            return envImpl.txnStat(config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            return envImpl.getDbTree().getDbNames();
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        if (config == null) {
            config = VerifyConfig.DEFAULT;
        }
        try {
            envImpl.verify(config);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
        return true;
    }

    public Transaction getThreadTransaction() throws DatabaseException {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            return envImpl.getTxnManager().getTxnForThread();
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public void setThreadTransaction(Transaction txn) {
        EnvironmentImpl envImpl = this.checkOpen();
        try {
            envImpl.getTxnManager().setTxnForThread(txn);
        }
        catch (Error E) {
            envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean isValid() {
        EnvironmentImpl envImpl = this.environmentImpl;
        return envImpl != null && envImpl.isValid();
    }

    public boolean isClosed() {
        EnvironmentImpl envImpl = this.environmentImpl;
        return envImpl == null || envImpl.isClosed();
    }

    public EnvironmentFailureException getInvalidatingException() {
        assert (this.invalidatingEFE != null);
        return this.invalidatingEFE.get();
    }

    public void printStartupInfo(PrintStream out) {
        EnvironmentImpl envImpl = this.getNonNullEnvImpl();
        envImpl.getStartupTracker().displayStats(out, StartupTracker.Phase.TOTAL_ENV_OPEN);
    }

    private void addReferringHandle(Database db) {
        this.referringDbs.put(db, db);
    }

    private void addReferringHandle(Transaction txn) {
        this.referringDbTxns.put(txn, txn);
    }

    void removeReferringHandle(Database db) {
        this.referringDbs.remove(db);
    }

    void removeReferringHandle(Transaction txn) {
        this.referringDbTxns.remove(txn);
    }

    EnvironmentImpl checkOpen() {
        EnvironmentImpl envImpl = this.getNonNullEnvImpl();
        envImpl.checkOpen();
        return envImpl;
    }

    EnvironmentImpl getNonNullEnvImpl() {
        EnvironmentImpl envImpl = this.environmentImpl;
        if (envImpl == null) {
            throw new IllegalStateException("Environment is closed.");
        }
        return envImpl;
    }

    EnvironmentImpl getMaybeNullEnvImpl() {
        return this.environmentImpl;
    }

    protected boolean isInternalHandle() {
        return false;
    }

    private void checkWritable(EnvironmentImpl envImpl) {
        if (envImpl.isReadOnly()) {
            throw new UnsupportedOperationException("Environment is Read-Only.");
        }
    }

    void invalidate(Error e) {
        EnvironmentImpl envImpl = this.environmentImpl;
        if (envImpl == null) {
            return;
        }
        envImpl.invalidate(e);
    }

    private abstract class DbNameOperation<R> {
        private final EnvironmentImpl envImpl;
        private final Transaction txn;
        final DbTree dbTree;

        DbNameOperation(Transaction txn) {
            this.txn = txn;
            this.envImpl = Environment.this.checkOpen();
            Environment.this.checkWritable(this.envImpl);
            this.dbTree = this.envImpl.getDbTree();
        }

        abstract Pair<DatabaseImpl, R> runWork(Locker var1) throws DatabaseNotFoundException, DbTree.NeedRepLockerException;

        abstract void runTriggers(Locker var1, DatabaseImpl var2);

        R run() throws DatabaseNotFoundException {
            try {
                return this.runOnce(this.getWritableLocker(false));
            }
            catch (DbTree.NeedRepLockerException e) {
                try {
                    return this.runOnce(this.getWritableLocker(true));
                }
                catch (DbTree.NeedRepLockerException e2) {
                    throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
                }
            }
        }

        private R runOnce(Locker locker) throws DatabaseNotFoundException, DbTree.NeedRepLockerException {
            boolean success = false;
            try {
                Pair<DatabaseImpl, R> results = this.runWork(locker);
                DatabaseImpl dbImpl = results.first();
                if (dbImpl == null) {
                    throw EnvironmentFailureException.unexpectedState(this.envImpl);
                }
                success = true;
                this.runTriggers(locker, dbImpl);
                R r = results.second();
                return r;
            }
            catch (Error E) {
                this.envImpl.invalidate(E);
                throw E;
            }
            finally {
                locker.operationEnd(success);
            }
        }

        private Locker getWritableLocker(boolean autoTxnIsReplicated) {
            return LockerFactory.getWritableLocker(Environment.this, this.txn, false, this.envImpl.isTransactional(), autoTxnIsReplicated);
        }
    }
}

