/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;

public class ProfiledIterator<E extends JanusGraphElement>
extends CloseableAbstractIterator<E> {
    private final QueryProfiler profiler;
    private final Iterator<E> iterator;
    private boolean timerRunning;

    public ProfiledIterator(QueryProfiler profiler, Supplier<Iterator<E>> iteratorSupplier) {
        this.profiler = profiler;
        profiler.startTimer();
        this.timerRunning = true;
        this.iterator = iteratorSupplier.get();
    }

    protected E computeNext() {
        if (this.iterator.hasNext()) {
            return (E)((JanusGraphElement)this.iterator.next());
        }
        this.close();
        return (E)((JanusGraphElement)this.endOfData());
    }

    public void close() {
        if (this.timerRunning) {
            this.profiler.stopTimer();
            this.timerRunning = false;
        }
        CloseableIterator.closeIterator(this.iterator);
    }
}

