/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.QueryInfo;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.MultiDistinctOrderedIterator;
import org.janusgraph.graphdb.util.MultiDistinctUnorderedIterator;
import org.janusgraph.graphdb.util.ProfiledIterator;

public class JanusGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasStepFolder<S, E>,
Profiling,
HasContainerHolder {
    private final ArrayList<HasContainer> hasContainers = new ArrayList();
    private final Map<String, Map<List<HasContainer>, QueryInfo>> hasLocalContainers = new LinkedHashMap<String, Map<List<HasContainer>, QueryInfo>>();
    private int lowLimit = 0;
    private int highLimit = Integer.MAX_VALUE;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private GraphCentricQuery globalQuery;
    private JanusGraphTransaction tx;

    public JanusGraphStep(GraphStep<S, E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.isStartStep(), originalStep.getIds());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> {
            if (this.ids == null) {
                return Collections.emptyIterator();
            }
            if (this.ids.length > 0) {
                Graph graph = (Graph)this.traversal.asAdmin().getGraph().get();
                return this.iteratorList(Vertex.class.isAssignableFrom(this.getReturnClass()) ? graph.vertices(this.ids) : graph.edges(this.ids));
            }
            this.buildGlobalGraphCentricQuery();
            ArrayListMultimap queries = ArrayListMultimap.create();
            if (this.globalQuery != null && !this.globalQuery.getSubQuery(0).getBackendQuery().isEmpty()) {
                this.globalQuery.observeWith(this.queryProfiler.addNested("GraphCentricQuery"));
                queries.put((Object)0, (Object)this.globalQuery);
            } else if (this.hasLocalContainers.size() == 1) {
                for (Map.Entry<List<HasContainer>, QueryInfo> c : this.hasLocalContainers.values().iterator().next().entrySet()) {
                    GraphCentricQuery centricQuery = this.buildGraphCentricQuery(this.tx, c, this.queryProfiler);
                    centricQuery.observeWith(this.queryProfiler.addNested("GraphCentricQuery"));
                    queries.put((Object)c.getValue().getLowLimit(), (Object)centricQuery);
                }
            } else {
                this.globalQuery.observeWith(this.queryProfiler.addNested("GraphCentricQuery"));
                queries.put((Object)0, (Object)this.globalQuery);
            }
            GraphCentricQueryBuilder builder = (GraphCentricQueryBuilder)this.tx.query();
            ArrayList responses = new ArrayList();
            queries.entries().forEach(q -> this.executeGraphCentricQuery(builder, responses, (Map.Entry<Integer, GraphCentricQuery>)q));
            if (this.orders.isEmpty()) {
                return new MultiDistinctUnorderedIterator(this.lowLimit, this.highLimit, responses);
            }
            return new MultiDistinctOrderedIterator(this.lowLimit, this.highLimit, responses, this.orders);
        });
    }

    public GraphCentricQuery buildGlobalGraphCentricQuery() {
        if (this.ids == null || this.ids.length > 0) {
            return null;
        }
        if (this.globalQuery != null) {
            return this.globalQuery;
        }
        if (this.hasLocalContainers.isEmpty()) {
            LinkedHashMap containers = new LinkedHashMap();
            containers.put(new ArrayList(), new QueryInfo(new ArrayList<HasStepFolder.OrderEntry>(), 0, Integer.MAX_VALUE));
            this.hasLocalContainers.put(null, containers);
        }
        this.tx = JanusGraphTraversalUtil.getTx(this.traversal);
        this.globalQuery = this.buildGlobalGraphCentricQuery(this.tx, this.queryProfiler);
        return this.globalQuery;
    }

    private GraphCentricQuery buildGlobalGraphCentricQuery(JanusGraphTransaction tx, QueryProfiler globalQueryProfiler) {
        Integer limit = null;
        for (Map<List<HasContainer>, QueryInfo> containers : this.hasLocalContainers.values()) {
            for (QueryInfo queryInfo : containers.values()) {
                if (queryInfo.getLowLimit() > 0 || this.orders.isEmpty() && !queryInfo.getOrders().isEmpty()) {
                    return null;
                }
                int currentHighLimit = queryInfo.getHighLimit();
                if (limit == null) {
                    limit = currentHighLimit;
                    continue;
                }
                if (currentHighLimit >= this.highLimit || limit.equals(currentHighLimit)) continue;
                return null;
            }
        }
        JanusGraphQuery<? extends JanusGraphQuery> query = tx.query();
        for (Map<List<HasContainer>, QueryInfo> lc : this.hasLocalContainers.values()) {
            ArrayList<JanusGraphQuery<? extends JanusGraphQuery>> localQueries = new ArrayList<JanusGraphQuery<? extends JanusGraphQuery>>(lc.size());
            for (List<HasContainer> localContainers : lc.keySet()) {
                JanusGraphQuery<? extends JanusGraphQuery> localQuery = tx.query();
                this.addConstraint(localQuery, localContainers);
                localQueries.add(localQuery);
            }
            query.or(localQueries);
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        query.limit(Math.min(limit, this.highLimit));
        return this.buildGraphCentricQuery(query, globalQueryProfiler);
    }

    private void addConstraint(JanusGraphQuery query, List<HasContainer> localContainers) {
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasContainer condition : localContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
    }

    private GraphCentricQuery buildGraphCentricQuery(JanusGraphTransaction tx, Map.Entry<List<HasContainer>, QueryInfo> containers, QueryProfiler queryProfiler) {
        JanusGraphQuery<? extends JanusGraphQuery> query = tx.query();
        this.addConstraint(query, containers.getKey());
        List<HasStepFolder.OrderEntry> realOrders = this.orders.isEmpty() ? containers.getValue().getOrders() : this.orders;
        for (HasStepFolder.OrderEntry order : realOrders) {
            query.orderBy(order.key, order.order);
        }
        if (this.highLimit != Integer.MAX_VALUE || containers.getValue().getHighLimit() != Integer.MAX_VALUE) {
            query.limit(Math.min(containers.getValue().getHighLimit(), this.highLimit));
        }
        return this.buildGraphCentricQuery(query, queryProfiler);
    }

    private GraphCentricQuery buildGraphCentricQuery(JanusGraphQuery query, QueryProfiler queryProfiler) {
        Preconditions.checkArgument((boolean)(query instanceof GraphCentricQueryBuilder));
        QueryProfiler optProfiler = queryProfiler.addNested("constructGraphCentricQuery");
        optProfiler.startTimer();
        GraphCentricQueryBuilder centricQueryBuilder = (GraphCentricQueryBuilder)query;
        if (this.traversal.getEndStep() instanceof CountGlobalStep) {
            centricQueryBuilder.disableSmartLimit();
        }
        GraphCentricQuery graphCentricQuery = centricQueryBuilder.constructQueryWithoutProfile(Vertex.class.isAssignableFrom(this.returnClass) ? ElementCategory.VERTEX : ElementCategory.EDGE);
        optProfiler.stopTimer();
        return graphCentricQuery;
    }

    private void executeGraphCentricQuery(GraphCentricQueryBuilder builder, List<Iterator<E>> responses, Map.Entry<Integer, GraphCentricQuery> entry) {
        GraphCentricQuery query = entry.getValue();
        QueryProfiler profiler = query.getProfiler();
        Class graphClass = Vertex.class.isAssignableFrom(this.returnClass) ? JanusGraphVertex.class : JanusGraphEdge.class;
        ProfiledIterator iterator = new ProfiledIterator(profiler, () -> builder.iterables(query, graphClass).iterator());
        for (long i = 0L; i < (long)entry.getKey().intValue() && iterator.hasNext(); ++i) {
            iterator.next();
        }
        responses.add(iterator);
    }

    public String toString() {
        if (this.hasLocalContainers.isEmpty() && this.hasContainers.isEmpty()) {
            return super.toString();
        }
        if (this.hasLocalContainers.isEmpty()) {
            return StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), this.hasContainers});
        }
        Map<List<HasContainer>, QueryInfo> singleLocalContainers = this.hasLocalContainers.values().iterator().next();
        if (this.hasLocalContainers.size() == 1 && singleLocalContainers.size() == 1) {
            ArrayList<HasContainer> containers = new ArrayList<HasContainer>(this.hasContainers);
            containers.addAll((Collection<HasContainer>)singleLocalContainers.keySet().iterator().next());
            return StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), containers});
        }
        StringBuilder sb = new StringBuilder();
        if (!this.hasContainers.isEmpty()) {
            sb.append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), this.hasContainers}));
        }
        for (Map<List<HasContainer>, QueryInfo> localContainers : this.hasLocalContainers.values()) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append("Or(");
            Iterator<List<HasContainer>> itContainers = localContainers.keySet().iterator();
            sb.append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), itContainers.next()}));
            while (itContainers.hasNext()) {
                sb.append(",").append(StringFactory.stepString((Step)this, (Object[])new Object[]{Arrays.toString(this.ids), itContainers.next()}));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void ensureAdditionalHasContainersCapacity(int additionalSize) {
        this.hasContainers.ensureCapacity(this.hasContainers.size() + additionalSize);
    }

    @Override
    public List<HasContainer> addLocalHasContainersConvertingAndPContainers(TraversalParent parent, List<HasContainer> unconvertedHasContainers) {
        ArrayList<HasContainer> localHasContainers = new ArrayList<HasContainer>(unconvertedHasContainers.size());
        for (HasContainer hasContainer : unconvertedHasContainers) {
            localHasContainers.add(JanusGraphPredicateUtils.convert(hasContainer));
        }
        Map hasContainers = this.hasLocalContainers.computeIfAbsent(parent.asStep().getId(), k -> new LinkedHashMap());
        hasContainers.put(localHasContainers, new QueryInfo(new ArrayList<HasStepFolder.OrderEntry>(), 0, Integer.MAX_VALUE));
        return localHasContainers;
    }

    @Override
    public List<HasContainer> addLocalHasContainersSplittingAndPContainers(TraversalParent parent, Iterable<HasContainer> hasContainers) {
        ArrayList<HasContainer> localHasContainers = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : hasContainers) {
            HasStepFolder.splitAndP(localHasContainers, hasContainer);
        }
        Map containers = this.hasLocalContainers.computeIfAbsent(parent.asStep().getId(), k -> new LinkedHashMap());
        containers.put(localHasContainers, new QueryInfo(new ArrayList<HasStepFolder.OrderEntry>(), 0, Integer.MAX_VALUE));
        return localHasContainers;
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(TraversalParent parent, List<HasContainer> containers, String key, Order order) {
        Map<List<HasContainer>, QueryInfo> hasContainers = this.hasLocalContainers.get(parent.asStep().getId());
        hasContainers.get(containers).getOrders().add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void setLimit(int low, int high) {
        this.lowLimit = low;
        this.highLimit = high;
    }

    @Override
    public void setLocalLimit(TraversalParent parent, List<HasContainer> containers, int low, int high) {
        Map<List<HasContainer>, QueryInfo> hasContainers = this.hasLocalContainers.get(parent.asStep().getId());
        hasContainers.replace(containers, hasContainers.get(containers).setLowLimit(low).setHighLimit(high));
    }

    @Override
    public int getLowLimit() {
        return this.lowLimit;
    }

    @Override
    public int getLocalLowLimit(TraversalParent parent, List<HasContainer> containers) {
        Map<List<HasContainer>, QueryInfo> hasContainers = this.hasLocalContainers.get(parent.asStep().getId());
        return hasContainers.get(containers).getLowLimit();
    }

    @Override
    public int getHighLimit() {
        return this.highLimit;
    }

    @Override
    public int getLocalHighLimit(TraversalParent parent, List<HasContainer> containers) {
        Map<List<HasContainer>, QueryInfo> hasContainers = this.hasLocalContainers.get(parent.asStep().getId());
        return hasContainers.get(containers).getHighLimit();
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }

    public List<HasContainer> getHasContainers() {
        ArrayList<HasContainer> toReturn = new ArrayList<HasContainer>(this.hasContainers);
        this.hasLocalContainers.values().forEach(c -> c.keySet().forEach(toReturn::addAll));
        return toReturn;
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        HasStepFolder.splitAndP(this.hasContainers, hasContainer);
    }

    public List<HasStepFolder.OrderEntry> getOrders() {
        return this.orders;
    }

    private <A extends Element> Iterator<A> iteratorList(Iterator<A> iterator) {
        if (!iterator.hasNext()) {
            return Collections.emptyIterator();
        }
        List<HasContainer> hasContainers = this.getHasContainers();
        ArrayList<Element> list = new ArrayList<Element>(hasContainers.size());
        do {
            Element e;
            if (!HasContainer.testAll((Element)(e = (Element)iterator.next()), hasContainers)) continue;
            list.add(e);
        } while (iterator.hasNext());
        return list.iterator();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hasContainers != null ? this.hasContainers.hashCode() : 0);
        result = 31 * result + (this.hasLocalContainers != null ? this.hasLocalContainers.values().stream().map(Map::hashCode).reduce(0, Integer::sum) : 0);
        result = 31 * result + this.lowLimit;
        result = 31 * result + this.highLimit;
        result = 31 * result + (this.orders != null ? this.orders.hashCode() : 0);
        return result;
    }
}

