/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.javatuples.Pair;

public interface HasStepFolder<S, E>
extends Step<S, E> {
    public void ensureAdditionalHasContainersCapacity(int var1);

    public void addHasContainer(HasContainer var1);

    public List<HasContainer> addLocalHasContainersConvertingAndPContainers(TraversalParent var1, List<HasContainer> var2);

    public List<HasContainer> addLocalHasContainersSplittingAndPContainers(TraversalParent var1, Iterable<HasContainer> var2);

    public void orderBy(String var1, Order var2);

    public void localOrderBy(TraversalParent var1, List<HasContainer> var2, String var3, Order var4);

    public void setLimit(int var1, int var2);

    public void setLocalLimit(TraversalParent var1, List<HasContainer> var2, int var3, int var4);

    public int getLowLimit();

    public int getLocalLowLimit(TraversalParent var1, List<HasContainer> var2);

    public int getHighLimit();

    public int getLocalHighLimit(TraversalParent var1, List<HasContainer> var2);

    public static boolean validJanusGraphHas(HasContainer has) {
        if (has.getPredicate() instanceof ConnectiveP) {
            List predicates = ((ConnectiveP)has.getPredicate()).getPredicates();
            return predicates.stream().allMatch(p -> HasStepFolder.validJanusGraphHas(new HasContainer(has.getKey(), p)));
        }
        return JanusGraphPredicateUtils.supports(has.getBiPredicate());
    }

    public static boolean validJanusGraphHas(Iterable<HasContainer> has) {
        for (HasContainer h : has) {
            if (HasStepFolder.validJanusGraphHas(h)) continue;
            return false;
        }
        return true;
    }

    public static boolean validJanusGraphOrder(OrderGlobalStep orderGlobalStep, Traversal rootTraversal, boolean isVertexOrder) {
        List comparators = orderGlobalStep.getComparators();
        for (Pair comp : comparators) {
            JanusGraphTransaction tx;
            PropertyKey pKey;
            String key;
            if (comp.getValue0() instanceof ValueTraversal && comp.getValue1() instanceof Order) {
                key = ((ValueTraversal)comp.getValue0()).getPropertyKey();
            } else if (comp.getValue1() instanceof ElementValueComparator) {
                ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                if (!(evc.getValueComparator() instanceof Order)) {
                    return false;
                }
                key = evc.getPropertyKey();
            } else {
                return false;
            }
            if ((pKey = (tx = JanusGraphTraversalUtil.getTx(rootTraversal.asAdmin())).getPropertyKey(key)) != null && Comparable.class.isAssignableFrom(pKey.dataType()) && (!isVertexOrder || pKey.cardinality() == Cardinality.SINGLE)) continue;
            return false;
        }
        return true;
    }

    public static void foldInIds(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                HasContainerHolder hasContainerHolder = (HasContainerHolder)currentStep;
                GraphStep graphStep = (GraphStep)janusgraphStep;
                ArrayList removableHasContainers = new ArrayList();
                Set stepLabels = currentStep.getLabels();
                hasContainerHolder.getHasContainers().forEach(hasContainer -> {
                    if (GraphStep.processHasContainerIds((GraphStep)graphStep, (HasContainer)hasContainer)) {
                        stepLabels.forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                        removableHasContainers.add(hasContainer);
                    }
                });
                if (!removableHasContainers.isEmpty()) {
                    removableHasContainers.forEach(arg_0 -> ((HasContainerHolder)hasContainerHolder).removeHasContainer(arg_0));
                }
                if (hasContainerHolder.getHasContainers().isEmpty()) {
                    traversal.removeStep(currentStep);
                }
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
    }

    public static void foldInHasContainer(HasStepFolder janusgraphStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal) {
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof OrStep && janusgraphStep instanceof JanusGraphStep) {
                for (Traversal.Admin child : ((OrStep)currentStep).getLocalChildren()) {
                    if (HasStepFolder.validFoldInHasContainer(child.getStartStep(), false)) continue;
                    return;
                }
                ((OrStep)currentStep).getLocalChildren().forEach(t -> HasStepFolder.localFoldInHasContainer(janusgraphStep, t.getStartStep(), t, rootTraversal));
                currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                traversal.removeStep(currentStep);
            } else if (currentStep instanceof HasContainerHolder && HasStepFolder.validFoldInHasContainer(currentStep, true)) {
                List hasContainersList = ((HasContainerHolder)currentStep).getHasContainers();
                janusgraphStep.ensureAdditionalHasContainersCapacity(hasContainersList.size());
                for (HasContainer hasContainer : hasContainersList) {
                    janusgraphStep.addHasContainer(JanusGraphPredicateUtils.convert(hasContainer));
                }
                currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                traversal.removeStep(currentStep);
            } else {
                if (HasStepFolder.isExistsStep(currentStep)) {
                    currentStep = HasStepFolder.foldInHasFilter(traversal, (TraversalFilterStep)currentStep);
                    continue;
                }
                if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            }
            currentStep = currentStep.getNextStep();
        }
    }

    public static void localFoldInHasContainer(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal) {
        Step<?, ?> currentStep = tinkerpopStep;
        while (true) {
            if (currentStep instanceof HasContainerHolder) {
                List<HasContainer> localHasContainers = janusgraphStep.addLocalHasContainersConvertingAndPContainers(traversal.getParent(), ((HasContainerHolder)currentStep).getHasContainers());
                currentStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                traversal.removeStep((Step)currentStep);
                currentStep = HasStepFolder.foldInOrder(janusgraphStep, currentStep, traversal, rootTraversal, janusgraphStep instanceof JanusGraphStep && ((JanusGraphStep)janusgraphStep).returnsVertex(), localHasContainers);
                HasStepFolder.foldInRange(janusgraphStep, currentStep, traversal, localHasContainers);
            } else {
                if (HasStepFolder.isExistsStep(currentStep)) {
                    currentStep = HasStepFolder.foldInHasFilter(traversal, (TraversalFilterStep)currentStep);
                    continue;
                }
                if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            }
            currentStep = currentStep.getNextStep();
        }
    }

    public static boolean validFoldInHasContainer(Step<?, ?> tinkerpopStep, boolean defaultValue) {
        Step currentStep = tinkerpopStep;
        Boolean toReturn = null;
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof HasContainerHolder) {
                List containers = ((HasContainerHolder)currentStep).getHasContainers();
                toReturn = toReturn == null ? HasStepFolder.validJanusGraphHas(containers) : toReturn != false && HasStepFolder.validJanusGraphHas(containers);
            } else if (HasStepFolder.isExistsStep(currentStep)) {
                toReturn = true;
            } else if (!(currentStep instanceof IdentityStep || currentStep instanceof NoOpBarrierStep || currentStep instanceof RangeGlobalStep || currentStep instanceof OrderGlobalStep)) {
                toReturn = toReturn != null && toReturn != false && defaultValue;
                break;
            }
            currentStep = currentStep.getNextStep();
        }
        return Boolean.TRUE.equals(toReturn);
    }

    public static boolean isExistsStep(Step<?, ?> step) {
        if (step instanceof TraversalFilterStep) {
            List traversals = ((TraversalFilterStep)step).getLocalChildren();
            if (!1.$assertionsDisabled && traversals.size() != 1) {
                throw new AssertionError();
            }
            List steps = ((Traversal.Admin)traversals.get(0)).getSteps();
            if (steps.size() != 1 || !(steps.get(0) instanceof PropertiesStep)) {
                return false;
            }
            return ((PropertiesStep)steps.get(0)).getPropertyKeys().length == 1;
        }
        return false;
    }

    public static Step foldInHasFilter(Traversal.Admin<?, ?> traversal, TraversalFilterStep<?> currentStep) {
        List traversals = currentStep.getLocalChildren();
        if (!1.$assertionsDisabled && traversals.size() != 1) {
            throw new AssertionError();
        }
        List steps = ((Traversal.Admin)traversals.get(0)).getSteps();
        if (!(1.$assertionsDisabled || steps.size() == 1 && steps.get(0) instanceof PropertiesStep)) {
            throw new AssertionError();
        }
        String[] propertyKeys = ((PropertiesStep)steps.get(0)).getPropertyKeys();
        if (!1.$assertionsDisabled && propertyKeys.length != 1) {
            throw new AssertionError();
        }
        HasStep hasStep = new HasStep(traversal, new HasContainer[]{new HasContainer(propertyKeys[0], P.neq(null))});
        currentStep.getLabels().forEach(arg_0 -> ((HasStep)hasStep).addLabel(arg_0));
        TraversalHelper.replaceStep(currentStep, (Step)hasStep, traversal);
        return hasStep;
    }

    public static Step<?, ?> foldInOrder(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, Traversal<?, ?> rootTraversal, boolean isVertexOrder, List<HasContainer> hasContainers) {
        Step currentStep = tinkerpopStep;
        OrderGlobalStep lastOrder = null;
        while (true) {
            if (currentStep instanceof OrderGlobalStep) {
                if (lastOrder != null) {
                    lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
                    traversal.removeStep((Step)lastOrder);
                }
                lastOrder = (OrderGlobalStep)currentStep;
            } else if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof HasStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            currentStep = currentStep.getNextStep();
        }
        if (lastOrder != null && HasStepFolder.validJanusGraphOrder(lastOrder, rootTraversal, isVertexOrder)) {
            for (Pair comp : lastOrder.getComparators()) {
                Order order;
                String key;
                if (comp.getValue0() instanceof ValueTraversal) {
                    ValueTraversal evt = (ValueTraversal)comp.getValue0();
                    key = evt.getPropertyKey();
                    order = (Order)comp.getValue1();
                } else {
                    ElementValueComparator evc = (ElementValueComparator)comp.getValue1();
                    key = evc.getPropertyKey();
                    order = (Order)evc.getValueComparator();
                }
                if (hasContainers == null) {
                    janusgraphStep.orderBy(key, order);
                    continue;
                }
                janusgraphStep.localOrderBy(traversal.getParent(), hasContainers, key, order);
            }
            lastOrder.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
            traversal.removeStep((Step)lastOrder);
        }
        return currentStep;
    }

    public static void splitAndP(List<HasContainer> hasContainers, HasContainer hasContainer) {
        if (hasContainer.getPredicate() instanceof AndP) {
            for (P predicate : ((AndP)hasContainer.getPredicate()).getPredicates()) {
                hasContainers.add(new HasContainer(hasContainer.getKey(), predicate));
            }
        } else {
            hasContainers.add(hasContainer);
        }
    }

    public static void foldInRange(HasStepFolder janusgraphStep, Step<?, ?> tinkerpopStep, Traversal.Admin<?, ?> traversal, List<HasContainer> hasContainers) {
        block6: {
            Step nextStep;
            block7: {
                Step step = nextStep = tinkerpopStep instanceof IdentityStep ? JanusGraphTraversalUtil.getNextNonIdentityStep(tinkerpopStep) : tinkerpopStep;
                if (!(nextStep instanceof RangeGlobalStep)) break block6;
                RangeGlobalStep range = (RangeGlobalStep)nextStep;
                int low = 0;
                if (janusgraphStep instanceof JanusGraphStep) {
                    low = QueryUtil.convertLimit(range.getLowRange());
                    low = QueryUtil.mergeLowLimits(low, hasContainers == null ? janusgraphStep.getLowLimit() : janusgraphStep.getLocalLowLimit(traversal.getParent(), hasContainers));
                }
                int high = QueryUtil.convertLimit(range.getHighRange());
                high = QueryUtil.mergeHighLimits(high, hasContainers == null ? janusgraphStep.getHighLimit() : janusgraphStep.getLocalHighLimit(traversal.getParent(), hasContainers));
                if (hasContainers == null) {
                    janusgraphStep.setLimit(low, high);
                } else {
                    janusgraphStep.setLocalLimit(traversal.getParent(), hasContainers, low, high);
                }
                if (janusgraphStep instanceof JanusGraphStep) break block7;
                if (range.getLowRange() != 0L) break block6;
            }
            nextStep.getLabels().forEach(arg_0 -> ((HasStepFolder)janusgraphStep).addLabel(arg_0));
            traversal.removeStep(nextStep);
        }
    }

    public static boolean foldableHasContainerNoLimit(FlatMapStep<?, ?> janusgraphStep) {
        boolean foldableHasContainerNoLimit = false;
        Step currentStep = janusgraphStep.getNextStep();
        while (true) {
            if (currentStep instanceof OrStep) {
                for (Traversal.Admin child : ((OrStep)currentStep).getLocalChildren()) {
                    if (HasStepFolder.validFoldInHasContainer(child.getStartStep(), false)) continue;
                    return false;
                }
                foldableHasContainerNoLimit = true;
            } else if (currentStep instanceof HasContainerHolder) {
                if (HasStepFolder.validFoldInHasContainer(currentStep, true)) {
                    foldableHasContainerNoLimit = true;
                }
            } else {
                if (currentStep instanceof RangeGlobalStep) {
                    return false;
                }
                if (!(currentStep instanceof IdentityStep) && !(currentStep instanceof NoOpBarrierStep)) break;
            }
            currentStep = currentStep.getNextStep();
        }
        return foldableHasContainerNoLimit;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class OrderEntry {
        public final String key;
        public final Order order;

        public OrderEntry(String key, Order order) {
            this.key = key;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrderEntry that = (OrderEntry)o;
            if (!Objects.equals(this.key, that.key)) {
                return false;
            }
            return this.order == that.order;
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "OrderEntry{key='" + this.key + '\'' + ", order=" + this.order + '}';
        }
    }
}

