/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.profile;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.graphdb.query.Query;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfilerUtil;

public interface QueryProfiler {
    public static final String CONDITION_ANNOTATION = "condition";
    public static final String ORDERS_ANNOTATION = "orders";
    public static final String LIMIT_ANNOTATION = "limit";
    public static final String MULTIQUERY_ANNOTATION = "multi";
    public static final String MULTIPREFETCH_ANNOTATION = "multiPreFetch";
    public static final String NUMVERTICES_ANNOTATION = "vertices";
    public static final String PARTITIONED_VERTEX_ANNOTATION = "partitioned";
    public static final String FITTED_ANNOTATION = "isFitted";
    public static final String ORDERED_ANNOTATION = "isOrdered";
    public static final String QUERY_ANNOTATION = "query";
    public static final String FULLSCAN_ANNOTATION = "fullscan";
    public static final String INDEX_ANNOTATION = "index";
    public static final String QUERIES_ANNOTATION = "queries";
    public static final String QUERIES_AMOUNT_ANNOTATION = "queriesAmount";
    public static final String MULTI_SLICES_ANNOTATION = "multiSlices";
    public static final String QUERY_LIMITS_ANNOTATION = "limitsPerQuery";
    public static final String OR_QUERY = "OR-query";
    public static final String AND_QUERY = "AND-query";
    public static final String BACKEND_QUERY = "backend-query";
    public static final String OPTIMIZATION = "optimization";
    public static final String CONSTRUCT_GRAPH_CENTRIC_QUERY = "constructGraphCentricQuery";
    public static final String GRAPH_CENTRIC_QUERY = "GraphCentricQuery";
    public static final String MIXED_INEX_COUNT_QUERY = "MixedIndexCountQuery";
    public static final QueryProfiler NO_OP = new QueryProfiler(){

        @Override
        public QueryProfiler addNested(String groupName, boolean hasSiblings) {
            return this;
        }

        @Override
        public QueryProfiler setAnnotation(String key, Object value) {
            return this;
        }

        @Override
        public void startTimer() {
        }

        @Override
        public void stopTimer() {
        }

        @Override
        public void setResultSize(long size) {
        }
    };

    default public QueryProfiler addNested(String groupName) {
        return this.addNested(groupName, false);
    }

    public QueryProfiler addNested(String var1, boolean var2);

    public QueryProfiler setAnnotation(String var1, Object var2);

    public void startTimer();

    public void stopTimer();

    public void setResultSize(long var1);

    public static <Q extends Query, R extends Collection> R profile(QueryProfiler profiler, Q query, Function<Q, R> queryExecutor) {
        return QueryProfiler.profile(profiler, query, false, queryExecutor);
    }

    public static <Q extends Query, R extends Collection> R profile(QueryProfiler profiler, Q query, boolean multiQuery, Function<Q, R> queryExecutor) {
        return QueryProfiler.profile(BACKEND_QUERY, profiler, query, multiQuery, queryExecutor);
    }

    public static <Q extends Query, R extends Collection> R profile(String groupName, QueryProfiler profiler, Q query, boolean multiQuery, Function<Q, R> queryExecutor) {
        QueryProfiler sub = profiler.addNested(groupName);
        sub.setAnnotation(QUERY_ANNOTATION, query);
        if (query.hasLimit()) {
            sub.setAnnotation(LIMIT_ANNOTATION, query.getLimit());
        }
        sub.startTimer();
        Collection result = (Collection)queryExecutor.apply(query);
        sub.stopTimer();
        long resultSize = 0L;
        if (multiQuery && profiler != NO_OP) {
            for (Object r : result) {
                if (r instanceof Collection) {
                    resultSize += (long)((Collection)r).size();
                    continue;
                }
                ++resultSize;
            }
        } else {
            resultSize = result.size();
        }
        sub.setResultSize(resultSize);
        return (R)result;
    }

    public static <Q extends Query, R extends Collection> Map<Q, Map<Object, R>> profile(QueryProfiler profiler, MultiKeysQueryGroups<Object, Q> multiSliceQueries, boolean multiQuery, Function<MultiKeysQueryGroups<Object, Q>, Map<Q, Map<Object, R>>> queryExecutor) {
        return QueryProfiler.profile(BACKEND_QUERY, profiler, multiSliceQueries, multiQuery, queryExecutor);
    }

    public static <Q extends Query, R extends Collection> Map<Q, Map<Object, R>> profile(String groupName, QueryProfiler profiler, MultiKeysQueryGroups<Object, Q> multiSliceQueries, boolean multiQuery, Function<MultiKeysQueryGroups<Object, Q>, Map<Q, Map<Object, R>>> queryExecutor) {
        QueryProfiler sub = profiler.addNested(groupName);
        QueryProfilerUtil.setMultiSliceQueryAnnotations(sub, multiSliceQueries);
        sub.startTimer();
        Map<Q, Map<Object, R>> result = queryExecutor.apply(multiSliceQueries);
        sub.stopTimer();
        long resultSize = 0L;
        if (multiQuery && profiler != NO_OP) {
            for (Map<Object, R> resultsPerSlice : result.values()) {
                for (Collection resultsPerVertex : resultsPerSlice.values()) {
                    for (Object r : resultsPerVertex) {
                        if (r instanceof Collection) {
                            resultSize += (long)((Collection)r).size();
                            continue;
                        }
                        ++resultSize;
                    }
                }
            }
        } else {
            for (Map<Object, R> resultsPerSlice : result.values()) {
                for (Collection resultsPerVertex : resultsPerSlice.values()) {
                    resultSize += (long)resultsPerVertex.size();
                }
            }
        }
        sub.setResultSize(resultSize);
        return result;
    }

    public static QueryProfiler startProfile(QueryProfiler profiler, JointIndexQuery.Subquery query) {
        QueryProfiler sub = profiler.addNested(BACKEND_QUERY);
        sub.setAnnotation(QUERY_ANNOTATION, query);
        if (query.hasLimit()) {
            sub.setAnnotation(LIMIT_ANNOTATION, query.getLimit());
        }
        sub.startTimer();
        return sub;
    }
}

