/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;

public class IndexSelectionUtil {
    public static boolean indexCoversOrder(MixedIndexType index, OrderList orders) {
        for (int i = 0; i < orders.size(); ++i) {
            if (index.indexesKey(orders.getKey(i))) continue;
            return false;
        }
        return true;
    }

    private static Iterable<IndexType> getKeyIndexesForCondition(Condition<JanusGraphElement> condition) {
        if (condition instanceof PredicateCondition) {
            RelationType type = (RelationType)((PredicateCondition)condition).getKey();
            Preconditions.checkArgument((type != null && type.isPropertyKey() ? 1 : 0) != 0);
            return ((InternalRelationType)type).getKeyIndexes();
        }
        return Collections.emptySet();
    }

    public static Set<IndexType> getMatchingIndexes(MultiCondition<JanusGraphElement> conditions) {
        return IndexSelectionUtil.getMatchingIndexes(conditions, i -> true);
    }

    public static Set<IndexType> getMatchingIndexes(MultiCondition<JanusGraphElement> conditions, Predicate<IndexType> filter) {
        if (conditions == null || filter == null) {
            return Collections.emptySet();
        }
        HashSet<IndexType> availableIndexes = new HashSet<IndexType>();
        ConditionUtil.traversal(conditions, condition -> {
            for (IndexType indexCandidate : IndexSelectionUtil.getKeyIndexesForCondition(condition)) {
                if (!filter.test(indexCandidate)) continue;
                availableIndexes.add(indexCandidate);
            }
            return true;
        });
        return availableIndexes;
    }

    public static boolean existsMatchingIndex(MultiCondition<JanusGraphElement> conditions) {
        return IndexSelectionUtil.existsMatchingIndex(conditions, i -> true);
    }

    public static boolean existsMatchingIndex(MultiCondition<JanusGraphElement> conditions, Predicate<IndexType> filter) {
        if (conditions == null || filter == null) {
            return false;
        }
        MutableBoolean exists = new MutableBoolean();
        ConditionUtil.traversal(conditions, condition -> {
            if (exists.isFalse()) {
                for (IndexType indexCandidate : IndexSelectionUtil.getKeyIndexesForCondition(condition)) {
                    if (!filter.test(indexCandidate)) continue;
                    exists.setTrue();
                    return true;
                }
            }
            return true;
        });
        return exists.booleanValue();
    }

    public static boolean isIndexSatisfiedByGivenKeys(IndexType index, Collection<String> givenKeys) {
        for (IndexField indexField : index.getFieldKeys()) {
            if (givenKeys.contains(indexField.getFieldKey().name())) continue;
            return false;
        }
        return true;
    }
}

