/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryProcessor;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.util.CloseableIteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCentricQueryBuilder
implements JanusGraphQuery<GraphCentricQueryBuilder> {
    private static final Logger log = LoggerFactory.getLogger(GraphCentricQueryBuilder.class);
    private final StandardJanusGraphTx tx;
    private final IndexSerializer serializer;
    private final List<PredicateCondition<String, JanusGraphElement>> constraints = new ArrayList<PredicateCondition<String, JanusGraphElement>>(5);
    private final List<List<List<PredicateCondition<String, JanusGraphElement>>>> globalConstraints = new ArrayList<List<List<PredicateCondition<String, JanusGraphElement>>>>();
    private OrderList orders = new OrderList();
    private int limit = Integer.MAX_VALUE;
    private QueryProfiler profiler = QueryProfiler.NO_OP;
    private boolean useSmartLimit;
    private int hardMaxLimit;
    private IndexSelectionStrategy indexSelector;
    private static final int DEFAULT_NO_LIMIT = 1000;
    private static final int MAX_BASE_LIMIT = 20000;

    public GraphCentricQueryBuilder(StandardJanusGraphTx tx, IndexSerializer serializer, IndexSelectionStrategy indexSelector) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        Configuration customOptions = tx.getConfiguration().getCustomOptions();
        GraphDatabaseConfiguration graphConfigs = tx.getGraph().getConfiguration();
        this.useSmartLimit = customOptions.has(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]) ? customOptions.get(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]).booleanValue() : graphConfigs.adjustQueryLimit();
        this.hardMaxLimit = customOptions.has(GraphDatabaseConfiguration.HARD_MAX_LIMIT, new String[0]) ? customOptions.get(GraphDatabaseConfiguration.HARD_MAX_LIMIT, new String[0]).intValue() : graphConfigs.getHardMaxLimit();
        this.tx = tx;
        this.serializer = serializer;
        this.indexSelector = indexSelector;
    }

    public void disableSmartLimit() {
        this.useSmartLimit = false;
    }

    public List<PredicateCondition<String, JanusGraphElement>> getConstraints() {
        return this.constraints;
    }

    public GraphCentricQueryBuilder profiler(QueryProfiler profiler) {
        Preconditions.checkNotNull((Object)profiler);
        this.profiler = profiler;
        return this;
    }

    @Override
    public GraphCentricQueryBuilder has(String key, JanusGraphPredicate predicate, Object condition) {
        Preconditions.checkNotNull((Object)predicate);
        Preconditions.checkArgument((boolean)predicate.isValidCondition(condition), (String)"Invalid condition: %s", (Object)condition);
        if (predicate.equals(Contain.NOT_IN)) {
            this.has(key);
        }
        this.constraints.add(new PredicateCondition(key, predicate, condition));
        return this;
    }

    public GraphCentricQueryBuilder has(PropertyKey key, JanusGraphPredicate predicate, Object condition) {
        if (key == null) {
            return this.has((String)null, predicate, condition);
        }
        return this.has(key.name(), predicate, condition);
    }

    @Override
    public GraphCentricQueryBuilder has(String key) {
        return this.has(key, (JanusGraphPredicate)Cmp.NOT_EQUAL, null);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key) {
        return this.has(key, (JanusGraphPredicate)Cmp.EQUAL, null);
    }

    @Override
    public GraphCentricQueryBuilder has(String key, Object value) {
        return this.has(key, (JanusGraphPredicate)Cmp.EQUAL, value);
    }

    @Override
    public GraphCentricQueryBuilder hasNot(String key, Object value) {
        return this.has(key, (JanusGraphPredicate)Cmp.NOT_EQUAL, value);
    }

    @Override
    public <T extends Comparable<?>> GraphCentricQueryBuilder interval(String s, T t1, T t2) {
        this.has(s, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, t1);
        return this.has(s, (JanusGraphPredicate)Cmp.LESS_THAN, t2);
    }

    @Override
    public GraphCentricQueryBuilder limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Non-negative limit expected: %s", (int)limit);
        this.limit = limit;
        return this;
    }

    @Override
    public GraphCentricQueryBuilder orderBy(String keyName, org.apache.tinkerpop.gremlin.process.traversal.Order order) {
        Preconditions.checkArgument((boolean)this.tx.containsPropertyKey(keyName), (String)"Provided key does not exist: %s", (Object)keyName);
        PropertyKey key = this.tx.getPropertyKey(keyName);
        Preconditions.checkArgument((key != null && order != null ? 1 : 0) != 0, (Object)"Need to specify and key and an order");
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.dataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object)key.name(), key.dataType());
        Preconditions.checkArgument((key.cardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Ordering is undefined on multi-valued key [%s]", (Object)key.name());
        Preconditions.checkArgument((!this.orders.containsKey(key) ? 1 : 0) != 0, (String)"orders [%s] already contains key [%s]", (Object)this.orders, (Object)key);
        this.orders.add(key, Order.convert(order));
        return this;
    }

    @Override
    public GraphCentricQueryBuilder or(Collection<GraphCentricQueryBuilder> subQueries) {
        ArrayList constraints = new ArrayList(subQueries.size());
        subQueries.forEach(subQuery -> constraints.add(subQuery.getConstraints()));
        this.globalConstraints.add(constraints);
        return this;
    }

    @Override
    public Iterable<JanusGraphVertex> vertices() {
        return this.iterables(this.constructQuery(ElementCategory.VERTEX), JanusGraphVertex.class);
    }

    @Override
    public Iterable<JanusGraphEdge> edges() {
        return this.iterables(this.constructQuery(ElementCategory.EDGE), JanusGraphEdge.class);
    }

    @Override
    public Iterable<JanusGraphVertexProperty> properties() {
        return this.iterables(this.constructQuery(ElementCategory.PROPERTY), JanusGraphVertexProperty.class);
    }

    public <E extends JanusGraphElement> Iterable<E> iterables(GraphCentricQuery query, Class<E> aClass) {
        return () -> CloseableIteratorUtils.filter(new QueryProcessor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(query, this.tx.elementProcessor).iterator(), aClass::isInstance);
    }

    public GraphCentricQuery constructQuery(ElementCategory resultType) {
        QueryProfiler optProfiler = this.profiler.addNested("optimization");
        optProfiler.startTimer();
        GraphCentricQuery query = this.constructQueryWithoutProfile(resultType);
        optProfiler.stopTimer();
        query.observeWith(this.profiler);
        return query;
    }

    public GraphCentricQuery constructQueryWithoutProfile(ElementCategory resultType) {
        BackendQueryHolder<JointIndexQuery> query;
        MultiCondition conditions;
        Preconditions.checkNotNull((Object)((Object)resultType));
        if (this.limit == 0) {
            return GraphCentricQuery.emptyQuery(resultType);
        }
        if (this.globalConstraints.isEmpty()) {
            this.globalConstraints.add(Collections.singletonList(this.constraints));
        }
        if (this.globalConstraints.size() == 1 && this.globalConstraints.get(0).size() == 1) {
            conditions = QueryUtil.constraints2QNF(this.tx, this.globalConstraints.get(0).get(0));
            if (conditions == null) {
                return GraphCentricQuery.emptyQuery(resultType);
            }
        } else if (this.globalConstraints.size() == 1) {
            conditions = this.constructOrCondition(this.globalConstraints.get(0));
            if (conditions == null) {
                return GraphCentricQuery.emptyQuery(resultType);
            }
        } else {
            conditions = new And();
            for (List<List<PredicateCondition<String, JanusGraphElement>>> globalConstraint : this.globalConstraints) {
                Or<JanusGraphElement> or = this.constructOrCondition(globalConstraint);
                if (or == null) {
                    return GraphCentricQuery.emptyQuery(resultType);
                }
                conditions.add(or);
            }
        }
        this.orders.makeImmutable();
        if (this.orders.isEmpty()) {
            this.orders = OrderList.NO_ORDER;
        }
        HashSet<Condition> coveredClauses = new HashSet<Condition>();
        IndexSelectionStrategy.SelectedIndexQuery selectedIndex = this.indexSelector.selectIndices(resultType, (MultiCondition<JanusGraphElement>)conditions, coveredClauses, this.orders, this.serializer);
        if (!coveredClauses.isEmpty()) {
            int indexLimit = this.useSmartLimit ? (this.limit == Integer.MAX_VALUE ? 1000 : Math.min(20000, this.limit)) : (this.limit == Integer.MAX_VALUE ? this.hardMaxLimit : this.limit);
            indexLimit = Math.min(this.hardMaxLimit, QueryUtil.adjustLimitForTxModifications(this.tx, conditions.numChildren() - coveredClauses.size(), indexLimit));
            query = new BackendQueryHolder<JointIndexQuery>(selectedIndex.getQuery().updateLimit(indexLimit), coveredClauses.size() == conditions.numChildren() || coveredClauses.contains(conditions), selectedIndex.isSorted());
        } else {
            query = new BackendQueryHolder<JointIndexQuery>(new JointIndexQuery(), false, selectedIndex.isSorted());
        }
        return new GraphCentricQuery(resultType, conditions, this.orders, query, this.limit);
    }

    private Or<JanusGraphElement> constructOrCondition(List<List<PredicateCondition<String, JanusGraphElement>>> globalConstraint) {
        Or<JanusGraphElement> or = new Or<JanusGraphElement>();
        for (List list : globalConstraint) {
            And localconditions = QueryUtil.constraints2QNF(this.tx, list);
            if (localconditions == null) {
                return null;
            }
            or.add(localconditions);
        }
        return or;
    }
}

