/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Literal;
import org.janusgraph.graphdb.util.ElementHelper;

public class PredicateCondition<K, E extends JanusGraphElement>
extends Literal<E> {
    private final K key;
    private final JanusGraphPredicate predicate;
    private final Object value;

    public PredicateCondition(K key, JanusGraphPredicate predicate, Object value) {
        if (key != null) {
            Preconditions.checkArgument((key instanceof String || key instanceof RelationType ? 1 : 0) != 0);
        }
        this.key = key;
        this.predicate = (JanusGraphPredicate)Preconditions.checkNotNull((Object)predicate);
        this.value = value;
    }

    private boolean satisfiesCondition(Object value) {
        return this.predicate.test(value, this.value);
    }

    @Override
    public boolean evaluate(E element) {
        RelationType type;
        if (this.key == null) {
            return false;
        }
        if (this.key instanceof String) {
            type = ((InternalElement)element).tx().getRelationType((String)this.key);
            if (type == null) {
                return this.satisfiesCondition(null);
            }
        } else {
            type = (RelationType)this.key;
        }
        Preconditions.checkNotNull((Object)type);
        if (type.isPropertyKey()) {
            Iterator<Object> iterator = ElementHelper.getValues(element, (PropertyKey)type).iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    if (!this.satisfiesCondition(iterator.next())) continue;
                    return true;
                }
                return false;
            }
            return this.satisfiesCondition(null);
        }
        assert (((InternalRelationType)type).multiplicity().isUnique(Direction.OUT));
        return this.satisfiesCondition(element.value(type.name()));
    }

    public K getKey() {
        return this.key;
    }

    public JanusGraphPredicate getPredicate() {
        return this.predicate;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.key, this.predicate, this.value});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        PredicateCondition oth = (PredicateCondition)other;
        return this.key.equals(oth.key) && this.predicate.equals(oth.predicate) && Objects.equals(this.value, oth.value);
    }

    @Override
    public String toString() {
        return this.key.toString() + " " + this.predicate.toString() + " " + this.value;
    }

    public static <K, E extends JanusGraphElement> PredicateCondition<K, E> of(K key, JanusGraphPredicate janusgraphPredicate, Object condition) {
        return new PredicateCondition<K, E>(key, janusgraphPredicate, condition);
    }
}

