/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public abstract class LimitAdjustingIterator<R>
implements CloseableIterator<R> {
    private final int maxLimit;
    private int currentLimit;
    private int count;
    private Iterator<R> iterator;

    public LimitAdjustingIterator(int maxLimit, int currentLimit) {
        Preconditions.checkArgument((currentLimit > 0 && maxLimit > 0 ? 1 : 0) != 0, (String)"Invalid limits: current [%s], max [%s]", (int)currentLimit, (int)maxLimit);
        this.currentLimit = currentLimit;
        this.maxLimit = maxLimit;
        this.count = 0;
        this.iterator = null;
    }

    public abstract Iterator<R> getNewIterator(int var1);

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.getNewIterator(this.currentLimit);
        }
        if (this.currentLimit == Integer.MAX_VALUE || this.count < this.currentLimit) {
            return this.iterator.hasNext();
        }
        if (this.currentLimit >= this.maxLimit) {
            return false;
        }
        CloseableIterator.closeIterator(this.iterator);
        this.currentLimit = (int)Math.min((long)this.maxLimit, Math.round((double)this.currentLimit * 2.0));
        this.iterator = this.getNewIterator(this.currentLimit);
        for (int i = 0; i < this.count; ++i) {
            this.iterator.next();
        }
        assert (this.count < this.currentLimit) : this.count + " vs " + this.currentLimit + " | " + this.maxLimit;
        return this.hasNext();
    }

    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.count;
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        CloseableIterator.closeIterator(this.iterator);
    }
}

