/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.profile.ProfileObservable;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class BackendQueryHolder<E extends BackendQuery<E>>
implements ProfileObservable {
    private final E backendQuery;
    private final boolean isFitted;
    private final boolean isSorted;
    private final Object executionInfo;
    private QueryProfiler profiler = QueryProfiler.NO_OP;

    public BackendQueryHolder(E backendQuery, boolean fitted, boolean sorted, Object executionInfo) {
        Preconditions.checkArgument((backendQuery != null ? 1 : 0) != 0);
        this.backendQuery = backendQuery;
        this.isFitted = fitted;
        this.isSorted = sorted;
        this.executionInfo = executionInfo;
    }

    public BackendQueryHolder(E backendQuery, boolean fitted, boolean sorted) {
        this(backendQuery, fitted, sorted, null);
    }

    public Object getExecutionInfo() {
        return this.executionInfo;
    }

    public boolean isFitted() {
        return this.isFitted;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public E getBackendQuery() {
        return this.backendQuery;
    }

    @Override
    public QueryProfiler getProfiler() {
        return this.profiler;
    }

    @Override
    public void observeWith(QueryProfiler parentProfiler, boolean hasSiblings) {
        Preconditions.checkArgument((parentProfiler != null ? 1 : 0) != 0);
        this.profiler = parentProfiler.addNested("OR-query", hasSiblings);
        this.profiler.setAnnotation("isFitted", this.isFitted);
        this.profiler.setAnnotation("isOrdered", this.isSorted);
        this.profiler.setAnnotation("query", this.backendQuery);
        if (this.backendQuery instanceof ProfileObservable) {
            ((ProfileObservable)this.backendQuery).observeWith(this.profiler);
        }
    }

    public int hashCode() {
        return Objects.hash(this.backendQuery, this.isFitted, this.isFitted);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BackendQueryHolder)) {
            return false;
        }
        BackendQueryHolder oth = (BackendQueryHolder)other;
        return this.isFitted == oth.isFitted && this.isSorted == oth.isSorted && Objects.equals(this.backendQuery, oth.backendQuery);
    }
}

