/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.AbstractScanJob;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.vertices.PreloadedVertex;

public class VertexJobConverter
extends AbstractScanJob {
    protected static final SliceQuery VERTEX_EXISTS_QUERY = new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(4)).setLimit(1);
    public static final String GHOST_VERTEX_COUNT = "ghost-vertices";
    public static final String TRUNCATED_ENTRY_LISTS = "truncated-results";
    protected final VertexScanJob job;

    protected VertexJobConverter(JanusGraph graph, VertexScanJob job) {
        super(graph);
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        this.job = job;
    }

    protected VertexJobConverter(VertexJobConverter copy) {
        super(copy);
        this.job = copy.job.clone();
    }

    public static ScanJob convert(JanusGraph graph, VertexScanJob vertexJob) {
        return new VertexJobConverter(graph, vertexJob);
    }

    public static ScanJob convert(VertexScanJob vertexJob) {
        return new VertexJobConverter(null, vertexJob);
    }

    @Override
    public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
        try {
            this.open(graphConfig);
            this.job.workerIterationStart(this.graph.get(), jobConfig, metrics);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    protected StandardJanusGraphTx startTransaction(StandardJanusGraph graph) {
        return (StandardJanusGraphTx)graph.buildTransaction().readOnlyOLAP().start();
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.job.workerIterationEnd(metrics);
        this.close();
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        Object vertexId = this.getVertexId(key);
        assert (entries.get(VERTEX_EXISTS_QUERY) != null);
        if (this.isGhostVertex(vertexId, entries.get(VERTEX_EXISTS_QUERY))) {
            metrics.incrementCustom(GHOST_VERTEX_COUNT);
            return;
        }
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof PreloadedVertex), (Object)"The bounding transaction is not configured correctly");
        PreloadedVertex v = (PreloadedVertex)vertex;
        v.setAccessCheck(PreloadedVertex.OPENSTAR_CHECK);
        for (Map.Entry<SliceQuery, EntryList> entry : entries.entrySet()) {
            SliceQuery sq = entry.getKey();
            if (sq.equals(VERTEX_EXISTS_QUERY)) continue;
            EntryList entryList = entry.getValue();
            if (entryList.size() >= sq.getLimit()) {
                metrics.incrementCustom(TRUNCATED_ENTRY_LISTS);
            }
            v.addToQueryCache(sq.updateLimit(Integer.MAX_VALUE), entryList);
        }
        this.job.process(v, metrics);
    }

    @Override
    public List<SliceQuery> getQueries() {
        try {
            QueryContainer qc = new QueryContainer(this.tx);
            this.job.getQueries(qc);
            ArrayList<SliceQuery> slices = new ArrayList<SliceQuery>();
            slices.add(VERTEX_EXISTS_QUERY);
            slices.addAll(qc.getSliceQueries());
            return slices;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public Predicate<StaticBuffer> getKeyFilter() {
        return buffer -> !IDManager.VertexIDType.Invisible.is(this.getVertexId((StaticBuffer)buffer));
    }

    @Override
    public VertexJobConverter clone() {
        return new VertexJobConverter(this);
    }
}

