/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.log;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.log.Change;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.database.log.TransactionLogHeader;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.AbstractTypedRelation;
import org.janusgraph.graphdb.relations.CacheEdge;
import org.janusgraph.graphdb.relations.CacheVertexProperty;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class ModificationDeserializer {
    public static InternalRelation parseRelation(TransactionLogHeader.Modification modification, StandardJanusGraphTx tx) {
        AbstractTypedRelation rel;
        Change state = modification.state;
        assert (state.isProper());
        Object outVertexId = modification.outVertexId;
        Entry relEntry = modification.relationEntry;
        InternalVertex outVertex = tx.getInternalVertex(outVertexId);
        RelationCache relCache = tx.getEdgeSerializer().readRelation(relEntry, false, tx);
        assert (relCache.direction == Direction.OUT);
        InternalRelationType type = (InternalRelationType)tx.getExistingRelationType(relCache.typeId);
        assert (type.getBaseType() == null);
        if (type.isPropertyKey()) {
            rel = state == Change.REMOVED ? new StandardVertexProperty(relCache.relationId, (PropertyKey)((Object)type), outVertex, relCache.getValue(), 6) : new CacheVertexProperty(relCache.relationId, (PropertyKey)((Object)type), outVertex, relCache.getValue(), relEntry);
        } else {
            assert (type.isEdgeLabel());
            InternalVertex otherVertex = tx.getInternalVertex(relCache.getOtherVertexId());
            rel = state == Change.REMOVED ? new StandardEdge(relCache.relationId, (EdgeLabel)((Object)type), outVertex, otherVertex, 6) : new CacheEdge(relCache.relationId, (EdgeLabel)((Object)type), outVertex, otherVertex, relEntry);
        }
        if (state == Change.REMOVED && relCache.hasProperties()) {
            for (LongObjectCursor<Object> entry : relCache) {
                rel.setPropertyDirect(tx.getExistingPropertyKey(entry.key), entry.value);
            }
        }
        return rel;
    }
}

