/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;

public class IntegerSerializer
implements OrderPreservingSerializer<Integer> {
    private static final long serialVersionUID = 1174998819862504186L;

    @Override
    public Integer read(ScanBuffer buffer) {
        long l = VariableLong.read(buffer);
        Preconditions.checkArgument((l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid serialization [%s]", (long)l);
        return (int)l;
    }

    @Override
    public void write(WriteBuffer out, Integer attribute) {
        VariableLong.write(out, attribute.intValue());
    }

    @Override
    public Integer readByteOrder(ScanBuffer buffer) {
        return buffer.getInt() + Integer.MIN_VALUE;
    }

    @Override
    public void writeByteOrder(WriteBuffer out, Integer attribute) {
        out.putInt(attribute - Integer.MIN_VALUE);
    }

    @Override
    public Integer convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            Preconditions.checkArgument((!Double.isNaN(d) && (double)Math.round(d) == d ? 1 : 0) != 0, (String)"Not a valid integer: %s", (Object)value);
            long l = ((Number)value).longValue();
            Preconditions.checkArgument((l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Value too large for integer: %s", (Object)value);
            return (int)l;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return null;
    }
}

