/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.OrderPreservingSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongSerializer;

public class DateSerializer
implements OrderPreservingSerializer<Date> {
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    private static final DateTimeFormatter LENIENT_ISO_LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().toFormatter(Locale.ROOT);
    private static final DateTimeFormatter TIME_OFFSET_WITHOUT_COLON = new DateTimeFormatterBuilder().appendOffset("+HHmm", "Z").toFormatter(Locale.ROOT);
    private static final DateTimeFormatter LENIENT_ISO_DATE_TIME = new DateTimeFormatterBuilder().append(LENIENT_ISO_LOCAL_DATE_TIME).optionalStart().appendZoneOrOffsetId().optionalEnd().optionalStart().append(TIME_OFFSET_WITHOUT_COLON).optionalEnd().toFormatter(Locale.ROOT);
    private final LongSerializer ls = LongSerializer.INSTANCE;

    @Override
    public Date read(ScanBuffer buffer) {
        long utc = this.ls.read(buffer);
        return new Date(utc);
    }

    @Override
    public void write(WriteBuffer out, Date attribute) {
        long utc = attribute.getTime();
        this.ls.write(out, utc);
    }

    @Override
    public Date readByteOrder(ScanBuffer buffer) {
        return this.read(buffer);
    }

    @Override
    public void writeByteOrder(WriteBuffer buffer, Date attribute) {
        this.write(buffer, attribute);
    }

    @Override
    public Date convert(Object value) {
        if (value instanceof Number && !(value instanceof Float) && !(value instanceof Double)) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            String s = (String)value;
            Long v = Longs.tryParse((String)s);
            if (v != null) {
                return new Date(v);
            }
            if (s.contains(" ")) {
                return DateSerializer.dateFromTemporalAccessor(DateTimeFormatter.RFC_1123_DATE_TIME.parse(s));
            }
            return DateSerializer.dateFromTemporalAccessor(LENIENT_ISO_DATE_TIME.parse(s));
        }
        return null;
    }

    private static Date dateFromTemporalAccessor(TemporalAccessor accessor) {
        LocalDate localDate = (LocalDate)MoreObjects.firstNonNull((Object)accessor.query(TemporalQueries.localDate()), (Object)EPOCH);
        LocalTime localTime = (LocalTime)MoreObjects.firstNonNull((Object)accessor.query(TemporalQueries.localTime()), (Object)LocalTime.MIDNIGHT);
        ZoneId zone = (ZoneId)MoreObjects.firstNonNull((Object)accessor.query(TemporalQueries.zone()), (Object)ZoneOffset.UTC);
        return Date.from(ZonedDateTime.of(localDate, localTime, zone).toInstant());
    }
}

