/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public class ChunkedJobDefinition<T, C, R> {
    private final Queue<T> dataChunks = new ConcurrentLinkedQueue<T>();
    private volatile boolean lastChunkRetrieved;
    private final ReentrantLock processingLock = new ReentrantLock();
    private volatile C processedDataContext;
    private final CompletableFuture<R> result = new CompletableFuture();

    public Queue<T> getDataChunks() {
        return this.dataChunks;
    }

    public boolean isLastChunkRetrieved() {
        return this.lastChunkRetrieved;
    }

    public void setLastChunkRetrieved() {
        this.lastChunkRetrieved = true;
    }

    public boolean tryLockProcessing() {
        return this.processingLock.tryLock();
    }

    public void unlockProcessing() {
        this.processingLock.unlock();
    }

    public C getProcessedDataContext() {
        return this.processedDataContext;
    }

    public void setProcessedDataContext(C processedDataContext) {
        this.processedDataContext = processedDataContext;
    }

    public void complete(R resultData) {
        this.result.complete(resultData);
    }

    public CompletableFuture<R> getResult() {
        return this.result;
    }
}

