/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum StandardStoreManager {
    BDB_JE("org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager", "berkeleyje"),
    CQL("org.janusgraph.diskstorage.cql.CQLStoreManager", "cql"),
    HBASE("org.janusgraph.diskstorage.hbase.HBaseStoreManager", "hbase"),
    IN_MEMORY("org.janusgraph.diskstorage.inmemory.InMemoryStoreManager", "inmemory"),
    SCYLLA("org.janusgraph.diskstorage.cql.ScyllaStoreManager", "scylla");

    private static final Set<String> ALL_SHORTHANDS;
    private static final Map<String, String> ALL_MANAGER_CLASSES;
    private final String managerClass;
    private final Set<String> shorthands;
    private final String firstStoreShorthand;

    private StandardStoreManager(String managerClass, Collection<String> shorthands) {
        if (shorthands == null || shorthands.size() <= 0) {
            throw new IllegalArgumentException("At least one shorthand should be specified for manager class " + managerClass);
        }
        this.managerClass = managerClass;
        this.shorthands = Collections.unmodifiableSet(new LinkedHashSet<String>(shorthands));
        this.firstStoreShorthand = shorthands.iterator().next();
    }

    private StandardStoreManager(String managerClass, String shorthand) {
        this(managerClass, Collections.singleton(shorthand));
    }

    public Set<String> getShorthands() {
        return this.shorthands;
    }

    public String getFirstStoreShorthand() {
        return this.firstStoreShorthand;
    }

    public String getManagerClass() {
        return this.managerClass;
    }

    public static Set<String> getAllShorthands() {
        return ALL_SHORTHANDS;
    }

    public static Map<String, String> getAllManagerClasses() {
        return ALL_MANAGER_CLASSES;
    }

    static {
        StandardStoreManager[] backends = StandardStoreManager.values();
        LinkedHashSet tempShorthands = new LinkedHashSet(backends.length);
        HashMap tempClassMap = new HashMap(backends.length);
        for (StandardStoreManager backend : backends) {
            backend.getShorthands().forEach(shorthand -> {
                tempShorthands.add(shorthand);
                tempClassMap.put(shorthand, backend.getManagerClass());
            });
        }
        ALL_SHORTHANDS = Collections.unmodifiableSet(tempShorthands);
        ALL_MANAGER_CLASSES = Collections.unmodifiableMap(tempClassMap);
    }
}

