/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;

public enum Multiplicity {
    MULTI,
    SIMPLE,
    ONE2MANY,
    MANY2ONE,
    ONE2ONE;


    public boolean isConstrained() {
        return this != MULTI;
    }

    public boolean isConstrained(Direction direction) {
        if (direction == Direction.BOTH) {
            return this.isConstrained();
        }
        return this != MULTI && (this == SIMPLE || this.isUnique(direction));
    }

    public boolean isUnique(Direction direction) {
        switch (direction) {
            case IN: {
                return this == ONE2MANY || this == ONE2ONE;
            }
            case OUT: {
                return this == MANY2ONE || this == ONE2ONE;
            }
            case BOTH: {
                return this == ONE2ONE;
            }
        }
        throw new AssertionError((Object)("Unknown direction: " + direction));
    }

    public static Multiplicity convert(Cardinality cardinality) {
        Preconditions.checkNotNull((Object)((Object)cardinality));
        switch (cardinality) {
            case LIST: {
                return MULTI;
            }
            case SET: {
                return SIMPLE;
            }
            case SINGLE: {
                return MANY2ONE;
            }
        }
        throw new AssertionError((Object)("Unknown cardinality: " + (Object)((Object)cardinality)));
    }

    public static Multiplicity convert(VertexProperty.Cardinality cardinality) {
        Preconditions.checkNotNull((Object)cardinality);
        switch (cardinality) {
            case list: {
                return MULTI;
            }
            case set: {
                return SIMPLE;
            }
            case single: {
                return MANY2ONE;
            }
        }
        throw new AssertionError((Object)("Unknown cardinality: " + cardinality));
    }

    public Cardinality getCardinality() {
        switch (this) {
            case MULTI: {
                return Cardinality.LIST;
            }
            case SIMPLE: {
                return Cardinality.SET;
            }
            case MANY2ONE: {
                return Cardinality.SINGLE;
            }
        }
        throw new AssertionError((Object)("Invalid multiplicity: " + (Object)((Object)this)));
    }
}

