/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HiddenFileFilter;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class VertexWritableIterator
implements Iterator<Vertex> {
    private final VertexWritable value = new VertexWritable();
    private boolean available = false;
    private final Queue<SequenceFile.Reader> readers = new LinkedList<SequenceFile.Reader>();

    public VertexWritableIterator(Configuration configuration, Path path) throws IOException {
        for (FileStatus status : FileSystem.get((Configuration)configuration).listStatus(path, (PathFilter)HiddenFileFilter.instance())) {
            this.readers.add(new SequenceFile.Reader(configuration, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)status.getPath())}));
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.available) {
                return true;
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    return false;
                }
                if (this.readers.peek().next((Writable)this.value)) {
                    this.available = true;
                    return true;
                }
                this.readers.remove().close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public Vertex next() {
        try {
            if (this.available) {
                this.available = false;
                return this.value.get();
            }
            while (true) {
                if (this.readers.isEmpty()) {
                    throw new NoSuchElementException();
                }
                if (this.readers.peek().next((Writable)this.value)) {
                    return this.value.get();
                }
                this.readers.remove().close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

