/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util;

public class IDUtils {
    public static int compare(Object id1, Object id2) {
        if (id1 instanceof Number && id2 instanceof String) {
            return -1;
        }
        if (id1 instanceof String && id2 instanceof Number) {
            return 1;
        }
        if (id1 instanceof String && id2 instanceof String) {
            return ((String)id1).compareTo((String)id2);
        }
        if (id1 instanceof Number && id2 instanceof Number) {
            return Long.compare(((Number)id1).longValue(), ((Number)id2).longValue());
        }
        throw new IllegalArgumentException("Cannot compare ids: " + id1 + ", " + id2);
    }

    public static void checkId(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (id instanceof String) {
            return;
        }
        if (id instanceof Number) {
            if (((Number)id).longValue() <= 0L) {
                throw new IllegalArgumentException(String.format("Id %d is non-positive", ((Number)id).longValue()));
            }
            return;
        }
        throw new IllegalArgumentException("Id must be either String or a positive long value");
    }
}

