/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Connection;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.MixedIndexAggQuery;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.ReadOnlyTransactionException;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaInspector;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.idassigner.IDPool;
import org.janusgraph.graphdb.database.index.IndexRecords;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.MetricsQueryExecutor;
import org.janusgraph.graphdb.query.QueryExecutor;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.GraphCentricQuery;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.graph.IndexQueryBuilder;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.graph.MixedIndexAggQueryBuilder;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.MultiVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.VertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.relations.RelationComparator;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.relations.RelationIdentifierUtils;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsTransaction;
import org.janusgraph.graphdb.transaction.RelationConstructor;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.janusgraph.graphdb.transaction.VertexFactory;
import org.janusgraph.graphdb.transaction.VertexIterable;
import org.janusgraph.graphdb.transaction.addedrelations.AddedRelationsContainer;
import org.janusgraph.graphdb.transaction.addedrelations.ConcurrentAddedRelations;
import org.janusgraph.graphdb.transaction.addedrelations.EmptyAddedRelations;
import org.janusgraph.graphdb.transaction.addedrelations.SimpleAddedRelations;
import org.janusgraph.graphdb.transaction.indexcache.ConcurrentIndexCache;
import org.janusgraph.graphdb.transaction.indexcache.EmptyIndexCache;
import org.janusgraph.graphdb.transaction.indexcache.IndexCache;
import org.janusgraph.graphdb.transaction.indexcache.SimpleIndexCache;
import org.janusgraph.graphdb.transaction.lock.CombinerLock;
import org.janusgraph.graphdb.transaction.lock.FakeLock;
import org.janusgraph.graphdb.transaction.lock.IndexLockTuple;
import org.janusgraph.graphdb.transaction.lock.LockTuple;
import org.janusgraph.graphdb.transaction.lock.ReentrantTransactionLock;
import org.janusgraph.graphdb.transaction.lock.TransactionLock;
import org.janusgraph.graphdb.transaction.subquerycache.CaffeineSubqueryCache;
import org.janusgraph.graphdb.transaction.subquerycache.EmptySubqueryCache;
import org.janusgraph.graphdb.transaction.subquerycache.SubqueryCache;
import org.janusgraph.graphdb.transaction.vertexcache.CaffeineVertexCache;
import org.janusgraph.graphdb.transaction.vertexcache.EmptyVertexCache;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.StandardPropertyKeyMaker;
import org.janusgraph.graphdb.types.StandardVertexLabelMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionDescription;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;
import org.janusgraph.graphdb.types.system.SystemTypeManager;
import org.janusgraph.graphdb.types.vertices.EdgeLabelVertex;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.PropertyKeyVertex;
import org.janusgraph.graphdb.util.IndexHelper;
import org.janusgraph.graphdb.util.MultiSliceQueriesGroupingUtil;
import org.janusgraph.graphdb.util.ProfiledIterator;
import org.janusgraph.graphdb.util.SubqueryIterator;
import org.janusgraph.graphdb.util.VertexCentricEdgeIterable;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.graphdb.vertices.PreloadedVertex;
import org.janusgraph.graphdb.vertices.StandardVertex;
import org.janusgraph.util.IDUtils;
import org.janusgraph.util.datastructures.Retriever;
import org.janusgraph.util.stats.MetricManager;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJanusGraphTx
extends JanusGraphBlueprintsTransaction
implements TypeInspector,
SchemaInspector,
VertexFactory {
    private static final Logger log = LoggerFactory.getLogger(StandardJanusGraphTx.class);
    private static final Map<Long, InternalRelation> EMPTY_DELETED_RELATIONS = Collections.emptyMap();
    private static final ConcurrentMap<LockTuple, TransactionLock> UNINITIALIZED_LOCKS = null;
    private static final Duration LOCK_TIMEOUT = Duration.ofMillis(5000L);
    private static final long MIN_VERTEX_CACHE_SIZE = 100L;
    private final StandardJanusGraph graph;
    private final TransactionConfiguration config;
    private final IDManager idManager;
    private final IDManager idInspector;
    private final AttributeHandler attributeHandler;
    private BackendTransaction txHandle;
    private final EdgeSerializer edgeSerializer;
    private final IndexSerializer indexSerializer;
    private final IndexSelectionStrategy indexSelector;
    private VertexCache vertexCache;
    private AddedRelationsContainer addedRelations;
    private volatile Map<Long, InternalRelation> deletedRelations;
    private SubqueryCache indexCache;
    private IndexCache newVertexIndexEntries;
    private volatile Map<LockTuple, TransactionLock> uniqueLocks;
    private Map<String, Long> newTypeCache;
    private final IDPool temporaryIds;
    private final TimestampProvider times;
    private volatile boolean isOpen;
    private final VertexConstructor existingVertexRetriever;
    private final VertexConstructor externalVertexRetriever;
    private final VertexConstructor internalVertexRetriever;
    public final QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery> edgeProcessor;
    public final QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery> edgeProcessorImpl = new QueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery>(){

        @Override
        public Iterator<JanusGraphRelation> getNew(VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew() || vertex.hasAddedRelations()) {
                return this.getMatchedRelations(query, vertex);
            }
            return Collections.emptyIterator();
        }

        private Iterator<JanusGraphRelation> getMatchedRelations(final VertexCentricQuery query, final InternalVertex vertex) {
            return new Iterator<JanusGraphRelation>(){
                Iterator<InternalRelation> iterator;
                InternalRelation loop;
                InternalRelation current;
                {
                    this.iterator = vertex.getAddedRelations((Predicate<InternalRelation>)((Predicate)t -> true)).iterator();
                    this.loop = null;
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    if (this.current == null) {
                        this.current = this.nextRelation();
                        return this.current != null;
                    }
                    return true;
                }

                @Override
                public JanusGraphRelation next() {
                    if (this.hasNext()) {
                        InternalRelation current = this.current;
                        this.current = null;
                        return current;
                    }
                    throw new NoSuchElementException();
                }

                private InternalRelation nextRelation() {
                    if (this.loop != null) {
                        InternalRelation loop = this.loop;
                        this.loop = null;
                        return loop;
                    }
                    while (this.iterator.hasNext()) {
                        InternalRelation next = this.iterator.next();
                        if (!query.matches(next)) continue;
                        if (query.getDirection() == Direction.BOTH && next instanceof JanusGraphEdge && next.isLoop()) {
                            this.loop = next;
                        }
                        return next;
                    }
                    return null;
                }
            };
        }

        @Override
        public boolean hasDeletions(VertexCentricQuery query) {
            InternalVertex vertex = query.getVertex();
            if (vertex.isNew()) {
                return false;
            }
            return vertex.hasRemovedRelations() || vertex.hasAddedRelations();
        }

        @Override
        public boolean isDeleted(VertexCentricQuery query, JanusGraphRelation result) {
            if (StandardJanusGraphTx.this.deletedRelations.containsKey(result.longId()) || result != ((InternalRelation)result).it()) {
                return true;
            }
            InternalRelationType type = (InternalRelationType)result.getType();
            InternalVertex vertex = query.getVertex();
            if (type.multiplicity().isConstrained() && vertex.hasAddedRelations()) {
                RelationComparator comparator = new RelationComparator(vertex);
                return !Iterables.isEmpty(vertex.getAddedRelations((Predicate<InternalRelation>)((Predicate)internalRelation -> comparator.compare((InternalRelation)result, (InternalRelation)internalRelation) == 0)));
            }
            return false;
        }

        @Override
        public Iterator<JanusGraphRelation> execute(VertexCentricQuery query, SliceQuery sq, Object exeInfo, QueryProfiler profiler) {
            assert (exeInfo == null);
            if (query.getVertex().isNew()) {
                return Collections.emptyIterator();
            }
            InternalVertex v = query.getVertex();
            EntryList iterable = v.loadRelations(sq, query1 -> QueryProfiler.profile(profiler, query1, q -> StandardJanusGraphTx.this.graph.edgeQuery(v.id(), (SliceQuery)q, StandardJanusGraphTx.this.txHandle)));
            return RelationConstructor.readRelation(v, iterable, StandardJanusGraphTx.this).iterator();
        }
    };
    public final QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery> elementProcessor;
    public final QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery> elementProcessorImpl = new QueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(){

        private PredicateCondition<PropertyKey, JanusGraphElement> getEqualityCondition(Condition<JanusGraphElement> condition) {
            if (condition instanceof PredicateCondition) {
                PredicateCondition pc = (PredicateCondition)condition;
                if (pc.getPredicate() == Cmp.EQUAL && TypeUtil.hasSimpleInternalVertexKeyIndex((PropertyKey)pc.getKey())) {
                    return pc;
                }
            } else if (condition instanceof And) {
                for (Condition<JanusGraphElement> child : condition.getChildren()) {
                    PredicateCondition<PropertyKey, JanusGraphElement> p = this.getEqualityCondition(child);
                    if (p == null) continue;
                    return p;
                }
            }
            return null;
        }

        @Override
        public Iterator<JanusGraphElement> getNew(GraphCentricQuery query) {
            if (query.numSubQueries() == 1 && query.getSubQuery(0).getBackendQuery().isEmpty()) {
                return Collections.emptyIterator();
            }
            Preconditions.checkArgument((boolean)query.getCondition().hasChildren(), (Object)"If the query is non-empty it needs to have a condition");
            if (query.getResultType() == ElementCategory.VERTEX && StandardJanusGraphTx.this.hasModifications()) {
                Iterator vertices;
                Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(query.getCondition()));
                PredicateCondition<PropertyKey, JanusGraphElement> standardIndexKey = this.getEqualityCondition(query.getCondition());
                if (standardIndexKey == null) {
                    HashSet keys = new HashSet();
                    ConditionUtil.traversal(query.getCondition(), cond -> {
                        Preconditions.checkArgument((cond.getType() != Condition.Type.LITERAL || cond instanceof PredicateCondition ? 1 : 0) != 0);
                        if (cond instanceof PredicateCondition) {
                            keys.add(((PredicateCondition)cond).getKey());
                        }
                        return true;
                    });
                    Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (String)"Invalid query condition: %s", query.getCondition());
                    HashSet<JanusGraphVertex> vertexSet = new HashSet<JanusGraphVertex>();
                    for (JanusGraphRelation janusGraphRelation : StandardJanusGraphTx.this.addedRelations.getView((Predicate<InternalRelation>)((Predicate)relation -> keys.contains(relation.getType())))) {
                        vertexSet.add(((JanusGraphVertexProperty)janusGraphRelation).element());
                    }
                    for (JanusGraphRelation janusGraphRelation : StandardJanusGraphTx.this.deletedRelations.values()) {
                        JanusGraphVertex v;
                        if (!keys.contains(janusGraphRelation.getType()) || (v = ((JanusGraphVertexProperty)janusGraphRelation).element()).isRemoved()) continue;
                        vertexSet.add(v);
                    }
                    vertices = vertexSet.iterator();
                } else {
                    vertices = Iterators.transform(StandardJanusGraphTx.this.newVertexIndexEntries.get(standardIndexKey.getValue(), standardIndexKey.getKey()).iterator(), (Function)new Function<JanusGraphVertexProperty, JanusGraphVertex>(){

                        @Nullable
                        public JanusGraphVertex apply(JanusGraphVertexProperty o) {
                            return o.element();
                        }
                    });
                }
                return Iterators.filter((Iterator)vertices, query::matches);
            }
            if (!(query.getResultType() != ElementCategory.EDGE && query.getResultType() != ElementCategory.PROPERTY || StandardJanusGraphTx.this.addedRelations.isEmpty())) {
                return StandardJanusGraphTx.this.addedRelations.getView((Predicate<InternalRelation>)((Predicate)relation -> query.getResultType().isInstance((JanusGraphElement)relation) && !relation.isInvisible() && query.matches((JanusGraphElement)relation))).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasDeletions(GraphCentricQuery query) {
            return StandardJanusGraphTx.this.hasModifications();
        }

        @Override
        public boolean isDeleted(GraphCentricQuery query, JanusGraphElement result) {
            if (result == null || result.isRemoved()) {
                return true;
            }
            if (query.getResultType() == ElementCategory.VERTEX) {
                Preconditions.checkArgument((boolean)(result instanceof InternalVertex));
                InternalVertex v = ((InternalVertex)result).it();
                return (v.hasAddedRelations() || v.hasRemovedRelations()) && !query.matches(result);
            }
            if (query.getResultType() == ElementCategory.EDGE || query.getResultType() == ElementCategory.PROPERTY) {
                Preconditions.checkArgument((result.isLoaded() || result.isNew() ? 1 : 0) != 0);
                return result.isNew() && !query.matches(result);
            }
            throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
        }

        @Override
        public Iterator<JanusGraphElement> execute(GraphCentricQuery query, JointIndexQuery indexQuery, Object exeInfo, QueryProfiler profiler) {
            ArrayList retrievals;
            if (!indexQuery.isEmpty()) {
                retrievals = new ArrayList();
                for (int i = 1; i < indexQuery.size(); ++i) {
                    JointIndexQuery.Subquery subquery = indexQuery.getQuery(i);
                    retrievals.add(limit -> {
                        JointIndexQuery.Subquery adjustedQuery = subquery.updateLimit(limit);
                        try {
                            return StandardJanusGraphTx.this.indexCache.get(adjustedQuery, () -> QueryProfiler.profile(subquery.getProfiler(), adjustedQuery, q -> StandardJanusGraphTx.this.indexSerializer.query((JointIndexQuery.Subquery)q, StandardJanusGraphTx.this.txHandle).collect(Collectors.toList())));
                        }
                        catch (Exception e) {
                            throw new JanusGraphException("Could not call index", e);
                        }
                    });
                }
            } else {
                Supplier iteratorSupplier;
                if (StandardJanusGraphTx.this.config.hasForceIndexUsage()) {
                    throw new JanusGraphException("Could not find a suitable index to answer graph query and graph scans are disabled: " + query);
                }
                log.warn("Query requires iterating over all vertices [{}]. For better performance, use indexes", query.getCondition());
                QueryProfiler sub = profiler.addNested("scan");
                sub.setAnnotation("query", indexQuery);
                sub.setAnnotation("fullscan", true);
                sub.setAnnotation("condition", (Object)query.getResultType());
                switch (query.getResultType()) {
                    case VERTEX: {
                        iteratorSupplier = () -> StandardJanusGraphTx.this.getVertices(new Object[0]).iterator();
                        break;
                    }
                    case EDGE: {
                        iteratorSupplier = () -> StandardJanusGraphTx.this.getEdges(new RelationIdentifier[0]).iterator();
                        break;
                    }
                    case PROPERTY: {
                        iteratorSupplier = () -> new VertexCentricEdgeIterable(StandardJanusGraphTx.this.getInternalVertices(), RelationCategory.PROPERTY).iterator();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)query.getResultType()));
                    }
                }
                return new ProfiledIterator(sub, iteratorSupplier);
            }
            SubqueryIterator iterator = new SubqueryIterator(indexQuery.getQuery(0), StandardJanusGraphTx.this.indexSerializer, StandardJanusGraphTx.this.txHandle, StandardJanusGraphTx.this.indexCache, indexQuery.getLimit(), StandardJanusGraphTx.this.getConversionFunction(query.getResultType()), retrievals.isEmpty() ? null : QueryUtil.processIntersectingRetrievals(retrievals, Integer.MAX_VALUE));
            return iterator;
        }
    };
    private final java.util.function.Function<Object, JanusGraphVertex> vertexIDConversionFct = id -> {
        Preconditions.checkNotNull((Object)id);
        return this.getInternalVertex(id);
    };
    private final java.util.function.Function<Object, JanusGraphEdge> edgeIDConversionFct = id -> {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
        return RelationIdentifierUtils.findEdge((RelationIdentifier)id, this);
    };
    private final java.util.function.Function<Object, JanusGraphVertexProperty> propertyIDConversionFct = id -> {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)(id instanceof RelationIdentifier));
        return RelationIdentifierUtils.findProperty((RelationIdentifier)id, this);
    };

    public StandardJanusGraphTx(StandardJanusGraph graph, TransactionConfiguration config) {
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)graph.isOpen());
        Preconditions.checkNotNull((Object)config);
        this.graph = graph;
        this.times = graph.getConfiguration().getTimestampProvider();
        this.allowCustomVertexIdType = graph.getConfiguration().allowCustomVertexIdType();
        this.config = config;
        this.idInspector = this.idManager = graph.getIDManager();
        this.attributeHandler = graph.getDataSerializer();
        this.edgeSerializer = graph.getEdgeSerializer();
        this.indexSerializer = graph.getIndexSerializer();
        this.indexSelector = graph.getIndexSelector();
        this.temporaryIds = new IDPool(){
            private final AtomicLong counter = new AtomicLong(1L);

            @Override
            public long nextID() {
                return this.counter.getAndIncrement();
            }

            @Override
            public void close() {
            }
        };
        if (config.isSingleThreaded()) {
            this.addedRelations = new SimpleAddedRelations();
            this.newTypeCache = new HashMap<String, Long>();
            this.newVertexIndexEntries = new SimpleIndexCache();
        } else {
            this.addedRelations = new ConcurrentAddedRelations();
            this.newTypeCache = new NonBlockingHashMap();
            this.newVertexIndexEntries = new ConcurrentIndexCache();
        }
        boolean preloadedData = config.hasPreloadedData();
        this.externalVertexRetriever = new VertexConstructor(config.hasVerifyExternalVertexExistence(), preloadedData);
        this.internalVertexRetriever = new VertexConstructor(config.hasVerifyInternalVertexExistence(), preloadedData);
        this.existingVertexRetriever = new VertexConstructor(false, preloadedData);
        long effectiveVertexCacheSize = config.getVertexCacheSize();
        if (!config.isReadOnly()) {
            effectiveVertexCacheSize = Math.max(100L, effectiveVertexCacheSize);
            log.debug("Caffeine vertex cache size: requested={} effective={} (min={})", new Object[]{config.getVertexCacheSize(), effectiveVertexCacheSize, 100L});
        }
        this.vertexCache = new CaffeineVertexCache(effectiveVertexCacheSize, config.getDirtyVertexSize());
        this.indexCache = new CaffeineSubqueryCache(config.getIndexCacheWeight());
        this.uniqueLocks = UNINITIALIZED_LOCKS;
        this.deletedRelations = EMPTY_DELETED_RELATIONS;
        this.isOpen = true;
        if (null != config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(config.getGroupName(), "tx", "begin").inc();
            this.elementProcessor = new MetricsQueryExecutor<GraphCentricQuery, JanusGraphElement, JointIndexQuery>(config.getGroupName(), "graph", this.elementProcessorImpl);
            this.edgeProcessor = new MetricsQueryExecutor<VertexCentricQuery, JanusGraphRelation, SliceQuery>(config.getGroupName(), "vertex", this.edgeProcessorImpl);
        } else {
            this.elementProcessor = this.elementProcessorImpl;
            this.edgeProcessor = this.edgeProcessorImpl;
        }
    }

    public void setBackendTransaction(BackendTransaction txHandle) {
        Preconditions.checkArgument((this.txHandle == null && txHandle != null ? 1 : 0) != 0);
        this.txHandle = txHandle;
    }

    private void verifyWriteAccess(JanusGraphVertex ... vertices) {
        if (this.config.isReadOnly()) {
            throw new ReadOnlyTransactionException("Cannot create new entities in read-only transaction");
        }
        for (JanusGraphVertex v : vertices) {
            if (!v.hasId() || !this.idInspector.isUnmodifiableVertex(v.id()) || v.isNew()) continue;
            throw new SchemaViolationException("Cannot modify unmodifiable vertex: " + v);
        }
        this.verifyAccess(vertices);
    }

    public final void verifyAccess(JanusGraphVertex ... vertices) {
        this.verifyOpen();
        for (JanusGraphVertex v : vertices) {
            Preconditions.checkArgument((boolean)(v instanceof InternalVertex), (String)"Invalid vertex: %s", (Object)v);
            if (!(v instanceof SystemRelationType) && this != ((InternalVertex)v).tx()) {
                throw new IllegalStateException("The vertex or type is not associated with this transaction [" + v + "]");
            }
            if (!v.isRemoved()) continue;
            throw new IllegalStateException("The vertex or type has been removed [" + v + "]");
        }
    }

    private void verifyOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Operation cannot be executed because the enclosing transaction is closed");
        }
    }

    public StandardJanusGraphTx getNextTx() {
        Preconditions.checkArgument((boolean)this.isClosed());
        if (!this.config.isThreadBound()) {
            throw new IllegalStateException("Cannot access element because its enclosing transaction is closed and unbound");
        }
        return (StandardJanusGraphTx)this.graph.getCurrentThreadTx();
    }

    public TransactionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public StandardJanusGraph getGraph() {
        return this.graph;
    }

    public BackendTransaction getTxHandle() {
        return this.txHandle;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public IDManager getIdInspector() {
        return this.idInspector;
    }

    public boolean isPartitionedVertex(JanusGraphVertex vertex) {
        return vertex.hasId() && this.idInspector.isPartitionedVertex(vertex.id());
    }

    public InternalVertex getCanonicalVertex(InternalVertex partitionedVertex) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        long canonicalId = this.idManager.getCanonicalVertexId(((Number)partitionedVertex.id()).longValue());
        if (partitionedVertex.id().equals(canonicalId)) {
            return partitionedVertex;
        }
        return this.getExistingVertex(canonicalId);
    }

    public InternalVertex getOtherPartitionVertex(JanusGraphVertex partitionedVertex, long otherPartition) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        return this.getExistingVertex(this.idManager.getPartitionedVertexId(((Number)partitionedVertex.id()).longValue(), otherPartition));
    }

    public InternalVertex[] getAllRepresentatives(JanusGraphVertex partitionedVertex, boolean restrict2Partitions) {
        int i;
        long[] ids;
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertex));
        if (!restrict2Partitions || !this.config.hasRestrictedPartitions()) {
            ids = this.idManager.getPartitionedVertexRepresentatives(((Number)partitionedVertex.id()).longValue());
        } else {
            int[] restrictedPartitions = this.config.getRestrictedPartitions();
            ids = new long[restrictedPartitions.length];
            for (i = 0; i < ids.length; ++i) {
                ids[i] = this.idManager.getPartitionedVertexId(((Number)partitionedVertex.id()).longValue(), restrictedPartitions[i]);
            }
        }
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0);
        InternalVertex[] vertices = new InternalVertex[ids.length];
        for (i = 0; i < ids.length; ++i) {
            vertices[i] = this.getExistingVertex(ids[i]);
        }
        return vertices;
    }

    public boolean containsVertex(Object vertexId) {
        return this.getVertex(vertexId) != null;
    }

    private boolean isValidVertexId(Object id) {
        if (!this.idInspector.isSchemaVertexId(id) && !this.idInspector.isUserVertexId(id)) {
            return false;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() > 0L;
        }
        assert (id instanceof String);
        if (!StringUtils.isAsciiPrintable((CharSequence)((String)id))) {
            log.warn("ID contains non-ascii or non-printable character, ignored: " + id);
            return false;
        }
        if (((String)id).contains(RelationIdentifier.TOSTRING_DELIMITER)) {
            log.warn("ID contains illegal " + RelationIdentifier.TOSTRING_DELIMITER + " substring, ignored: " + id);
            return false;
        }
        return true;
    }

    @Override
    public JanusGraphVertex getVertex(Object vertexId) {
        InternalVertex v;
        this.verifyOpen();
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getVertexByID").inc();
        }
        if (!this.isValidVertexId(vertexId)) {
            return null;
        }
        if (this.idInspector.isPartitionedVertex(vertexId)) {
            vertexId = this.idManager.getCanonicalVertexId(((Number)vertexId).longValue());
        }
        return null == (v = this.vertexCache.get(vertexId, this.externalVertexRetriever)) || v.isRemoved() ? null : v;
    }

    @Override
    public Iterable<JanusGraphVertex> getVertices(Object ... ids) {
        this.verifyOpen();
        if (ids == null || ids.length == 0) {
            return this.getInternalVertices();
        }
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getVerticesByID").inc();
        }
        ArrayList<JanusGraphVertex> result = new ArrayList<JanusGraphVertex>(ids.length);
        ArrayList<Object> vertexIds = new ArrayList<Object>(ids.length);
        for (Object id : ids) {
            assert (id instanceof String || id instanceof Number);
            if (!this.allowCustomVertexIdType && id instanceof String) {
                id = Long.valueOf((String)id);
            }
            if (!this.isValidVertexId(id)) continue;
            if (this.idInspector.isPartitionedVertex(id)) {
                id = this.idManager.getCanonicalVertexId(((Number)id).longValue());
            }
            if (this.vertexCache.contains(id)) {
                result.add(this.vertexCache.get(id, this.existingVertexRetriever));
                continue;
            }
            vertexIds.add(id);
        }
        if (!vertexIds.isEmpty()) {
            if (this.externalVertexRetriever.hasVerifyExistence()) {
                List<EntryList> existence = this.graph.edgeMultiQuery(vertexIds, this.graph.vertexExistenceQuery, this.txHandle);
                for (int i = 0; i < vertexIds.size(); ++i) {
                    if (existence.get(i).isEmpty()) continue;
                    Object id = vertexIds.get(i);
                    result.add(this.vertexCache.get(id, this.existingVertexRetriever));
                }
            } else {
                for (int i = 0; i < vertexIds.size(); ++i) {
                    result.add(this.vertexCache.get(vertexIds.get(i), this.externalVertexRetriever));
                }
            }
        }
        result.removeIf(JanusGraphElement::isRemoved);
        return result;
    }

    private InternalVertex getExistingVertex(Object vertexId) {
        return this.vertexCache.get(vertexId, this.existingVertexRetriever);
    }

    @Override
    public InternalVertex getInternalVertex(Object vertexId) {
        return this.vertexCache.get(vertexId, this.internalVertexRetriever);
    }

    @Override
    public JanusGraphVertex addVertex(Object vertexId, VertexLabel label) {
        this.verifyWriteAccess(new JanusGraphVertex[0]);
        if (label == null) {
            label = BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        if (vertexId != null && !this.graph.getConfiguration().allowVertexIdSetting()) {
            log.info("Provided vertex id [{}] is ignored because vertex id setting is not enabled", vertexId);
            vertexId = null;
        }
        Preconditions.checkArgument((vertexId != null || !this.graph.getConfiguration().allowVertexIdSetting() ? 1 : 0) != 0, (Object)"Must provide vertex id");
        Preconditions.checkArgument((vertexId == null || IDManager.VertexIDType.NormalVertex.is(vertexId) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object)vertexId);
        Preconditions.checkArgument((vertexId == null || ((InternalVertexLabel)label).hasDefaultConfiguration() ? 1 : 0) != 0, (String)"Cannot only use default vertex labels: %s", (Object)label);
        Preconditions.checkArgument((vertexId == null || !this.config.hasVerifyExternalVertexExistence() || !this.containsVertex(vertexId) ? 1 : 0) != 0, (String)"Vertex with given id already exists: %s", (Object)vertexId);
        if (vertexId != null && vertexId instanceof String && !StringUtils.isAsciiPrintable((CharSequence)((String)vertexId))) {
            throw new IllegalArgumentException("Custom string id contains non-ascii or non-printable character: " + vertexId);
        }
        if (vertexId != null && vertexId instanceof String && ((String)vertexId).contains(RelationIdentifier.TOSTRING_DELIMITER)) {
            throw new IllegalArgumentException("Custom string id contains reserved string (" + RelationIdentifier.TOSTRING_DELIMITER + "): " + vertexId);
        }
        StandardVertex vertex = new StandardVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.NormalVertex, this.temporaryIds.nextID()), 1);
        if (vertexId != null) {
            vertex.setId(vertexId);
        } else if (this.config.hasAssignIDsImmediately() || label.isPartitioned()) {
            this.graph.assignID(vertex, label);
        }
        this.addProperty(vertex, BaseKey.VertexExists, Boolean.TRUE);
        if (label != BaseVertexLabel.DEFAULT_VERTEXLABEL) {
            Preconditions.checkArgument((boolean)(label instanceof VertexLabelVertex));
            this.addEdge(vertex, label, BaseLabel.VertexLabelEdge);
        }
        this.vertexCache.add(vertex, vertex.id());
        return vertex;
    }

    @Override
    public JanusGraphVertex addVertex(String vertexLabel) {
        return this.addVertex(this.getOrCreateVertexLabel(vertexLabel));
    }

    public JanusGraphVertex addVertex(VertexLabel vertexLabel) {
        return this.addVertex(null, vertexLabel);
    }

    private Iterable<InternalVertex> getInternalVertices() {
        Iterable<InternalVertex> allVertices;
        if (!this.addedRelations.isEmpty()) {
            List<InternalVertex> newVs = this.vertexCache.getAllNew();
            newVs.removeIf(internalVertex -> internalVertex instanceof JanusGraphSchemaElement);
            allVertices = Iterables.concat(newVs, (Iterable)new VertexIterable(this.graph, this));
        } else {
            allVertices = new VertexIterable(this.graph, this);
        }
        return Iterables.filter((Iterable)allVertices, internalVertex -> !this.isPartitionedVertex((JanusGraphVertex)internalVertex) || internalVertex.id().equals(this.idInspector.getCanonicalVertexId(((Number)internalVertex.id()).longValue())));
    }

    public final boolean validDataType(Class datatype) {
        return this.attributeHandler.validDataType(datatype);
    }

    public final Object verifyAttribute(PropertyKey key, Object attribute) {
        Class<?> datatype = key.dataType();
        if (datatype.equals(Object.class)) {
            if (!this.attributeHandler.validDataType(attribute.getClass())) {
                throw Property.Exceptions.dataTypeOfPropertyValueNotSupported((Object)attribute);
            }
        } else {
            if (!attribute.getClass().equals(datatype)) {
                Object converted = null;
                try {
                    converted = this.attributeHandler.convert(datatype, attribute);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (converted == null) {
                    throw new SchemaViolationException("Value [%s] is not an instance of the expected data type for property key [%s] and cannot be converted. Expected: %s, found: %s", attribute, key.name(), datatype, attribute.getClass());
                }
                attribute = converted;
            }
            assert (attribute.getClass().equals(datatype));
            this.attributeHandler.verifyAttribute(datatype, attribute);
        }
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelation(InternalRelation relation) {
        int i;
        Preconditions.checkArgument((!relation.isRemoved() ? 1 : 0) != 0);
        relation = relation.it();
        for (i = 0; i < relation.getLen(); ++i) {
            this.verifyWriteAccess(relation.getVertex(i));
        }
        for (i = 0; i < relation.getLen(); ++i) {
            InternalVertex vertex = relation.getVertex(i);
            vertex.removeRelation(relation);
            if (vertex.isNew()) continue;
            this.vertexCache.add(vertex, vertex.id());
        }
        if (relation.isNew()) {
            this.addedRelations.remove(relation);
            if (TypeUtil.hasSimpleInternalVertexKeyIndex(relation)) {
                this.newVertexIndexEntries.remove((JanusGraphVertexProperty)((Object)relation));
            }
        } else {
            Preconditions.checkArgument((boolean)relation.isLoaded());
            Map<Long, InternalRelation> result = this.deletedRelations;
            if (result == EMPTY_DELETED_RELATIONS) {
                if (this.config.isSingleThreaded()) {
                    this.deletedRelations = result = new HashMap<Long, InternalRelation>();
                } else {
                    StandardJanusGraphTx standardJanusGraphTx = this;
                    synchronized (standardJanusGraphTx) {
                        result = this.deletedRelations;
                        if (result == EMPTY_DELETED_RELATIONS) {
                            this.deletedRelations = result = new ConcurrentHashMap<Long, InternalRelation>();
                        }
                    }
                }
            }
            result.put(relation.longId(), relation);
        }
    }

    public boolean isRemovedRelation(Long relationId) {
        return this.deletedRelations.containsKey(relationId);
    }

    private TransactionLock getLock(Object ... tuple) {
        return this.getLock(new LockTuple(tuple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionLock getLock(LockTuple la) {
        ReentrantTransactionLock lock;
        TransactionLock existingLock;
        if (this.config.isSingleThreaded()) {
            return FakeLock.INSTANCE;
        }
        Map<LockTuple, TransactionLock> result = this.uniqueLocks;
        if (result == UNINITIALIZED_LOCKS) {
            Preconditions.checkArgument((!this.config.isSingleThreaded() ? 1 : 0) != 0);
            StandardJanusGraphTx standardJanusGraphTx = this;
            synchronized (standardJanusGraphTx) {
                result = this.uniqueLocks;
                if (result == UNINITIALIZED_LOCKS) {
                    this.uniqueLocks = result = new ConcurrentHashMap<LockTuple, TransactionLock>();
                }
            }
        }
        return (existingLock = result.putIfAbsent(la, lock = new ReentrantTransactionLock())) == null ? lock : existingLock;
    }

    private TransactionLock getUniquenessLock(JanusGraphVertex out, InternalRelationType type, Object in) {
        Multiplicity multiplicity = type.multiplicity();
        TransactionLock uniqueLock = FakeLock.INSTANCE;
        if (this.config.hasVerifyUniqueness() && multiplicity.isConstrained()) {
            uniqueLock = null;
            if (multiplicity == Multiplicity.SIMPLE) {
                uniqueLock = this.getLock(out, type, in);
            } else {
                for (Direction dir : Direction.proper) {
                    if (!multiplicity.isUnique(dir)) continue;
                    TransactionLock lock = this.getLock(dir == Direction.OUT ? out : in, type, dir);
                    uniqueLock = uniqueLock == null ? lock : new CombinerLock(uniqueLock, lock, this.times);
                }
            }
        }
        assert (uniqueLock != null);
        return uniqueLock;
    }

    private void checkPropertyConstraintForVertexOrCreatePropertyConstraint(JanusGraphVertex vertex, PropertyKey key) {
        if (this.config.hasDisabledSchemaConstraints()) {
            return;
        }
        VertexLabel vertexLabel = vertex.vertexLabel();
        if (vertexLabel instanceof BaseVertexLabel) {
            return;
        }
        Collection<PropertyKey> propertyKeys = vertexLabel.mappedProperties();
        if (propertyKeys.contains(key)) {
            return;
        }
        this.config.getAutoSchemaMaker().makePropertyConstraintForVertex(vertexLabel, key, this);
    }

    public void checkPropertyConstraintForEdgeOrCreatePropertyConstraint(StandardEdge edge, PropertyKey key) {
        if (this.config.hasDisabledSchemaConstraints()) {
            return;
        }
        EdgeLabel edgeLabel = edge.edgeLabel();
        if (edgeLabel instanceof BaseLabel) {
            return;
        }
        Collection<PropertyKey> propertyKeys = edgeLabel.mappedProperties();
        if (propertyKeys.contains(key)) {
            return;
        }
        this.config.getAutoSchemaMaker().makePropertyConstraintForEdge(edgeLabel, key, this);
    }

    private void checkConnectionConstraintOrCreateConnectionConstraint(JanusGraphVertex outVertex, JanusGraphVertex inVertex, EdgeLabel edgeLabel) {
        if (this.config.hasDisabledSchemaConstraints()) {
            return;
        }
        VertexLabel outVertexLabel = outVertex.vertexLabel();
        if (outVertexLabel instanceof BaseVertexLabel) {
            return;
        }
        VertexLabel inVertexLabel = inVertex.vertexLabel();
        if (inVertexLabel instanceof BaseVertexLabel) {
            return;
        }
        Collection<Connection> connections = outVertexLabel.mappedConnections();
        for (Connection connection : connections) {
            if (connection.getIncomingVertexLabel().longId() != inVertexLabel.longId() || !connection.getEdgeLabel().equals(edgeLabel.name())) continue;
            return;
        }
        this.config.getAutoSchemaMaker().makeConnectionConstraint(edgeLabel, outVertexLabel, inVertexLabel, this);
    }

    public JanusGraphEdge addEdge(JanusGraphVertex outVertex, JanusGraphVertex inVertex, EdgeLabel label) {
        return this.addEdge(null, outVertex, inVertex, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JanusGraphEdge addEdge(Long id, JanusGraphVertex outVertex, JanusGraphVertex inVertex, EdgeLabel label) {
        this.verifyWriteAccess(outVertex, inVertex);
        outVertex = ((InternalVertex)outVertex).it();
        inVertex = ((InternalVertex)inVertex).it();
        Preconditions.checkNotNull((Object)label);
        this.checkConnectionConstraintOrCreateConnectionConstraint(outVertex, inVertex, label);
        Multiplicity multiplicity = label.multiplicity();
        TransactionLock uniqueLock = this.getUniquenessLock(outVertex, (InternalRelationType)((Object)label), inVertex);
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            if (this.config.hasVerifyUniqueness()) {
                if (multiplicity == Multiplicity.SIMPLE && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).adjacent(inVertex)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists between the pair of vertices and the label [%s] is simple", label.name());
                }
                if (multiplicity.isUnique(Direction.OUT) && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(outVertex).type(label)).direction(Direction.OUT)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists on the out-vertex and the label [%s] is out-unique", label.name());
                }
                if (multiplicity.isUnique(Direction.IN) && !Iterables.isEmpty(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query(inVertex).type(label)).direction(Direction.IN)).edges())) {
                    throw new SchemaViolationException("An edge with the given label already exists on the in-vertex and the label [%s] is in-unique", label.name());
                }
            }
            long edgeId = id == null ? IDManager.getTemporaryRelationID(this.temporaryIds.nextID()) : id;
            StandardEdge edge = new StandardEdge(edgeId, label, (InternalVertex)outVertex, (InternalVertex)inVertex, 1);
            if (this.config.hasAssignIDsImmediately() && id == null) {
                this.graph.assignID(edge);
            }
            this.connectRelation(edge);
            StandardEdge standardEdge = edge;
            return standardEdge;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    private void connectRelation(InternalRelation r) {
        for (int i = 0; i < r.getLen(); ++i) {
            boolean success = r.getVertex(i).addRelation(r);
            if (!success) {
                throw new AssertionError((Object)("Could not connect relation: " + r));
            }
        }
        this.addedRelations.add(r);
        for (int pos = 0; pos < r.getLen(); ++pos) {
            InternalVertex vertex = r.getVertex(pos);
            if (vertex.isNew()) continue;
            this.vertexCache.add(vertex, vertex.id());
        }
        if (TypeUtil.hasSimpleInternalVertexKeyIndex(r)) {
            this.newVertexIndexEntries.add((JanusGraphVertexProperty)((Object)r));
        }
    }

    public JanusGraphVertexProperty addProperty(JanusGraphVertex vertex, PropertyKey key, Object value) {
        return this.addProperty(vertex, key, value, null);
    }

    public JanusGraphVertexProperty addProperty(JanusGraphVertex vertex, PropertyKey key, Object value, Long id) {
        return this.addProperty(key.cardinality().convert(), vertex, key, value, id);
    }

    public JanusGraphVertexProperty addProperty(VertexProperty.Cardinality cardinality, JanusGraphVertex vertex, PropertyKey key, Object value) {
        return this.addProperty(cardinality, vertex, key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JanusGraphVertexProperty addProperty(VertexProperty.Cardinality cardinality, JanusGraphVertex vertex, PropertyKey key, Object value, Long id) {
        if (key.cardinality().convert() != cardinality && cardinality != VertexProperty.Cardinality.single) {
            throw new SchemaViolationException("Key is defined for %s cardinality which conflicts with specified: %s", new Object[]{key.cardinality(), cardinality});
        }
        this.verifyWriteAccess(vertex);
        Preconditions.checkArgument((!(key instanceof ImplicitKey) ? 1 : 0) != 0, (String)"Cannot create a property of implicit type: %s", (Object)key.name());
        vertex = ((InternalVertex)vertex).it();
        Preconditions.checkNotNull((Object)key);
        this.checkPropertyConstraintForVertexOrCreatePropertyConstraint(vertex, key);
        Object normalizedValue = this.verifyAttribute(key, value);
        Cardinality keyCardinality = key.cardinality();
        ArrayList<IndexLockTuple> uniqueIndexTuples = new ArrayList<IndexLockTuple>();
        for (CompositeIndexType compositeIndexType : TypeUtil.getUniqueIndexes(key)) {
            IndexRecords matches = IndexRecordUtil.indexMatches(vertex, compositeIndexType, key, normalizedValue);
            for (Object[] match : matches.getRecordValues()) {
                uniqueIndexTuples.add(new IndexLockTuple(compositeIndexType, match));
            }
        }
        TransactionLock uniqueLock = this.getUniquenessLock(vertex, (InternalRelationType)((Object)key), normalizedValue);
        for (IndexLockTuple lockTuple : uniqueIndexTuples) {
            uniqueLock = new CombinerLock(uniqueLock, this.getLock(lockTuple), this.times);
        }
        uniqueLock.lock(LOCK_TIMEOUT);
        try {
            long l = id == null ? IDManager.getTemporaryRelationID(this.temporaryIds.nextID()) : id;
            StandardVertexProperty prop = new StandardVertexProperty(l, key, (InternalVertex)vertex, normalizedValue, 1);
            if (this.config.hasAssignIDsImmediately() && id == null) {
                this.graph.assignID(prop);
            }
            if (cardinality == VertexProperty.Cardinality.single || cardinality == VertexProperty.Cardinality.set) {
                Consumer<JanusGraphVertexProperty> propertyRemover = JanusGraphVertexProperty.getRemover(cardinality, normalizedValue);
                if (!(this.config.hasVerifyUniqueness() && ((InternalRelationType)((Object)key)).getConsistencyModifier() == ConsistencyModifier.LOCK || TypeUtil.hasAnyIndex(key) || cardinality != keyCardinality.convert())) {
                    ((InternalVertex)vertex).getAddedRelations((Predicate<InternalRelation>)((Predicate)p -> p.getType().equals(key))).forEach(p -> propertyRemover.accept((JanusGraphVertexProperty)((Object)p)));
                    prop.setUpsert(true);
                } else {
                    ((VertexCentricQueryBuilder)((InternalVertex)vertex).query().types(key)).properties().forEach(propertyRemover);
                }
            }
            if (this.config.hasVerifyUniqueness()) {
                for (IndexLockTuple lockTuple : uniqueIndexTuples) {
                    if (Iterables.isEmpty(IndexHelper.getQueryResults(lockTuple.getIndex(), lockTuple.getAll(), this))) continue;
                    throw new SchemaViolationException("Adding this property for key [%s] and value [%s] violates a uniqueness constraint [%s]", key.name(), normalizedValue, lockTuple.getIndex());
                }
            }
            this.connectRelation(prop);
            StandardVertexProperty standardVertexProperty = prop;
            return standardVertexProperty;
        }
        finally {
            uniqueLock.unlock();
        }
    }

    @Override
    public Iterable<JanusGraphEdge> getEdges(RelationIdentifier ... ids) {
        this.verifyOpen();
        if (ids == null || ids.length == 0) {
            return new VertexCentricEdgeIterable<JanusGraphEdge>(this.getInternalVertices(), RelationCategory.EDGE);
        }
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "db", "getEdgesByID").inc();
        }
        ArrayList<JanusGraphEdge> result = new ArrayList<JanusGraphEdge>(ids.length);
        for (RelationIdentifier id : ids) {
            JanusGraphEdge edge;
            if (id == null || (edge = RelationIdentifierUtils.findEdge(id, this)) == null || edge.isRemoved()) continue;
            result.add(edge);
        }
        return result;
    }

    public final JanusGraphSchemaVertex makeSchemaVertex(JanusGraphSchemaCategory schemaCategory, String name, TypeDefinitionMap definition) {
        JanusGraphSchemaVertex schemaVertex;
        this.verifyOpen();
        Preconditions.checkArgument((!schemaCategory.hasName() || StringUtils.isNotBlank((CharSequence)name) ? 1 : 0) != 0, (String)"Need to provide a valid name for type [%s]", (Object)((Object)schemaCategory));
        schemaCategory.verifyValidDefinition(definition);
        if (schemaCategory.isRelationType()) {
            if (schemaCategory == JanusGraphSchemaCategory.PROPERTYKEY) {
                schemaVertex = new PropertyKeyVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserPropertyKey, this.temporaryIds.nextID()), 1);
            } else {
                assert (schemaCategory == JanusGraphSchemaCategory.EDGELABEL);
                schemaVertex = new EdgeLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.UserEdgeLabel, this.temporaryIds.nextID()), 1);
            }
        } else {
            schemaVertex = schemaCategory == JanusGraphSchemaCategory.VERTEXLABEL ? new VertexLabelVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1) : new JanusGraphSchemaVertex(this, IDManager.getTemporaryVertexID(IDManager.VertexIDType.GenericSchemaType, this.temporaryIds.nextID()), 1);
        }
        this.graph.assignID(schemaVertex, BaseVertexLabel.DEFAULT_VERTEXLABEL);
        Preconditions.checkArgument((schemaVertex.longId() > 0L ? 1 : 0) != 0);
        if (schemaCategory.hasName()) {
            this.addProperty(schemaVertex, BaseKey.SchemaName, schemaCategory.getSchemaName(name));
        }
        this.addProperty(schemaVertex, BaseKey.VertexExists, Boolean.TRUE);
        this.addProperty(schemaVertex, BaseKey.SchemaCategory, (Object)schemaCategory);
        this.updateSchemaVertex(schemaVertex);
        for (Map.Entry def : definition.entrySet()) {
            JanusGraphVertexProperty p = this.addProperty(schemaVertex, BaseKey.SchemaDefinitionProperty, def.getValue());
            p.property(BaseKey.SchemaDefinitionDesc.name(), TypeDefinitionDescription.of((TypeDefinitionCategory)((Object)def.getKey())));
        }
        this.vertexCache.add(schemaVertex, schemaVertex.longId());
        if (schemaCategory.hasName()) {
            this.newTypeCache.put(schemaCategory.getSchemaName(name), schemaVertex.longId());
        }
        return schemaVertex;
    }

    public void updateSchemaVertex(JanusGraphSchemaVertex schemaVertex) {
        this.addProperty(VertexProperty.Cardinality.single, schemaVertex, BaseKey.SchemaUpdateTime, (Object)this.times.getTime(this.times.getTime()));
    }

    public PropertyKey makePropertyKey(String name, TypeDefinitionMap definition) {
        return (PropertyKey)((Object)this.makeSchemaVertex(JanusGraphSchemaCategory.PROPERTYKEY, name, definition));
    }

    public EdgeLabel makeEdgeLabel(String name, TypeDefinitionMap definition) {
        return (EdgeLabel)((Object)this.makeSchemaVertex(JanusGraphSchemaCategory.EDGELABEL, name, definition));
    }

    public JanusGraphEdge addSchemaEdge(JanusGraphVertex out, JanusGraphVertex in, TypeDefinitionCategory def, Object modifier) {
        assert (def.isEdge());
        JanusGraphEdge edge = this.addEdge(out, in, BaseLabel.SchemaDefinitionEdge);
        TypeDefinitionDescription desc = new TypeDefinitionDescription(def, modifier);
        edge.property(BaseKey.SchemaDefinitionDesc.name(), desc);
        return edge;
    }

    @Override
    public VertexLabel addProperties(VertexLabel vertexLabel, PropertyKey ... keys) {
        for (PropertyKey key : keys) {
            this.addSchemaEdge(vertexLabel, key, TypeDefinitionCategory.PROPERTY_KEY_EDGE, null);
        }
        return vertexLabel;
    }

    @Override
    public EdgeLabel addProperties(EdgeLabel edgeLabel, PropertyKey ... keys) {
        for (PropertyKey key : keys) {
            if (key.cardinality() != Cardinality.SINGLE) {
                throw new IllegalArgumentException(String.format("An Edge [%s] can not have a property [%s] with the cardinality [%s].", new Object[]{edgeLabel, key, key.cardinality()}));
            }
            this.addSchemaEdge(edgeLabel, key, TypeDefinitionCategory.PROPERTY_KEY_EDGE, null);
        }
        return edgeLabel;
    }

    @Override
    public EdgeLabel addConnection(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel) {
        this.addSchemaEdge(outVLabel, inVLabel, TypeDefinitionCategory.CONNECTION_EDGE, edgeLabel.name());
        this.addSchemaEdge(edgeLabel, outVLabel, TypeDefinitionCategory.UPDATE_CONNECTION_EDGE, null);
        return edgeLabel;
    }

    public JanusGraphSchemaVertex getSchemaVertex(String schemaName) {
        Long schemaId = this.newTypeCache.get(schemaName);
        if (schemaId == null) {
            schemaId = this.graph.getSchemaCache().getSchemaId(schemaName);
        }
        if (schemaId != null) {
            InternalVertex typeVertex = this.vertexCache.get(schemaId, this.existingVertexRetriever);
            assert (typeVertex != null);
            return (JanusGraphSchemaVertex)typeVertex;
        }
        return null;
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.getRelationType(name) != null;
    }

    @Override
    public RelationType getRelationType(String name) {
        this.verifyOpen();
        SystemRelationType type = SystemTypeManager.getSystemType(name);
        if (type != null) {
            return type;
        }
        return (RelationType)((Object)this.getSchemaVertex(JanusGraphSchemaCategory.getRelationTypeName(name)));
    }

    @Override
    public boolean containsPropertyKey(String name) {
        RelationType type = this.getRelationType(name);
        return type != null && type.isPropertyKey();
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        RelationType type = this.getRelationType(name);
        return type != null && type.isEdgeLabel();
    }

    @Override
    public RelationType getExistingRelationType(long typeId) {
        assert (this.idInspector.isRelationTypeId(typeId));
        if (IDManager.isSystemRelationTypeId(typeId)) {
            return SystemTypeManager.getSystemType(typeId);
        }
        InternalVertex v = this.getInternalVertex(typeId);
        return (RelationType)((Object)v);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        RelationType pk = this.getRelationType(name);
        Preconditions.checkArgument((pk == null || pk.isPropertyKey() ? 1 : 0) != 0, (String)"The relation type with name [%s] is not a property key", (Object)name);
        return (PropertyKey)pk;
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name, Object value) {
        return this.getOrCreatePropertyKey(name, value, null);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name, Object value, VertexProperty.Cardinality cardinality) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            PropertyKeyMaker propertyKeyMaker = this.makePropertyKey(name);
            if (cardinality != null) {
                propertyKeyMaker = propertyKeyMaker.cardinality(cardinality);
            }
            return this.config.getAutoSchemaMaker().makePropertyKey(propertyKeyMaker, value);
        }
        if (et.isPropertyKey()) {
            return (PropertyKey)et;
        }
        throw new IllegalArgumentException("The type of given name is not a key: " + name);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makePropertyKey(this.makePropertyKey(name));
        }
        if (et.isPropertyKey()) {
            return (PropertyKey)et;
        }
        throw new IllegalArgumentException("The type of given name is not a key: " + name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        RelationType el = this.getRelationType(name);
        Preconditions.checkArgument((el == null || el.isEdgeLabel() ? 1 : 0) != 0, (String)"The relation type with name [%s] is not an edge label", (Object)name);
        return (EdgeLabel)el;
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        RelationType et = this.getRelationType(name);
        if (et == null) {
            return this.config.getAutoSchemaMaker().makeEdgeLabel(this.makeEdgeLabel(name));
        }
        if (et.isEdgeLabel()) {
            return (EdgeLabel)et;
        }
        throw new IllegalArgumentException("The type of given name is not a label: " + name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return new StandardPropertyKeyMaker(this, name, this.indexSerializer, this.attributeHandler);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return new StandardEdgeLabelMaker(this, name, this.indexSerializer, this.attributeHandler);
    }

    @Override
    public VertexLabel getExistingVertexLabel(long id) {
        assert (this.idInspector.isVertexLabelVertexId(id));
        InternalVertex v = this.getInternalVertex(id);
        return (VertexLabelVertex)v;
    }

    @Override
    public boolean containsVertexLabel(String name) {
        this.verifyOpen();
        return BaseVertexLabel.DEFAULT_VERTEXLABEL.name().equals(name) || this.getSchemaVertex(JanusGraphSchemaCategory.VERTEXLABEL.getSchemaName(name)) != null;
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        this.verifyOpen();
        if (BaseVertexLabel.DEFAULT_VERTEXLABEL.name().equals(name)) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabel)((Object)this.getSchemaVertex(JanusGraphSchemaCategory.VERTEXLABEL.getSchemaName(name)));
    }

    @Override
    public VertexLabel getOrCreateVertexLabel(String name) {
        VertexLabel vertexLabel = this.getVertexLabel(name);
        if (vertexLabel == null) {
            vertexLabel = this.config.getAutoSchemaMaker().makeVertexLabel(this.makeVertexLabel(name));
        }
        return vertexLabel;
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        StandardVertexLabelMaker maker = new StandardVertexLabelMaker(this);
        maker.name(name);
        return maker;
    }

    public VertexCentricQueryBuilder query(JanusGraphVertex vertex) {
        return new VertexCentricQueryBuilder(((InternalVertex)vertex).it());
    }

    public JanusGraphMultiVertexQuery multiQuery(JanusGraphVertex ... vertices) {
        MultiVertexCentricQueryBuilder builder = vertices.length == 0 ? new MultiVertexCentricQueryBuilder(this) : new MultiVertexCentricQueryBuilder(this, vertices.length);
        for (JanusGraphVertex v : vertices) {
            builder.addVertex(v);
        }
        return builder;
    }

    public JanusGraphMultiVertexQuery multiQuery(Collection<JanusGraphVertex> vertices) {
        MultiVertexCentricQueryBuilder builder = new MultiVertexCentricQueryBuilder(this, vertices.size());
        builder.addAllVertices(vertices);
        return builder;
    }

    public void executeMultiQuery(Collection<InternalVertex> vertices, SliceQuery sq, QueryProfiler profiler) {
        ArrayList<Object> vertexIds = new ArrayList<Object>(vertices.size());
        for (InternalVertex v : vertices) {
            if (v.isNew() || !v.hasId() || !(v instanceof CacheVertex) || v.hasLoadedRelations(sq)) continue;
            vertexIds.add(v.id());
        }
        if (!vertexIds.isEmpty()) {
            List results = QueryProfiler.profile(profiler, sq, true, q -> this.graph.edgeMultiQuery((List<Object>)vertexIds, (SliceQuery)q, this.txHandle));
            int pos = 0;
            for (JanusGraphVertex janusGraphVertex : vertices) {
                if (pos >= vertexIds.size() || !vertexIds.get(pos).equals(janusGraphVertex.id())) continue;
                EntryList vresults = (EntryList)results.get(pos);
                ((CacheVertex)janusGraphVertex).loadRelations(sq, query -> vresults);
                ++pos;
            }
        }
    }

    public void executeMultiSliceMultiQuery(Collection<InternalVertex> vertices, List<BackendQueryHolder<SliceQuery>> queries, QueryProfiler profiler) {
        MultiKeysQueryGroups<Object, SliceQuery> groupedMultiSliceQueries = MultiSliceQueriesGroupingUtil.toMultiKeysQueryGroups(vertices, queries);
        if (!groupedMultiSliceQueries.getQueryGroups().isEmpty()) {
            Map allResults = QueryProfiler.profile(profiler, groupedMultiSliceQueries, true, q -> this.graph.edgeMultiQuery((MultiKeysQueryGroups<Object, SliceQuery>)q, this.txHandle));
            Map<Object, JanusGraphVertex> vertexIdToVertexMap = vertices.stream().collect(Collectors.toMap(JanusGraphElement::id, v -> v));
            allResults.forEach((sliceQuery, resultsPerQuery) -> resultsPerQuery.forEach((vertexId, vertexSliceResult) -> ((CacheVertex)vertexIdToVertexMap.get(vertexId)).loadRelations((SliceQuery)sliceQuery, query -> vertexSliceResult)));
        }
    }

    public java.util.function.Function<Object, ? extends JanusGraphElement> getConversionFunction(ElementCategory elementCategory) {
        switch (elementCategory) {
            case VERTEX: {
                return this.vertexIDConversionFct;
            }
            case EDGE: {
                return this.edgeIDConversionFct;
            }
            case PROPERTY: {
                return this.propertyIDConversionFct;
            }
        }
        throw new IllegalArgumentException("Unexpected result type: " + (Object)((Object)elementCategory));
    }

    public GraphCentricQueryBuilder query() {
        return new GraphCentricQueryBuilder(this, this.graph.getIndexSerializer(), this.indexSelector);
    }

    @Override
    public MixedIndexAggQuery mixedIndexAggQuery() {
        return new MixedIndexAggQueryBuilder(this.indexSerializer, this.txHandle);
    }

    @Override
    public JanusGraphIndexQuery indexQuery(String indexName, String query) {
        return new IndexQueryBuilder(this, this.indexSerializer).setIndex(indexName).setQuery(query);
    }

    @Override
    public synchronized void commit() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit").inc();
        }
        try {
            if (this.hasModifications()) {
                this.graph.commit(this.addedRelations.getAllUnsafe(), this.deletedRelations.values(), this);
            } else {
                this.txHandle.commit();
            }
            success = true;
            this.releaseTransaction();
        }
        catch (Exception e) {
            try {
                try {
                    this.txHandle.rollback();
                }
                catch (BackendException e1) {
                    throw new JanusGraphException("Could not rollback after a failed commit", e);
                }
                throw new JanusGraphException("Could not commit transaction due to exception during persistence", e);
            }
            catch (Throwable throwable) {
                this.releaseTransaction();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "commit.exceptions").inc();
        }
    }

    @Override
    public synchronized void rollback() {
        Preconditions.checkArgument((boolean)this.isOpen(), (Object)"The transaction has already been closed");
        boolean success = false;
        if (null != this.config.getGroupName()) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback").inc();
        }
        try {
            this.txHandle.rollback();
            success = true;
            this.releaseTransaction();
        }
        catch (Exception e) {
            try {
                throw new JanusGraphException("Could not rollback transaction due to exception", e);
            }
            catch (Throwable throwable) {
                this.releaseTransaction();
                if (null != this.config.getGroupName() && !success) {
                    MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
                }
                throw throwable;
            }
        }
        if (null != this.config.getGroupName() && !success) {
            MetricManager.INSTANCE.getCounter(this.config.getGroupName(), "tx", "rollback.exceptions").inc();
        }
    }

    private void releaseTransaction() {
        this.isOpen = false;
        this.graph.closeTransaction(this);
        this.vertexCache = EmptyVertexCache.getInstance();
        this.indexCache = EmptySubqueryCache.getInstance();
        this.addedRelations = EmptyAddedRelations.getInstance();
        this.deletedRelations = Collections.emptyMap();
        this.uniqueLocks = Collections.emptyMap();
        this.newVertexIndexEntries = EmptyIndexCache.getInstance();
        this.newTypeCache = Collections.emptyMap();
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public boolean hasModifications() {
        return !this.addedRelations.isEmpty() || !this.deletedRelations.isEmpty();
    }

    @Override
    public void expireSchemaElement(long id) {
        InternalVertex v;
        if (this.vertexCache.contains(id) && (v = this.vertexCache.get(id, this.externalVertexRetriever)) instanceof JanusGraphSchemaVertex) {
            String store;
            IndexType indexType;
            JanusGraphSchemaVertex sv = (JanusGraphSchemaVertex)v;
            sv.resetCache();
            if (sv.getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX) && (indexType = sv.asIndexType()).isMixedIndex() && this.txHandle.hasIndexTransaction(store = indexType.getBackingIndexName())) {
                IndexTransaction indexTx = this.txHandle.getIndexTransaction(store);
                indexTx.invalidate(sv.name());
            }
        }
    }

    private class VertexConstructor
    implements Retriever<Object, InternalVertex> {
        private final boolean verifyExistence;
        private final boolean createStubVertex;

        private VertexConstructor(boolean verifyExistence, boolean createStubVertex) {
            this.verifyExistence = verifyExistence;
            this.createStubVertex = createStubVertex;
        }

        public boolean hasVerifyExistence() {
            return this.verifyExistence;
        }

        @Override
        public InternalVertex get(Object vertexId) {
            InternalVertex vertex;
            Object canonicalVertexId;
            IDUtils.checkId((Object)vertexId);
            Preconditions.checkArgument((StandardJanusGraphTx.this.idInspector.isSchemaVertexId(vertexId) || StandardJanusGraphTx.this.idInspector.isUserVertexId(vertexId) ? 1 : 0) != 0, (String)"Not a valid vertex id: %s", (Object)vertexId);
            byte lifecycle = 2;
            Object object = canonicalVertexId = StandardJanusGraphTx.this.idInspector.isPartitionedVertex(vertexId) ? Long.valueOf(StandardJanusGraphTx.this.idManager.getCanonicalVertexId(((Number)vertexId).longValue())) : vertexId;
            if (this.verifyExistence && StandardJanusGraphTx.this.graph.edgeQuery(canonicalVertexId, ((StandardJanusGraphTx)StandardJanusGraphTx.this).graph.vertexExistenceQuery, StandardJanusGraphTx.this.txHandle).isEmpty()) {
                lifecycle = 6;
            }
            if (!vertexId.equals(canonicalVertexId)) {
                lifecycle = StandardJanusGraphTx.this.getExistingVertex(canonicalVertexId).getLifeCycle();
            }
            if (StandardJanusGraphTx.this.idInspector.isRelationTypeId(vertexId)) {
                if (StandardJanusGraphTx.this.idInspector.isPropertyKeyId(vertexId)) {
                    vertex = IDManager.isSystemRelationTypeId(vertexId) ? SystemTypeManager.getSystemType(((Number)vertexId).longValue()) : new PropertyKeyVertex(StandardJanusGraphTx.this, ((Number)vertexId).longValue(), lifecycle);
                } else {
                    assert (StandardJanusGraphTx.this.idInspector.isEdgeLabelId(vertexId));
                    vertex = IDManager.isSystemRelationTypeId(vertexId) ? SystemTypeManager.getSystemType(((Number)vertexId).longValue()) : new EdgeLabelVertex(StandardJanusGraphTx.this, ((Number)vertexId).longValue(), lifecycle);
                }
            } else if (StandardJanusGraphTx.this.idInspector.isVertexLabelVertexId(vertexId)) {
                vertex = new VertexLabelVertex(StandardJanusGraphTx.this, ((Number)vertexId).longValue(), lifecycle);
            } else if (StandardJanusGraphTx.this.idInspector.isGenericSchemaVertexId(vertexId)) {
                vertex = new JanusGraphSchemaVertex(StandardJanusGraphTx.this, vertexId, lifecycle);
            } else if (StandardJanusGraphTx.this.idInspector.isUserVertexId(vertexId)) {
                vertex = this.createStubVertex ? new PreloadedVertex(StandardJanusGraphTx.this, vertexId, lifecycle) : new CacheVertex(StandardJanusGraphTx.this, vertexId, lifecycle);
            } else {
                throw new IllegalArgumentException("ID could not be recognized");
            }
            return vertex;
        }
    }
}

