/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.index.AbstractIndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexCandidate;
import org.janusgraph.graphdb.query.index.IndexCandidateGroup;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.util.datastructures.PowerSet;

public class BruteForceIndexSelectionStrategy
extends AbstractIndexSelectionStrategy {
    public static final String NAME = "brute-force";

    public BruteForceIndexSelectionStrategy(Configuration config) {
        super(config);
    }

    @Override
    public IndexSelectionStrategy.SelectedIndexQuery selectIndices(Set<IndexType> rawCandidates, MultiCondition<JanusGraphElement> conditions, Set<Condition> coveredClauses, OrderList orders, IndexSerializer serializer) {
        JointIndexQuery jointQuery = new JointIndexQuery();
        HashSet<IndexCandidate> indexCandidates = new HashSet<IndexCandidate>();
        boolean isSorted = orders.isEmpty();
        for (IndexType indexType : rawCandidates) {
            IndexCandidate indexCandidate = this.createIndexCandidate(indexType, conditions, serializer);
            if (indexCandidate == null) continue;
            indexCandidate.setScore(this.calculateIndexCandidateScore(indexCandidate));
            indexCandidates.add(indexCandidate);
        }
        IndexCandidateGroup bestGroup = null;
        for (Set<IndexCandidate> set : new PowerSet(indexCandidates)) {
            IndexCandidateGroup group;
            if (set.isEmpty() || (group = new IndexCandidateGroup(set)).compareTo(bestGroup) <= 0) continue;
            bestGroup = group;
        }
        if (bestGroup != null) {
            coveredClauses.addAll(bestGroup.getCoveredClauses());
            ArrayList<IndexCandidate> arrayList = new ArrayList<IndexCandidate>(bestGroup.getIndexCandidates());
            arrayList.sort((a, b) -> Double.compare(b.getScore(), a.getScore()));
            isSorted = orders.isEmpty() || ((IndexCandidate)arrayList.get(0)).getIndex().isMixedIndex() && IndexSelectionUtil.indexCoversOrder((MixedIndexType)((IndexCandidate)arrayList.get(0)).getIndex(), orders);
            for (IndexCandidate c : arrayList) {
                this.addToJointQuery(c, jointQuery, serializer, orders);
            }
        }
        return new IndexSelectionStrategy.SelectedIndexQuery(jointQuery, isSorted);
    }

    private double calculateIndexCandidateScore(IndexCandidate ic) {
        double score = 0.0;
        for (Condition c : ic.getSubCover()) {
            score += this.getConditionBasicScore(c) + this.getIndexTypeScore(ic.getIndex());
        }
        return score;
    }
}

