/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaManager;
import org.janusgraph.core.schema.VertexLabelMaker;

public class DisableDefaultSchemaMaker
implements DefaultSchemaMaker {
    public static final DefaultSchemaMaker INSTANCE = new DisableDefaultSchemaMaker();

    @Override
    public EdgeLabel makeEdgeLabel(EdgeLabelMaker factory) {
        throw new IllegalArgumentException("Edge Label with given name does not exist: " + factory.getName());
    }

    @Override
    public Cardinality defaultPropertyCardinality(String key) {
        return Cardinality.SINGLE;
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory) {
        throw new IllegalArgumentException("Property Key with given name does not exist: " + factory.getName());
    }

    @Override
    public VertexLabel makeVertexLabel(VertexLabelMaker factory) {
        throw new IllegalArgumentException("Vertex Label with given name does not exist: " + factory.getName());
    }

    @Override
    public boolean ignoreUndefinedQueryTypes() {
        return false;
    }

    @Override
    public void makePropertyConstraintForEdge(EdgeLabel edgeLabel, PropertyKey key, SchemaManager manager) {
        throw new IllegalArgumentException(String.format("Property Key constraint does not exist for given Edge Label [%s] and property key [%s].", edgeLabel, key));
    }

    @Override
    public void makePropertyConstraintForVertex(VertexLabel vertexLabel, PropertyKey key, SchemaManager manager) {
        throw new IllegalArgumentException(String.format("Property Key constraint does not exist for given Vertex Label [%s] and property key [%s].", vertexLabel, key));
    }

    @Override
    public void makeConnectionConstraint(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel, SchemaManager manager) {
        throw new IllegalArgumentException(String.format("Connection constraint does not exist for given Edge Label [%s], outgoing Vertex Label [%s] and incoming Vertex Label [%s]", edgeLabel, outVLabel, inVLabel));
    }
}

