/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractKeyedCheckSumTypeHandler;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.provider.Md5Provider;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Hmac;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.crypto.util.Rc4;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;

public class HmacMd5Rc4CheckSum
extends AbstractKeyedCheckSumTypeHandler {
    public HmacMd5Rc4CheckSum() {
        super(null, new Md5Provider(), 16, 16);
    }

    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public CheckSumType cksumType() {
        return CheckSumType.HMAC_MD5_ARCFOUR;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keySize() {
        return 16;
    }

    @Override
    protected byte[] doChecksumWithKey(byte[] data, int start, int len, byte[] key, int usage) throws KrbException {
        byte[] signKey = "signaturekey".getBytes(StandardCharsets.UTF_8);
        byte[] newSignKey = new byte[signKey.length + 1];
        System.arraycopy(signKey, 0, newSignKey, 0, signKey.length);
        byte[] ksign = Hmac.hmac(this.hashProvider(), key, newSignKey);
        byte[] salt = Rc4.getSalt(usage, false);
        this.hashProvider().hash(salt);
        this.hashProvider().hash(data, start, len);
        byte[] hashTmp = this.hashProvider().output();
        return Hmac.hmac(this.hashProvider(), ksign, hashTmp);
    }
}

