/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Deleting;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.Writing;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public abstract class MergeStep<S, E, C>
extends FlatMapStep<S, E>
implements Writing<Event>,
Deleting<Event>,
TraversalOptionParent<Merge, S, C> {
    protected final boolean isStart;
    protected boolean first = true;
    protected Traversal.Admin<S, Map> mergeTraversal;
    protected Traversal.Admin<S, Map> onCreateTraversal = null;
    protected Traversal.Admin<S, Map<String, ?>> onMatchTraversal = null;
    protected CallbackRegistry<Event> callbackRegistry;
    private Parameters parameters = new Parameters();
    private boolean usesPartitionStrategy;

    public MergeStep(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, new IdentityTraversal());
    }

    public MergeStep(Traversal.Admin traversal, boolean isStart, Map mergeMap) {
        this(traversal, isStart, new ConstantTraversal(mergeMap));
        this.validate(mergeMap, false);
    }

    public MergeStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin mergeTraversal) {
        super(traversal);
        this.isStart = isStart;
        this.mergeTraversal = this.integrateChild(mergeTraversal);
        this.usesPartitionStrategy = TraversalHelper.getRootTraversal(traversal).getStrategies().getStrategy(PartitionStrategy.class).isPresent();
    }

    public Traversal.Admin<S, Map> getMergeTraversal() {
        return this.mergeTraversal;
    }

    public Traversal.Admin<S, Map> getOnCreateTraversal() {
        return this.onCreateTraversal;
    }

    public Traversal.Admin<S, Map<String, ?>> getOnMatchTraversal() {
        return this.onMatchTraversal;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isFirst() {
        return this.first;
    }

    public CallbackRegistry<Event> getCallbackRegistry() {
        return this.callbackRegistry;
    }

    @Override
    public void addChildOption(Merge token, Traversal.Admin<S, C> traversalOption) {
        if (token == Merge.onCreate) {
            this.onCreateTraversal = this.integrateChild(traversalOption);
        } else if (token == Merge.onMatch) {
            this.onMatchTraversal = this.integrateChild(traversalOption);
        } else {
            throw new UnsupportedOperationException(String.format("Option %s for Merge is not supported", token.name()));
        }
    }

    public <S, C> List<Traversal.Admin<S, C>> getLocalChildren() {
        ArrayList<Traversal.Admin<S, C>> children = new ArrayList<Traversal.Admin<S, C>>();
        if (this.mergeTraversal != null) {
            children.add(this.mergeTraversal);
        }
        if (this.onMatchTraversal != null) {
            children.add(this.onMatchTraversal);
        }
        if (this.onCreateTraversal != null) {
            children.add(this.onCreateTraversal);
        }
        return children;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(this, keyValues);
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    protected Traverser.Admin<E> processNextStart() {
        if (this.isStart && this.first) {
            this.first = false;
            this.generateTraverser(false);
        }
        return super.processNextStart();
    }

    private void generateTraverser(Object o) {
        TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
        this.addStart(generator.generate(o, this, 1L));
    }

    protected Graph getGraph() {
        return this.getTraversal().getGraph().get();
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event>();
        }
        return this.callbackRegistry;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.mergeTraversal != null) {
            result ^= this.mergeTraversal.hashCode();
        }
        if (this.onCreateTraversal != null) {
            result ^= this.onCreateTraversal.hashCode();
        }
        if (this.onMatchTraversal != null) {
            result ^= this.onMatchTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        this.first = true;
        this.mergeTraversal.reset();
        if (this.onCreateTraversal != null) {
            this.onCreateTraversal.reset();
        }
        if (this.onMatchTraversal != null) {
            this.onMatchTraversal.reset();
        }
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.mergeTraversal, this.onCreateTraversal, this.onMatchTraversal);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.mergeTraversal);
        this.integrateChild(this.onCreateTraversal);
        this.integrateChild(this.onMatchTraversal);
    }

    @Override
    public MergeStep<S, E, C> clone() {
        MergeStep clone = (MergeStep)super.clone();
        clone.mergeTraversal = this.mergeTraversal.clone();
        clone.onCreateTraversal = this.onCreateTraversal != null ? this.onCreateTraversal.clone() : null;
        clone.onMatchTraversal = this.onMatchTraversal != null ? this.onMatchTraversal.clone() : null;
        return clone;
    }

    protected void validate(Map map, boolean ignoreTokens) {
        Set allowedTokens = this.getAllowedTokens();
        MergeStep.validate(map, ignoreTokens, allowedTokens, this instanceof MergeVertexStep ? "mergeV" : "mergeE");
    }

    protected static void validate(Map map, boolean ignoreTokens, Set allowedTokens, String op) {
        if (null == map) {
            return;
        }
        map.entrySet().forEach(e -> {
            Object k = e.getKey();
            Object v = e.getValue();
            if (v == null) {
                throw new IllegalArgumentException(String.format("%s() does not allow null Map values - check: %s", op, k));
            }
            if (ignoreTokens) {
                if (!(k instanceof String)) {
                    throw new IllegalArgumentException(String.format("option(onMatch) expects keys in Map to be of String - check: %s", k));
                }
                ElementHelper.validateProperty((String)k, v);
            } else {
                if (!(k instanceof String) && !allowedTokens.contains(k)) {
                    throw new IllegalArgumentException(String.format("%s() and option(onCreate) args expect keys in Map to be either String or %s - check: %s", op, allowedTokens, k));
                }
                if (k == T.label) {
                    if (!(v instanceof String)) {
                        throw new IllegalArgumentException(String.format("%s() and option(onCreate) args expect T.label value to be of String - found: %s", op, v.getClass().getSimpleName()));
                    }
                    ElementHelper.validateLabel((String)v);
                }
                if (k == Direction.OUT && v instanceof Merge && v != Merge.outV) {
                    throw new IllegalArgumentException(String.format("Only Merge.outV token may be used for Direction.OUT, found: %s", v));
                }
                if (k == Direction.IN && v instanceof Merge && v != Merge.inV) {
                    throw new IllegalArgumentException(String.format("Only Merge.inV token may be used for Direction.IN, found: %s", v));
                }
                if (k instanceof String) {
                    ElementHelper.validateProperty((String)k, v);
                }
            }
        });
    }

    protected void validateNoOverrides(Map<?, ?> mergeMap, Map<?, ?> onCreateMap) {
        for (Map.Entry<?, ?> e : onCreateMap.entrySet()) {
            Object k = e.getKey();
            Object v = e.getValue();
            if (!mergeMap.containsKey(k) || Objects.equals(v, mergeMap.get(k))) continue;
            throw new IllegalArgumentException(String.format("option(onCreate) cannot override values from merge() argument: (%s, %s)", k, v));
        }
    }

    protected Map materializeMap(Traverser.Admin<S> traverser, Traversal.Admin<S, ?> mapTraversal) {
        Map map = (Map)TraversalUtil.apply(traverser, mapTraversal);
        if (this.usesPartitionStrategy) {
            map = null == map ? new LinkedHashMap() : map;
            for (Map.Entry<Object, List<Object>> entry : this.parameters.getRaw(new Object[0]).entrySet()) {
                Object k = entry.getKey();
                List<Object> v = entry.getValue();
                map.put(k, v.get(0));
            }
        }
        return map == null ? new LinkedHashMap() : map;
    }

    protected CloseableIterator<Vertex> searchVertices(Map search) {
        if (search == null) {
            return CloseableIterator.empty();
        }
        Graph graph = this.getGraph();
        Object id = search.get(T.id);
        String label = (String)search.get(T.label);
        GraphTraversal t = this.searchVerticesTraversal(graph, id);
        t = this.searchVerticesLabelConstraint(t, label);
        t = this.searchVerticesPropertyConstraints(t, search);
        return CloseableIterator.of(t);
    }

    protected GraphTraversal searchVerticesTraversal(Graph graph, Object id) {
        return id != null ? graph.traversal().V(id) : graph.traversal().V(new Object[0]);
    }

    protected GraphTraversal searchVerticesLabelConstraint(GraphTraversal t, String label) {
        return label != null ? t.hasLabel(label, new String[0]) : t;
    }

    protected GraphTraversal searchVerticesPropertyConstraints(GraphTraversal t, Map search) {
        for (Map.Entry e : search.entrySet()) {
            Object k = e.getKey();
            if (!(k instanceof String)) continue;
            t = t.has((String)k, e.getValue());
        }
        return t;
    }

    @Override
    protected abstract Iterator<E> flatMap(Traverser.Admin<S> var1);

    protected abstract Set getAllowedTokens();
}

